/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.plugin;

import adams.core.logging.LoggingObject;
import adams.gui.core.GUIHelper;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public abstract class AbstractToolPlugin<T extends JPanel>
extends LoggingObject {
    private static final long serialVersionUID = -8139858776265449470L;
    protected static Hashtable<Class, Object> m_LastSetup = new Hashtable();
    protected T m_CurrentPanel;
    protected boolean m_CanceledByUser;

    public String getMenu() {
        return "Plugins";
    }

    public abstract String getCaption();

    public String getIconName() {
        return null;
    }

    public ImageIcon getIcon() {
        ImageIcon result = this.getIconName() != null ? (this.getIconName().contains("/") ? GUIHelper.getExternalIcon(this.getIconName()) : GUIHelper.getIcon(this.getIconName())) : GUIHelper.getEmptyIcon();
        return result;
    }

    protected boolean hasLastSetup() {
        return m_LastSetup.containsKey(this.getClass());
    }

    protected Object getLastSetup() {
        return m_LastSetup.get(this.getClass());
    }

    protected void setLastSetup(Object setup) {
        m_LastSetup.put(this.getClass(), setup);
    }

    public boolean getCanceledByUser() {
        return this.m_CanceledByUser;
    }

    public abstract boolean canExecute(T var1);

    protected abstract String doExecute();

    protected abstract String createLogEntry();

    protected abstract void doLog(String var1);

    protected void log() {
        String msg = this.createLogEntry();
        if (msg != null) {
            this.doLog(msg);
        }
    }

    public String execute(T panel) {
        this.m_CurrentPanel = panel;
        this.m_CanceledByUser = false;
        String result = this.doExecute();
        if (result == null) {
            this.log();
        }
        return result;
    }
}

