/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.scripting;

import adams.core.ClassLister;
import adams.core.logging.LoggingObject;
import adams.core.option.OptionUtils;
import adams.db.DataProvider;
import adams.gui.core.BasePanel;
import adams.gui.scripting.AbstractCommandProcessor;
import java.util.Hashtable;

public abstract class AbstractScriptlet
extends LoggingObject
implements Comparable {
    private static final long serialVersionUID = 8460215813832005436L;
    protected AbstractCommandProcessor m_Owner;
    protected DataProvider m_DataProvider;
    protected Hashtable<String, Object> m_Parameters;

    public AbstractScriptlet() {
        this.setOwner(null);
    }

    public void setOwner(AbstractCommandProcessor value) {
        this.m_Owner = value;
        this.initialize();
    }

    protected void initialize() {
        this.m_Parameters = new Hashtable();
    }

    public AbstractCommandProcessor getOwner() {
        return this.m_Owner;
    }

    public boolean hasOwner() {
        return this.m_Owner != null;
    }

    public void setParameter(String key, Object value) {
        this.m_Parameters.put(key, value);
    }

    public boolean hasParameter(String key) {
        return this.m_Parameters.containsKey(key);
    }

    public Object getParameter(String key, Object defValue) {
        if (this.m_Parameters.containsKey(key)) {
            return this.m_Parameters.get(key);
        }
        return defValue;
    }

    public void setDataProvider(DataProvider value) {
        this.m_DataProvider = value;
    }

    public DataProvider getDataProvider() {
        return this.m_DataProvider;
    }

    public BasePanel getBasePanel() {
        if (this.hasOwner()) {
            return this.getOwner().getBasePanel();
        }
        return null;
    }

    protected void showStatus(String msg) {
        if (this.hasOwner()) {
            this.getOwner().showStatus(msg);
        }
    }

    public abstract String getAction();

    public String getParameterDescription() {
        String result = this.getAction();
        if (this.getOptionsDescription() != null) {
            result = result + " " + this.getOptionsDescription();
        }
        return result;
    }

    protected String getOptionsDescription() {
        return null;
    }

    public abstract String getDescription();

    public Class[] getRequirements() {
        return null;
    }

    public abstract String process(String var1) throws Exception;

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        if (!(o instanceof AbstractScriptlet)) {
            return -1;
        }
        return this.getAction().compareTo(((AbstractScriptlet)o).getAction());
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public int hashCode() {
        return this.getAction().hashCode();
    }

    public String toString() {
        String result = this.getAction();
        Class[] cls = this.getRequirements();
        if (cls != null) {
            result = result + ", requires=";
            for (int i = 0; i < cls.length; ++i) {
                if (i > 0) {
                    result = result + ",";
                }
                result = result + cls[i].getName();
            }
        }
        result = result + ", parameters=" + this.m_Parameters;
        return result;
    }

    public static String[] getScriptlets() {
        return ClassLister.getSingleton().getClassnames(AbstractScriptlet.class);
    }

    public static AbstractScriptlet forName(String classname) {
        AbstractScriptlet result;
        try {
            result = (AbstractScriptlet)OptionUtils.forName(AbstractScriptlet.class, classname, new String[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }
}

