/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.scripting;

import adams.core.Utils;
import adams.core.option.OptionUtils;
import adams.data.io.input.AbstractDataContainerReader;
import adams.gui.scripting.AbstractDataContainerPanelScriptlet;
import adams.gui.visualization.container.AbstractContainerManager;
import java.util.ArrayList;
import java.util.List;

public class AddDataFile
extends AbstractDataContainerPanelScriptlet {
    private static final long serialVersionUID = -3048379013750352301L;
    public static final String ACTION = "add-data-file";

    @Override
    public String getAction() {
        return ACTION;
    }

    @Override
    protected String getOptionsDescription() {
        return "<datacontainer-reader scheme>";
    }

    @Override
    public String getDescription() {
        return "Adds the data container loaded via the given reader to the currently loaded ones.";
    }

    @Override
    public String process(String options) throws Exception {
        List data;
        String result = null;
        AbstractDataContainerReader reader = AbstractDataContainerReader.forCommandLine(options);
        this.addUndoPoint("Saving undo data...", "Loading data with: " + OptionUtils.getCommandLine(reader));
        try {
            data = reader.read();
        }
        catch (Exception e) {
            data = new ArrayList();
            result = "Error reading data: " + Utils.throwableToString(e);
            this.getLogger().severe(result);
        }
        if (result == null) {
            Object manager = this.getDataContainerPanel().getContainerManager();
            ArrayList cont = new ArrayList();
            for (int i = 0; i < data.size(); ++i) {
                cont.add(((AbstractContainerManager)manager).newContainer((Comparable)data.get(i)));
            }
            ((AbstractContainerManager)manager).addAll(cont);
        }
        this.showStatus("");
        return result;
    }
}

