/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.sendto;

import adams.core.io.FileUtils;
import adams.flow.sink.TextSupplier;
import adams.gui.chooser.TextFileChooser;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.sendto.AbstractSendToAction;

public class TextFile
extends AbstractSendToAction {
    private static final long serialVersionUID = -6880030063760028278L;

    @Override
    public String getAction() {
        return "Text file";
    }

    @Override
    public String getIconName() {
        return "editor.gif";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class};
    }

    @Override
    public String send(Object o) {
        String result = null;
        if (o instanceof String) {
            int retVal;
            TextFileChooser fileChooser = new TextFileChooser();
            ExtensionFileFilter filter = null;
            if (this.getOwner() instanceof TextSupplier) {
                filter = ((TextSupplier)((Object)this.getOwner())).getCustomTextFileFilter();
            }
            if (filter != null) {
                fileChooser.resetChoosableFileFilters();
                fileChooser.addChoosableFileFilter(filter);
                fileChooser.setFileFilter(filter);
                fileChooser.setDefaultExtension(filter.getExtensions()[0]);
            }
            if ((retVal = fileChooser.showSaveDialog(null)) != 0) {
                return "Save dialog canceled!";
            }
            String msg = FileUtils.writeToFileMsg(fileChooser.getSelectedFile().getAbsolutePath(), o, false, fileChooser.getEncoding());
            if (msg != null) {
                result = "Failed to write text to '" + fileChooser.getSelectedFile() + "':\n" + msg;
            }
        } else {
            result = "Cannot save as text: " + o.getClass();
        }
        return result;
    }
}

