/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core;

import adams.core.VariableName;
import adams.flow.core.Actor;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AbstractPaintlet;
import adams.gui.visualization.core.FlowAwarePaintlet;
import java.awt.Color;
import java.awt.Graphics;

public class TextOverlayPaintlet
extends AbstractPaintlet
implements FlowAwarePaintlet {
    private static final long serialVersionUID = 7923819857566247771L;
    protected Actor m_Actor;
    protected String m_Text;
    protected VariableName m_TextVariable;
    protected int m_X;
    protected int m_Y;
    protected Color m_Color;

    @Override
    public String globalInfo() {
        return "Simply paints the specified text at a certain location.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("text", "text", "");
        this.m_OptionManager.add("text-variable", "textVariable", new VariableName());
        this.m_OptionManager.add("x", "X", 5, 1, null);
        this.m_OptionManager.add("y", "Y", 20, 1, null);
        this.m_OptionManager.add("color", "color", Color.BLACK);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Actor = null;
    }

    @Override
    public void setActor(Actor actor) {
        this.m_Actor = actor;
        this.memberChanged();
    }

    @Override
    public Actor getActor() {
        return this.m_Actor;
    }

    public void setText(String value) {
        this.m_Text = value;
        this.memberChanged();
    }

    public String getText() {
        return this.m_Text;
    }

    public String textTipText() {
        return "The text to paint.";
    }

    public void setTextVariable(VariableName value) {
        this.m_TextVariable = value;
        this.memberChanged();
    }

    public VariableName getTextVariable() {
        return this.m_TextVariable;
    }

    public String textVariableTipText() {
        return "The variable containing the text to paint.";
    }

    public void setX(int value) {
        this.m_X = value;
        this.memberChanged();
    }

    public int getX() {
        return this.m_X;
    }

    public String XTipText() {
        return "The X position in pixels.";
    }

    public void setY(int value) {
        this.m_Y = value;
        this.memberChanged();
    }

    public int getY() {
        return this.m_Y;
    }

    public String YTipText() {
        return "The Y position in pixels.";
    }

    public void setColor(Color value) {
        this.m_Color = value;
        this.memberChanged();
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color for the text.";
    }

    @Override
    public PaintEvent.PaintMoment getPaintMoment() {
        return PaintEvent.PaintMoment.POST_PAINT;
    }

    @Override
    public void performPaint(Graphics g, PaintEvent.PaintMoment moment) {
        String text = "";
        if (this.m_Actor != null && this.m_Actor.getVariables().has(this.m_TextVariable.getValue())) {
            text = this.m_Actor.getVariables().get(this.m_TextVariable.getValue());
        }
        if (text.isEmpty()) {
            text = this.m_Text;
        }
        g.setColor(this.m_Color);
        g.drawString(text, this.m_X, this.m_Y);
    }
}

