/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.debug;

import adams.core.DiffUtils;
import adams.core.Utils;
import adams.gui.core.BaseTextPaneWithWordWrap;
import adams.gui.core.ColorHelper;
import adams.gui.core.GUIHelper;
import java.awt.Color;
import java.util.List;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class DiffTextPane
extends BaseTextPaneWithWordWrap {
    private static final long serialVersionUID = -8695413301813792099L;
    boolean m_Left;
    protected DiffUtils.SideBySideDiff m_Diff;
    protected Color m_ColorDeleted;
    protected Color m_ColorAdded;
    protected Color m_ColorRight;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Left = true;
        this.m_Diff = new DiffUtils.SideBySideDiff();
        this.m_ColorDeleted = GUIHelper.getColor(this.getClass(), "Deleted.Color", ColorHelper.valueOf("#9999FF"));
        this.m_ColorAdded = GUIHelper.getColor(this.getClass(), "Added.Color", ColorHelper.valueOf("#CCFFFF"));
        this.m_ColorRight = GUIHelper.getColor(this.getClass(), "Right.Color", ColorHelper.valueOf("#FFCCCC"));
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.getTextPane().setFont(GUIHelper.getMonospacedFont());
        this.getTextPane().setEditable(false);
        this.setWordWrap(false);
    }

    public void setLeft(boolean value) {
        this.m_Left = value;
        this.update();
    }

    public boolean isLeft() {
        return this.m_Left;
    }

    public void setDiff(DiffUtils.SideBySideDiff value) {
        this.m_Diff = value.clone();
        this.update();
    }

    public DiffUtils.SideBySideDiff getDiff() {
        return this.m_Diff;
    }

    protected void update() {
        int width = Integer.toString(this.m_Diff.getLeft().size()).length();
        List diff = this.m_Left ? this.m_Diff.getLeft() : this.m_Diff.getRight();
        this.getTextPane().setText("");
        int lineNo = 0;
        StyledDocument doc = this.getTextPane().getStyledDocument();
        SimpleAttributeSet lines = new SimpleAttributeSet();
        StyleConstants.setBold(lines, true);
        StyleConstants.setFontFamily(lines, "monospaced");
        SimpleAttributeSet normal = new SimpleAttributeSet();
        StyleConstants.setFontFamily(normal, "monospaced");
        for (int i = 0; i < diff.size(); ++i) {
            Object obj = diff.get(i);
            Character ind = (Character)this.m_Diff.getIndicator().get(i);
            SimpleAttributeSet set = new SimpleAttributeSet();
            if (ind.equals(Character.valueOf('c'))) {
                StyleConstants.setBackground(set, this.m_ColorRight);
            } else if (this.m_Left && ind.equals(Character.valueOf('d'))) {
                StyleConstants.setBackground(set, this.m_ColorDeleted);
            } else if (!this.m_Left && ind.equals(Character.valueOf('a'))) {
                StyleConstants.setBackground(set, this.m_ColorAdded);
            }
            StyleConstants.setFontFamily(set, "monospaced");
            String line = null;
            if (obj instanceof String) {
                ++lineNo;
                line = obj.toString();
            }
            try {
                doc.insertString(doc.getLength(), line == null ? Utils.padLeft("", ' ', width) : Utils.padLeft("" + lineNo, ' ', width), lines);
                doc.insertString(doc.getLength(), " ", normal);
                doc.insertString(doc.getLength(), line == null ? "" : line, set);
                doc.insertString(doc.getLength(), "\n", normal);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.getTextPane().setCaretPosition(0);
    }
}

