/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.debug.objecttree;

import adams.core.option.OptionHandler;
import adams.gui.chooser.ObjectExporterFileChooser;
import adams.gui.core.BaseTree;
import adams.gui.core.GUIHelper;
import adams.gui.core.MouseUtils;
import adams.gui.visualization.debug.inspectionhandler.AbstractInspectionHandler;
import adams.gui.visualization.debug.objectexport.AbstractObjectExporter;
import adams.gui.visualization.debug.objecttree.AbstractObjectPlainTextRenderer;
import adams.gui.visualization.debug.objecttree.Node;
import adams.gui.visualization.debug.objecttree.Renderer;
import adams.gui.visualization.debug.propertyextractor.AbstractPropertyExtractor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyEditorManager;
import java.io.File;
import java.lang.reflect.Array;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class Tree
extends BaseTree {
    private static final long serialVersionUID = -127345486742553561L;
    public static final String LABEL_HASHCODE = "hashCode";
    protected transient Object m_Object;
    protected String m_SearchString = null;
    protected Pattern m_SearchPattern = null;
    protected boolean m_IsRegExp = false;
    protected ObjectExporterFileChooser m_FileChooser = null;

    public Tree() {
        this.setShowsRootHandles(true);
        this.setRootVisible(true);
        this.setCellRenderer(new Renderer());
        this.buildTree(null);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path = Tree.this.getPathForLocation(e.getX(), e.getY());
                if (path != null && MouseUtils.isRightClick(e)) {
                    Tree.this.showPopup(e);
                    e.consume();
                }
                if (!e.isConsumed()) {
                    super.mouseClicked(e);
                }
            }
        });
    }

    protected void buildTree(Object root) {
        DefaultTreeModel model;
        if (root == null) {
            model = new DefaultTreeModel(null);
        } else {
            Node rootNode = this.buildTree(null, null, root, Node.NodeType.NORMAL);
            model = new DefaultTreeModel(rootNode);
        }
        this.setModel(model);
    }

    protected void addArray(Node parent, Object obj) {
        int len = Array.getLength(obj);
        for (int i = 0; i < len; ++i) {
            Object value = Array.get(obj, i);
            if (value != null) {
                this.buildTree(parent, "[" + (i + 1) + "]", value, Node.NodeType.ARRAY_ELEMENT);
                continue;
            }
            Node child = new Node("[" + (i + 1) + "]", null, Node.NodeType.ARRAY_ELEMENT);
            parent.add(child);
        }
    }

    protected boolean isPrimitive(Object obj) {
        if (obj instanceof Boolean) {
            return true;
        }
        if (obj instanceof Byte) {
            return true;
        }
        if (obj instanceof Short) {
            return true;
        }
        if (obj instanceof Integer) {
            return true;
        }
        if (obj instanceof Long) {
            return true;
        }
        if (obj instanceof Float) {
            return true;
        }
        if (obj instanceof Double) {
            return true;
        }
        if (obj instanceof Character) {
            return true;
        }
        return obj instanceof String;
    }

    protected boolean matches(String label) {
        boolean result = true;
        if (this.m_SearchString != null) {
            result = false;
            result = this.m_SearchPattern != null ? this.m_SearchPattern.matcher(label).matches() : label.indexOf(this.m_SearchString) > -1;
        }
        return result;
    }

    protected Node buildTree(Node parent, String property, Object obj, Node.NodeType type) {
        Node result = new Node(property, obj, type);
        if (parent != null) {
            parent.add(result);
        }
        if (!this.isPrimitive(obj) && this.matches(LABEL_HASHCODE)) {
            result.add(new Node(LABEL_HASHCODE, obj.hashCode(), Node.NodeType.HASHCODE));
        }
        if (obj.getClass().isArray()) {
            this.addArray(result, obj);
        }
        try {
            AbstractPropertyExtractor extractor = AbstractPropertyExtractor.getExtractor(obj);
            extractor.setCurrent(obj);
            for (int i = 0; i < extractor.size(); ++i) {
                boolean add;
                Object current = extractor.getValue(i);
                if (current == null) continue;
                String label = extractor.getLabel(i);
                boolean bl = add = this.matches(label) || current instanceof OptionHandler || current.getClass().isArray();
                if (!add) continue;
                this.buildTree(result, label, current, Node.NodeType.NORMAL);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to obtain property descriptors for: " + obj);
            e.printStackTrace();
        }
        List<AbstractInspectionHandler> handlers = AbstractInspectionHandler.getHandler(obj);
        for (AbstractInspectionHandler handler : handlers) {
            Hashtable<String, Object> additional = handler.inspect(obj);
            for (String key : additional.keySet()) {
                if (!this.matches(key)) continue;
                this.buildTree(result, key, additional.get(key), Node.NodeType.NORMAL);
            }
        }
        return result;
    }

    public void setObject(Object value) {
        this.m_Object = value;
        this.buildTree(this.m_Object);
    }

    public Object getObject() {
        return this.m_Object;
    }

    protected boolean selectPropertyPath(Node parent, String[] path, int index) {
        boolean result = false;
        if (parent == null) {
            return result;
        }
        for (int i = 0; i < parent.getChildCount(); ++i) {
            Node child = (Node)parent.getChildAt(i);
            if (!child.getProperty().equals(path[index])) continue;
            if (index < path.length - 1) {
                result = this.selectPropertyPath(child, path, index + 1);
                continue;
            }
            result = true;
            this.setSelectionPath(new TreePath(child.getPath()));
        }
        return result;
    }

    public boolean selectPropertyPath(String[] path) {
        return this.selectPropertyPath((Node)this.getModel().getRoot(), path, 0);
    }

    public void search(String search, boolean isRegExp) {
        if (search.trim().length() == 0) {
            search = null;
            isRegExp = false;
        }
        this.m_SearchString = search;
        this.m_IsRegExp = isRegExp;
        if (this.m_SearchString != null && this.m_IsRegExp) {
            try {
                this.m_SearchPattern = Pattern.compile(this.m_SearchString);
            }
            catch (Exception e) {
                this.m_SearchPattern = null;
            }
        } else {
            this.m_SearchPattern = null;
        }
        this.buildTree(this.m_Object);
    }

    protected ObjectExporterFileChooser getFileChooser() {
        if (this.m_FileChooser == null) {
            this.m_FileChooser = new ObjectExporterFileChooser();
        }
        return this.m_FileChooser;
    }

    protected boolean canEdit(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass().isArray()) {
            return true;
        }
        return PropertyEditorManager.findEditor(obj.getClass()) != null;
    }

    protected void showPopup(MouseEvent e) {
        TreePath path = this.getPathForLocation(e.getX(), e.getY());
        if (path == null) {
            return;
        }
        Node node = (Node)path.getLastPathComponent();
        final Object obj = node.getUserObject();
        JPopupMenu menu = new JPopupMenu();
        JMenuItem menuitem = new JMenuItem("Copy", GUIHelper.getIcon("copy.gif"));
        menuitem.setEnabled(obj != null);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Tree.this.copyToClipboard(obj);
                List<AbstractObjectPlainTextRenderer> list = AbstractObjectPlainTextRenderer.getRenderer(obj.getClass());
                String rendered = list.get(0).render(obj);
                GUIHelper.copyToClipboard(rendered);
            }
        });
        menu.add(menuitem);
        menuitem = new JMenuItem("Export...", GUIHelper.getIcon("save.gif"));
        menuitem.setEnabled(obj != null);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Tree.this.export(obj);
            }
        });
        menu.add(menuitem);
        menu.show(this, e.getX(), e.getY());
    }

    protected void copyToClipboard(Object obj) {
        List<AbstractObjectPlainTextRenderer> list = AbstractObjectPlainTextRenderer.getRenderer(obj.getClass());
        String rendered = list.get(0).render(obj);
        GUIHelper.copyToClipboard(rendered);
    }

    protected void export(Object obj) {
        int retVal = this.getFileChooser().showSaveDialog(this);
        if (retVal != 0) {
            return;
        }
        File file = this.getFileChooser().getSelectedFile();
        AbstractObjectExporter exporter = (AbstractObjectExporter)this.getFileChooser().getWriter();
        String msg = exporter.export(obj, file);
        if (msg != null) {
            GUIHelper.showErrorMessage(this, "Failed to export object to '" + file + "'!\n" + msg);
        }
    }
}

