/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image;

import adams.core.ClassLocator;
import adams.core.CleanUpHandler;
import adams.core.StatusMessageHandler;
import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.output.AbstractImageWriter;
import adams.data.io.output.AbstractReportWriter;
import adams.data.report.AbstractField;
import adams.data.report.Report;
import adams.flow.control.Flow;
import adams.gui.chooser.DefaultReportFileChooser;
import adams.gui.chooser.ImageFileChooser;
import adams.gui.core.BaseLogPanel;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.BaseStatusBar;
import adams.gui.core.BaseTabbedPaneWithTabHiding;
import adams.gui.core.ConsolePanel;
import adams.gui.core.CustomPopupMenuProvider;
import adams.gui.core.GUIHelper;
import adams.gui.core.MouseUtils;
import adams.gui.core.SearchPanel;
import adams.gui.core.UndoPanel;
import adams.gui.event.ImagePanelSelectionEvent;
import adams.gui.event.ImagePanelSelectionListener;
import adams.gui.event.SearchEvent;
import adams.gui.event.SearchListener;
import adams.gui.event.UndoEvent;
import adams.gui.print.PrintMouseListener;
import adams.gui.visualization.image.ImageOverlay;
import adams.gui.visualization.report.ReportFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class ImagePanel
extends UndoPanel
implements StatusMessageHandler,
TableModelListener,
CleanUpHandler {
    private static final long serialVersionUID = -3102446345758890249L;
    public static final String TAB_PROPERTIES = "Properties";
    public static final String TAB_LOG = "Log";
    protected PlaceholderFile m_CurrentFile;
    protected PaintPanel m_PaintPanel;
    protected BaseScrollPane m_ScrollPane;
    protected BaseStatusBar m_StatusBar;
    protected BaseTabbedPaneWithTabHiding m_SideSplitPane;
    protected BasePanel m_PanelProperties;
    protected ReportFactory.Model m_ModelProperties;
    protected ReportFactory.Table m_TableProperties;
    protected BaseScrollPane m_ScrollPaneProperties;
    protected SearchPanel m_PanelSearchProperties;
    protected BaseSplitPane m_MainSplitPane;
    protected Color m_BackgroundColor;
    protected boolean m_Modified;
    protected Report m_ImageProperties;
    protected Report m_AdditionalProperties;
    protected BaseLogPanel m_PanelLog;
    protected List<Dialog> m_DependentDialogs;
    protected List<Flow> m_DependentFlows;
    protected double m_Scale;
    protected ImageFileChooser m_FileChooser;

    public ImagePanel() {
        super(Object.class, true);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_BackgroundColor = this.getBackground();
        this.m_Modified = false;
        this.m_ImageProperties = new Report();
        this.m_AdditionalProperties = null;
        this.m_DependentDialogs = new ArrayList<Dialog>();
        this.m_DependentFlows = new ArrayList<Flow>();
        this.m_Scale = -1.0;
        this.m_FileChooser = new ImageFileChooser();
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_MainSplitPane = new BaseSplitPane();
        this.m_MainSplitPane.setResizeWeight(1.0);
        this.add((Component)this.m_MainSplitPane, "Center");
        this.m_PaintPanel = new PaintPanel(this);
        JPanel panel = new JPanel(new FlowLayout(1));
        panel.add(this.m_PaintPanel);
        this.m_ScrollPane = new BaseScrollPane(panel);
        this.m_MainSplitPane.setLeftComponent(this.m_ScrollPane);
        this.m_MainSplitPane.setLeftComponentHidden(false);
        this.m_SideSplitPane = new BaseTabbedPaneWithTabHiding();
        this.m_MainSplitPane.setRightComponent(this.m_SideSplitPane);
        this.m_MainSplitPane.setRightComponentHidden(true);
        this.m_PanelProperties = new BasePanel(new BorderLayout());
        this.m_PanelProperties.setMinimumSize(new Dimension(200, 0));
        this.m_SideSplitPane.addTab(TAB_PROPERTIES, this.m_PanelProperties);
        this.m_ModelProperties = new ReportFactory.Model();
        this.m_TableProperties = new ReportFactory.Table(this.m_ModelProperties);
        this.m_TableProperties.setAutoResizeMode(0);
        this.m_TableProperties.setSelectionMode(2);
        this.m_TableProperties.sort(0);
        this.m_ScrollPaneProperties = new BaseScrollPane(this.m_TableProperties);
        this.m_PanelProperties.add((Component)this.m_ScrollPaneProperties, "Center");
        this.m_PanelSearchProperties = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, false);
        this.m_PanelSearchProperties.addSearchListener(new SearchListener(){

            @Override
            public void searchInitiated(SearchEvent e) {
                ImagePanel.this.m_TableProperties.search(e.getParameters().getSearchString(), e.getParameters().isRegExp());
            }
        });
        this.m_PanelProperties.add((Component)this.m_PanelSearchProperties, "South");
        this.m_PanelLog = new BaseLogPanel();
        this.m_PanelLog.setRows(10);
        this.m_PanelLog.setColumns(20);
        this.m_SideSplitPane.addTab(TAB_LOG, this.m_PanelLog);
        this.m_StatusBar = new BaseStatusBar();
        this.add((Component)this.m_StatusBar, "South");
        this.clear();
    }

    protected Vector getState() {
        Vector<Object> result = new Vector<Object>();
        result.add(this.getCurrentFile());
        result.add(this.getCurrentImage());
        result.add(this.m_Modified);
        result.add(this.getScale());
        return result;
    }

    protected void setState(Vector value) {
        this.setCurrentImage((BufferedImage)value.get(1));
        this.m_CurrentFile = (PlaceholderFile)value.get(0);
        this.m_Modified = (Boolean)value.get(2);
        this.setScale((Double)value.get(3));
    }

    public void addUndoPoint(String statusMsg, String undoComment) {
        if (this.isUndoSupported() && this.getUndo().isEnabled()) {
            this.showStatus(statusMsg);
            this.getUndo().addUndo(this.getState(), undoComment);
            this.showStatus("");
        }
    }

    public void setCurrentImage(BufferedImage value) {
        this.m_CurrentFile = null;
        this.m_PaintPanel.setCurrentImage(value);
        this.updateImageProperties();
    }

    public void setCurrentImage(AbstractImageContainer value) {
        this.m_CurrentFile = null;
        this.m_PaintPanel.setCurrentImage(value.toBufferedImage());
        this.updateImageProperties();
        this.setAdditionalProperties(value.getReport());
    }

    public BufferedImage getCurrentImage() {
        return this.m_PaintPanel.getCurrentImage();
    }

    public void setCurrentFile(File value) {
        if (this.getCurrentImage() != null) {
            this.m_CurrentFile = value != null ? new PlaceholderFile(value) : null;
            this.updateImageProperties();
        }
    }

    public File getCurrentFile() {
        return this.m_CurrentFile;
    }

    public void setScale(double value) {
        this.m_Scale = value;
        this.m_PaintPanel.setScale(this.calcActualScale(this.m_Scale));
    }

    public double getScale() {
        return this.m_Scale;
    }

    public double getActualScale() {
        return this.m_PaintPanel.getScale();
    }

    protected double calcActualScale(double scale) {
        double result = scale;
        if (result == -1.0 && this.getCurrentImage() != null) {
            int width = this.m_ScrollPane.getWidth() - 20;
            int height = this.m_ScrollPane.getHeight() - 20;
            double scaleW = (double)width / (double)this.getCurrentImage().getWidth();
            double scaleH = (double)height / (double)this.getCurrentImage().getHeight();
            result = Math.min(scaleW, scaleH);
        }
        return result;
    }

    @Override
    protected void paintComponent(Graphics g) {
        double actual = this.calcActualScale(this.m_Scale);
        if (actual != this.m_PaintPanel.getScale()) {
            this.m_PaintPanel.setScale(actual);
        }
        super.paintComponent(g);
    }

    public void setBackgroundColor(Color value) {
        this.m_BackgroundColor = value;
        this.repaint();
    }

    public Color getBackgroundColor() {
        return this.m_BackgroundColor;
    }

    protected BaseScrollPane getScrollPane() {
        return this.m_ScrollPane;
    }

    public BaseSplitPane getSplitPane() {
        return this.m_MainSplitPane;
    }

    public ReportFactory.Table getPropertiesTable() {
        return this.m_TableProperties;
    }

    public BaseScrollPane getPropertiesScrollPane() {
        return this.m_ScrollPaneProperties;
    }

    public void log(String msg) {
        this.m_PanelLog.append(msg);
    }

    public void clear() {
        this.addUndoPoint("Saving undo data...", "Removing image");
        this.m_CurrentFile = null;
        this.m_PaintPanel.setCurrentImage(null);
        this.removeDependentDialogs();
        this.removeDependentFlows();
        this.updateImageProperties();
        this.showStatus("");
        this.log("clear");
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDependentDialog(Dialog dlg) {
        List<Dialog> list = this.m_DependentDialogs;
        synchronized (list) {
            this.m_DependentDialogs.add(dlg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDependentDialogs() {
        List<Dialog> list = this.m_DependentDialogs;
        synchronized (list) {
            for (Dialog dlg : this.m_DependentDialogs) {
                dlg.setVisible(false);
                dlg.dispose();
            }
            this.m_DependentDialogs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDependentFlow(Flow flow) {
        List<Flow> list = this.m_DependentFlows;
        synchronized (list) {
            this.m_DependentFlows.add(flow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDependentFlows() {
        List<Flow> list = this.m_DependentFlows;
        synchronized (list) {
            for (Flow flow : this.m_DependentFlows) {
                flow.cleanUp();
            }
            this.m_DependentFlows.clear();
        }
    }

    public boolean load(File file) {
        return this.load(file, null);
    }

    public boolean load(File file, AbstractImageReader reader) {
        boolean result;
        this.addUndoPoint("Saving undo data...", "Loading file '" + file + "'");
        try {
            BufferedImageContainer cont;
            if (reader == null) {
                reader = this.m_FileChooser.getReaderForFile(file);
            }
            if ((cont = reader != null ? reader.read(new PlaceholderFile(file)) : BufferedImageHelper.read(file)) != null) {
                this.m_PaintPanel.setCurrentImage(((AbstractImageContainer)cont).toBufferedImage());
                this.m_CurrentFile = new PlaceholderFile(file);
                result = true;
                this.updateImageProperties(cont.getReport());
                this.repaint();
                this.log("load: " + file);
            } else {
                result = false;
                this.log("load failed: " + file);
            }
        }
        catch (Exception e) {
            ConsolePanel.getSingleton().append(ConsolePanel.OutputType.ERROR, "Failed to read '" + file + "':\n" + Utils.throwableToString(e));
            this.clear();
            result = false;
        }
        return result;
    }

    public boolean save(File file) {
        return this.save(file, null);
    }

    public boolean save(File file, AbstractImageWriter<AbstractImageContainer> writer) {
        boolean result = false;
        if (this.m_PaintPanel.getCurrentImage() != null) {
            try {
                String msg = null;
                file = new File(file.getAbsolutePath());
                if (writer == null) {
                    writer = this.m_FileChooser.getWriterForFile(file);
                }
                if (writer == null) {
                    msg = BufferedImageHelper.write(this.m_PaintPanel.getCurrentImage(), file);
                } else {
                    BufferedImageContainer cont = new BufferedImageContainer();
                    cont.setImage(this.m_PaintPanel.getCurrentImage());
                    msg = writer.write(new PlaceholderFile(file), cont);
                }
                this.m_CurrentFile = new PlaceholderFile(file);
                boolean bl = result = msg == null;
                if (msg != null) {
                    this.log("save failed: " + file);
                } else {
                    this.log("saved: " + file);
                }
            }
            catch (Exception e) {
                ConsolePanel.getSingleton().append(ConsolePanel.OutputType.ERROR, "Failed to save image to '" + file + "':\n" + Utils.throwableToString(e));
                result = false;
            }
        }
        if (result) {
            this.m_Modified = false;
        }
        return result;
    }

    public void export() {
        this.m_PaintPanel.export();
    }

    public void saveReport() {
        this.m_PaintPanel.saveReport();
    }

    @Override
    public void showStatus(String msg) {
        this.m_StatusBar.showStatus(msg);
    }

    public boolean getShowProperties() {
        return !this.m_SideSplitPane.isHidden(TAB_PROPERTIES);
    }

    public void setShowProperties(boolean value) {
        if (value) {
            this.m_SideSplitPane.displayTab(TAB_PROPERTIES);
        } else {
            this.m_SideSplitPane.hideTab(TAB_PROPERTIES);
        }
        this.m_MainSplitPane.setRightComponentHidden(this.m_SideSplitPane.getTabCount() == 0);
    }

    public boolean getShowLog() {
        return !this.m_SideSplitPane.isHidden(TAB_LOG);
    }

    public void setShowLog(boolean value) {
        if (value) {
            this.m_SideSplitPane.displayTab(TAB_LOG);
        } else {
            this.m_SideSplitPane.hideTab(TAB_LOG);
        }
        this.m_MainSplitPane.setRightComponentHidden(this.m_SideSplitPane.getTabCount() == 0);
    }

    public void setModified(boolean value) {
        this.m_Modified = value;
    }

    public boolean isModified() {
        return this.m_Modified;
    }

    protected void updateImageProperties() {
        this.updateImageProperties(null);
    }

    protected void updateImageProperties(Report props) {
        Report report = props == null ? new Report() : props;
        BufferedImage image = this.getCurrentImage();
        if (image != null) {
            if (this.m_CurrentFile != null) {
                report.setStringValue("File", "" + this.m_CurrentFile);
            }
            report.setNumericValue("Width", image.getWidth());
            report.setNumericValue("Height", image.getHeight());
        }
        this.m_ImageProperties = report;
        this.displayProperties();
    }

    protected void displayProperties() {
        if (this.m_TableProperties != null) {
            this.m_TableProperties.getModel().removeTableModelListener(this);
        }
        Report merged = this.m_ImageProperties.getClone();
        if (this.m_AdditionalProperties != null) {
            merged.mergeWith(this.m_AdditionalProperties);
        }
        this.m_ModelProperties = new ReportFactory.Model(merged);
        this.m_TableProperties.setModel(this.m_ModelProperties);
        this.m_TableProperties.setOptimalColumnWidth();
        this.m_TableProperties.sort(0);
        this.m_TableProperties.getModel().addTableModelListener(this);
        this.m_PaintPanel.update();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.updateProperties(this.m_ModelProperties.getReport(), this.m_AdditionalProperties)) {
            this.displayProperties();
            this.m_PaintPanel.update();
        }
    }

    protected boolean updateProperties(Report modified, Report current) {
        boolean result = false;
        if (current != null) {
            List<AbstractField> fields = current.getFields();
            for (AbstractField field : fields) {
                if (!modified.hasValue(field)) {
                    current.removeValue(field);
                    result = true;
                    continue;
                }
                if (modified.getValue(field).equals(current.getValue(field))) continue;
                current.setValue(field, modified.getValue(field));
                result = true;
            }
        }
        return result;
    }

    public void setAdditionalProperties(Report value) {
        this.m_AdditionalProperties = value;
        this.displayProperties();
    }

    public Report getAdditionalProperties() {
        return this.m_AdditionalProperties;
    }

    public Report getImageProperties() {
        return this.m_ImageProperties;
    }

    public Report getAllProperties() {
        return this.m_ModelProperties.getReport();
    }

    @Override
    public void undoOccurred(UndoEvent e) {
        switch (e.getType()) {
            case UNDO: 
            case REDO: {
                this.log(e.getType().toString().toLowerCase() + ": " + e.getUndoPoint().getComment());
            }
        }
    }

    public PaintPanel getPaintPanel() {
        return this.m_PaintPanel;
    }

    public void clearImageOverlays() {
        this.m_PaintPanel.clearImageOverlays();
    }

    public void addImageOverlay(ImageOverlay io) {
        this.m_PaintPanel.addImageOverlay(io);
    }

    public void removeImageOverlay(ImageOverlay io) {
        this.m_PaintPanel.removeImageOverlay(io);
    }

    public void removeImageOverlays(Class cls) {
        this.m_PaintPanel.removeImageOverlays(cls);
    }

    public Iterator<ImageOverlay> imageOverlays() {
        return this.m_PaintPanel.imageOverlays();
    }

    public void setCustomPopupMenuProvider(CustomPopupMenuProvider value) {
        this.m_PaintPanel.setCustomPopupMenuProvider(value);
    }

    public CustomPopupMenuProvider getCustomPopupMenuProvider() {
        return this.m_PaintPanel.getCustomPopupMenuProvider();
    }

    public Point mouseToPixelLocation(Point mousePos) {
        return this.m_PaintPanel.mouseToPixelLocation(mousePos);
    }

    public void addSelectionListener(ImagePanelSelectionListener l) {
        this.m_PaintPanel.addSelectionListener(l);
    }

    public void removeSelectionListener(ImagePanelSelectionListener l) {
        this.m_PaintPanel.removeSelectionListener(l);
    }

    public void setSelectionBoxColor(Color value) {
        this.m_PaintPanel.setSelectionBoxColor(value);
    }

    public Color getSelectionBoxColor() {
        return this.m_PaintPanel.getSelectionBoxColor();
    }

    public void setSelectionEnabled(boolean value) {
        this.m_PaintPanel.setSelectionEnabled(value);
    }

    public boolean isSelectionEnabled() {
        return this.m_PaintPanel.isSelectionEnabled();
    }

    @Override
    public void cleanUp() {
        this.removeDependentDialogs();
        this.removeDependentFlows();
    }

    public static class PaintPanel
    extends BasePanel {
        private static final long serialVersionUID = 184259023085417961L;
        protected ImagePanel m_Owner;
        protected double m_Scale;
        protected BufferedImage m_CurrentImage;
        protected PrintMouseListener m_PrintMouseListener;
        protected HashSet<ImageOverlay> m_ImageOverlays;
        protected CustomPopupMenuProvider m_CustomPopupMenuProvider;
        protected boolean m_SelectionEnabled;
        protected Color m_SelectionBoxColor;
        protected boolean m_Selecting;
        protected boolean m_Dragged;
        protected Point m_SelectionTopLeft;
        protected Point m_SelectionBottomRight;
        protected HashSet<ImagePanelSelectionListener> m_SelectionListeners;

        public PaintPanel(ImagePanel owner) {
            this.m_Owner = owner;
        }

        @Override
        protected void initialize() {
            super.initialize();
            this.m_CurrentImage = null;
            this.m_Scale = 1.0;
            this.m_ImageOverlays = new HashSet();
            this.m_CustomPopupMenuProvider = null;
            this.m_Selecting = false;
            this.m_Dragged = false;
            this.m_SelectionBoxColor = Color.GRAY;
            this.m_SelectionEnabled = false;
            this.m_SelectionListeners = new HashSet();
        }

        @Override
        protected void initGUI() {
            super.initGUI();
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    super.mouseDragged(e);
                    if (m_Selecting && !e.isShiftDown()) {
                        m_Dragged = true;
                        m_SelectionBottomRight = e.getPoint();
                        this.repaint();
                    }
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    this.updateStatus(e.getPoint());
                    if (e.getButton() == 1 && !e.isShiftDown() && m_SelectionEnabled) {
                        m_Selecting = true;
                        m_Dragged = false;
                        m_SelectionTopLeft = e.getPoint();
                    }
                    super.mouseMoved(e);
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    super.mousePressed(e);
                    if (e.getButton() == 1 && !e.isShiftDown() && m_SelectionEnabled) {
                        m_Selecting = true;
                        m_Dragged = false;
                        m_SelectionTopLeft = e.getPoint();
                    }
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (e.getButton() == 1 && !e.isShiftDown() && m_SelectionEnabled) {
                        m_Selecting = true;
                        m_Dragged = false;
                        m_SelectionTopLeft = e.getPoint();
                    }
                    super.mouseMoved(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    super.mouseReleased(e);
                    if (e.getButton() == 1 && m_Selecting && m_Dragged) {
                        m_Selecting = false;
                        m_Dragged = false;
                        m_SelectionBottomRight = e.getPoint();
                        if (m_SelectionTopLeft.getX() > m_SelectionBottomRight.getX()) {
                            this.notifySelectionListeners(m_SelectionBottomRight, m_SelectionTopLeft, e.getModifiersEx());
                        } else {
                            this.notifySelectionListeners(m_SelectionTopLeft, m_SelectionBottomRight, e.getModifiersEx());
                        }
                    }
                    m_Selecting = false;
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (MouseUtils.isMiddleClick(e)) {
                        this.setScale(1.0);
                        this.updateStatus();
                        e.consume();
                    } else if (MouseUtils.isRightClick(e)) {
                        this.showPopup(e);
                        e.consume();
                    } else {
                        super.mouseClicked(e);
                    }
                }
            });
            this.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    int rotation = e.getWheelRotation();
                    double scale = this.getScale();
                    scale = rotation < 0 ? (scale *= Math.pow(1.2, -rotation)) : (scale /= Math.pow(1.2, rotation));
                    this.getOwner().setScale(scale);
                    this.updateStatus();
                }
            });
            this.m_PrintMouseListener = new PrintMouseListener(this);
        }

        protected void updateStatus() {
            Point pos = this.getMousePosition();
            if (pos != null) {
                this.updateStatus(pos.getLocation());
            }
        }

        public Point mouseToPixelLocation(Point mousePos) {
            int y;
            int x = (int)(mousePos.getX() / this.m_Scale);
            if (x < 0) {
                x = 0;
            }
            if ((y = (int)(mousePos.getY() / this.m_Scale)) < 0) {
                y = 0;
            }
            if (this.m_CurrentImage != null) {
                if (x > this.m_CurrentImage.getWidth()) {
                    x = this.m_CurrentImage.getWidth();
                }
                if (y > this.m_CurrentImage.getHeight()) {
                    y = this.m_CurrentImage.getHeight();
                }
            }
            return new Point(x, y);
        }

        protected void updateStatus(Point pos) {
            if (this.getOwner() == null) {
                return;
            }
            Point loc = this.mouseToPixelLocation(pos);
            this.getOwner().showStatus("X: " + (int)(loc.getX() + 1.0) + "   " + "Y: " + (int)(loc.getY() + 1.0) + "   " + "Zoom: " + Utils.doubleToString(this.getScale() * 100.0, 1) + "%");
        }

        protected void showPopup(MouseEvent e) {
            JPopupMenu menu = null;
            if (this.m_CustomPopupMenuProvider != null) {
                menu = this.m_CustomPopupMenuProvider.getCustomPopupMenu(e);
            }
            if (menu == null) {
                menu = new JPopupMenu();
                JMenuItem menuitem = new JMenuItem("Copy", GUIHelper.getIcon("copy.gif"));
                menuitem.setEnabled(this.getCurrentImage() != null);
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        GUIHelper.copyToClipboard(this.getCurrentImage());
                    }
                });
                menu.add(menuitem);
                menuitem = new JMenuItem("Export...", GUIHelper.getIcon("save.gif"));
                menuitem.setEnabled(this.getCurrentImage() != null);
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.export();
                    }
                });
                menu.addSeparator();
                menu.add(menuitem);
                menuitem = new JMenuItem("Save report...", GUIHelper.getEmptyIcon());
                menuitem.setEnabled(this.getCurrentImage() != null);
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.saveReport();
                    }
                });
                menu.add(menuitem);
                JMenu submenu = new JMenu("Zoom");
                submenu.setIcon(GUIHelper.getIcon("glasses.gif"));
                menu.addSeparator();
                menu.add(submenu);
                int[] zooms = new int[]{-100, 25, 50, 66, 75, 100, 150, 200, 400, 800};
                for (int i = 0; i < zooms.length; ++i) {
                    final int fZoom = zooms[i];
                    menuitem = zooms[i] == -100 ? new JMenuItem("Best fit") : new JMenuItem(zooms[i] + "%");
                    submenu.add(menuitem);
                    menuitem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (this.getOwner() != null) {
                                this.getOwner().setScale((double)fZoom / 100.0);
                            } else {
                                this.setScale((double)fZoom / 100.0);
                            }
                        }
                    });
                }
            }
            menu.show(this, e.getX(), e.getY());
        }

        public ImagePanel getOwner() {
            return this.m_Owner;
        }

        public void setCurrentImage(BufferedImage value) {
            this.m_CurrentImage = value;
            this.setScale(1.0);
            this.repaint();
        }

        public BufferedImage getCurrentImage() {
            return this.m_CurrentImage;
        }

        public void setScale(double value) {
            if (value > 0.0 && value <= 16.0) {
                int height;
                int width;
                this.m_Scale = value;
                if (this.m_CurrentImage != null) {
                    width = (int)((double)this.m_CurrentImage.getWidth() * this.m_Scale);
                    height = (int)((double)this.m_CurrentImage.getHeight() * this.m_Scale);
                } else {
                    width = 320;
                    height = 200;
                }
                this.setSize(new Dimension(width, height));
                this.setMinimumSize(new Dimension(width, height));
                this.setPreferredSize(new Dimension(width, height));
                this.getOwner().getScrollPane().getHorizontalScrollBar().setUnitIncrement(width / 25);
                this.getOwner().getScrollPane().getHorizontalScrollBar().setBlockIncrement(width / 10);
                this.getOwner().getScrollPane().getVerticalScrollBar().setUnitIncrement(height / 25);
                this.getOwner().getScrollPane().getVerticalScrollBar().setBlockIncrement(height / 10);
                this.update();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update() {
            HashSet<Object> hashSet = this.m_ImageOverlays;
            synchronized (hashSet) {
                for (ImageOverlay overlay : this.m_ImageOverlays) {
                    overlay.imageChanged(this);
                }
            }
            hashSet = this.m_SelectionListeners;
            synchronized (hashSet) {
                for (ImagePanelSelectionListener l : this.m_SelectionListeners) {
                    l.imageChanged(this);
                }
            }
            this.getOwner().invalidate();
            this.getOwner().validate();
            this.repaint();
        }

        public double getScale() {
            return this.m_Scale;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearImageOverlays() {
            HashSet<ImageOverlay> hashSet = this.m_ImageOverlays;
            synchronized (hashSet) {
                for (ImageOverlay overlay : this.m_ImageOverlays) {
                    overlay.cleanUp();
                }
                this.m_ImageOverlays.clear();
            }
            this.update();
        }

        public void export() {
            this.m_PrintMouseListener.saveComponent();
        }

        public void saveReport() {
            DefaultReportFileChooser filechooser = new DefaultReportFileChooser();
            int retVal = filechooser.showSaveDialog(this);
            if (retVal != 0) {
                return;
            }
            AbstractReportWriter writer = (AbstractReportWriter)filechooser.getWriter();
            writer.setOutput(filechooser.getSelectedPlaceholderFile());
            if (!writer.write(this.getOwner().getAllProperties())) {
                GUIHelper.showErrorMessage(this, "Failed to save report to:\n" + filechooser.getSelectedPlaceholderFile());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addImageOverlay(ImageOverlay io) {
            HashSet<ImageOverlay> hashSet = this.m_ImageOverlays;
            synchronized (hashSet) {
                this.m_ImageOverlays.add(io);
            }
            this.update();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeImageOverlay(ImageOverlay io) {
            HashSet<ImageOverlay> hashSet = this.m_ImageOverlays;
            synchronized (hashSet) {
                this.m_ImageOverlays.remove(io);
            }
            this.update();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeImageOverlays(Class cls) {
            HashSet<ImageOverlay> hashSet = this.m_ImageOverlays;
            synchronized (hashSet) {
                ArrayList<ImageOverlay> remove = new ArrayList<ImageOverlay>();
                for (ImageOverlay io : this.m_ImageOverlays) {
                    if (!ClassLocator.isSubclass(cls, io.getClass())) continue;
                    remove.add(io);
                }
                this.m_ImageOverlays.removeAll(remove);
            }
            this.update();
        }

        public synchronized Iterator<ImageOverlay> imageOverlays() {
            return this.m_ImageOverlays.iterator();
        }

        public void setCustomPopupMenuProvider(CustomPopupMenuProvider value) {
            this.m_CustomPopupMenuProvider = value;
        }

        public CustomPopupMenuProvider getCustomPopupMenuProvider() {
            return this.m_CustomPopupMenuProvider;
        }

        protected void paintSelectionBox(Graphics g) {
            if (this.m_Selecting && this.m_Dragged) {
                int tmp;
                g.setColor(this.m_SelectionBoxColor);
                int topX = (int)this.mouseToPixelLocation(this.m_SelectionTopLeft).getX();
                int topY = (int)this.mouseToPixelLocation(this.m_SelectionTopLeft).getY();
                int bottomX = (int)this.mouseToPixelLocation(this.m_SelectionBottomRight).getX();
                int bottomY = (int)this.mouseToPixelLocation(this.m_SelectionBottomRight).getY();
                if (topX > bottomX) {
                    tmp = topX;
                    topX = bottomX;
                    bottomX = tmp;
                }
                if (topY > bottomY) {
                    tmp = topY;
                    topY = bottomY;
                    bottomY = tmp;
                }
                g.drawRect(topX, topY, bottomX - topX + 1, bottomY - topY + 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void paint(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.m_CurrentImage == null) return;
            ((Graphics2D)g).scale(this.m_Scale, this.m_Scale);
            g.drawImage(this.m_CurrentImage, 0, 0, this.getOwner().getBackgroundColor(), null);
            ImageOverlay[] imageOverlayArray = this.m_ImageOverlays;
            synchronized (this.m_ImageOverlays) {
                ImageOverlay[] overlays = this.m_ImageOverlays.toArray(new ImageOverlay[this.m_ImageOverlays.size()]);
                // ** MonitorExit[var3_2] (shouldn't be in output)
                for (ImageOverlay overlay : overlays) {
                    overlay.paintOverlay(this, g);
                }
                this.paintSelectionBox(g);
                return;
            }
        }

        public void setSelectionBoxColor(Color value) {
            this.m_SelectionBoxColor = value;
            if (this.m_Selecting) {
                this.repaint();
            }
        }

        public Color getSelectionBoxColor() {
            return this.m_SelectionBoxColor;
        }

        public void setSelectionEnabled(boolean value) {
            this.m_SelectionEnabled = value;
        }

        public boolean isSelectionEnabled() {
            return this.m_SelectionEnabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSelectionListener(ImagePanelSelectionListener l) {
            HashSet<ImagePanelSelectionListener> hashSet = this.m_SelectionListeners;
            synchronized (hashSet) {
                this.m_SelectionListeners.add(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSelectionListener(ImagePanelSelectionListener l) {
            HashSet<ImagePanelSelectionListener> hashSet = this.m_SelectionListeners;
            synchronized (hashSet) {
                this.m_SelectionListeners.remove(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifySelectionListeners(Point topLeft, Point bottomRight, int modifiersEx) {
            HashSet<ImagePanelSelectionListener> hashSet = this.m_SelectionListeners;
            synchronized (hashSet) {
                ImagePanelSelectionEvent e = new ImagePanelSelectionEvent(this.getOwner(), topLeft, bottomRight, modifiersEx);
                Iterator<ImagePanelSelectionListener> iter = this.m_SelectionListeners.iterator();
                while (iter.hasNext()) {
                    iter.next().selected(e);
                }
            }
        }
    }
}

