/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.sequence;

import adams.core.Utils;
import adams.data.sequence.XYSequencePoint;
import adams.data.statistics.StatUtils;
import adams.gui.core.AntiAliasingSupporter;
import adams.gui.core.GUIHelper;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AbstractStrokePaintlet;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.sequence.AbstractXYSequencePointHitDetector;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import adams.gui.visualization.sequence.XYSequencePaintlet;
import adams.gui.visualization.sequence.XYSequencePanel;
import gnu.trove.list.array.TDoubleArrayList;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

public class LinearRegressionOverlayPaintlet
extends AbstractStrokePaintlet
implements XYSequencePaintlet,
AntiAliasingSupporter {
    private static final long serialVersionUID = 6292059403058224856L;
    protected Color m_Color;
    protected boolean m_AntiAliasingEnabled;
    protected boolean m_OutputSlopeIntercept;
    protected int m_X;
    protected int m_Y;
    protected Font m_Font;

    @Override
    public String globalInfo() {
        return "Draws a straight line, using slope and intercept determine by linear regression using all the data points in the plot(s).";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("color", "color", Color.BLACK);
        this.m_OptionManager.add("anti-aliasing-enabled", "antiAliasingEnabled", GUIHelper.getBoolean(this.getClass(), "antiAliasingEnabled", true));
        this.m_OptionManager.add("output-slope-intercept", "outputSlopeIntercept", false);
        this.m_OptionManager.add("x", "X", 5, 1, null);
        this.m_OptionManager.add("y", "Y", 16, 1, null);
        this.m_OptionManager.add("font", "font", GUIHelper.getMonospacedFont());
    }

    public void setColor(Color value) {
        this.m_Color = value;
        this.memberChanged();
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color for the line.";
    }

    @Override
    public void setAntiAliasingEnabled(boolean value) {
        this.m_AntiAliasingEnabled = value;
        this.memberChanged();
    }

    @Override
    public boolean isAntiAliasingEnabled() {
        return this.m_AntiAliasingEnabled;
    }

    @Override
    public String antiAliasingEnabledTipText() {
        return "If enabled, uses anti-aliasing for drawing lines.";
    }

    public void setOutputSlopeIntercept(boolean value) {
        this.m_OutputSlopeIntercept = value;
        this.memberChanged();
    }

    public boolean getOutputSlopeIntercept() {
        return this.m_OutputSlopeIntercept;
    }

    public String outputSlopeInterceptTipText() {
        return "If enabled, slope and intercept are output on the plot as well.";
    }

    public void setX(int value) {
        if (value > 0) {
            this.m_X = value;
            this.reset();
        } else {
            this.getLogger().severe("X must be >0, provided: " + value);
        }
    }

    public int getX() {
        return this.m_X;
    }

    public String XTipText() {
        return "The X position of the top-left corner of the text (1-based).";
    }

    public void setY(int value) {
        if (value > 0) {
            this.m_Y = value;
            this.reset();
        } else {
            this.getLogger().severe("Y must be >0, provided: " + value);
        }
    }

    public int getY() {
        return this.m_Y;
    }

    public String YTipText() {
        return "The Y position of the top-left corner of the text (1-based).";
    }

    public void setFont(Font value) {
        this.m_Font = value;
        this.reset();
    }

    public Font getFont() {
        return this.m_Font;
    }

    public String fontTipText() {
        return "The font to use for the text.";
    }

    @Override
    public PaintEvent.PaintMoment getPaintMoment() {
        return PaintEvent.PaintMoment.GRID;
    }

    @Override
    public XYSequencePanel getSequencePanel() {
        return (XYSequencePanel)this.getPanel();
    }

    @Override
    public AbstractXYSequencePointHitDetector newHitDetector() {
        return null;
    }

    @Override
    public void performPaint(Graphics g, PaintEvent.PaintMoment moment) {
        TDoubleArrayList x = new TDoubleArrayList();
        TDoubleArrayList y = new TDoubleArrayList();
        for (int i = 0; i < ((XYSequenceContainerManager)this.getSequencePanel().getContainerManager()).countVisible(); ++i) {
            XYSequenceContainer cont = ((XYSequenceContainerManager)this.getSequencePanel().getContainerManager()).getVisible(i);
            for (XYSequencePoint p : cont.getData()) {
                x.add(p.getX());
                y.add(p.getY());
            }
        }
        double[] lr = StatUtils.linearRegression(x.toArray(), y.toArray());
        AxisPanel xAxis = this.getPlot().getAxis(Axis.BOTTOM);
        AxisPanel yAxis = this.getPlot().getAxis(Axis.LEFT);
        double xMin = xAxis.getActualMinimum();
        double yMin = xMin * lr[1] + lr[0];
        double xMax = xAxis.getActualMaximum();
        double yMax = xMax * lr[1] + lr[0];
        g.setColor(this.m_Color);
        GUIHelper.configureAntiAliasing(g, this.m_AntiAliasingEnabled);
        if (this.m_OutputSlopeIntercept) {
            g.setFont(this.getFont());
            g.drawString("I: " + Utils.doubleToString(lr[0], 3) + ", S: " + Utils.doubleToString(lr[1], 3), this.m_X - 1, this.m_Y - 1);
        }
        g.drawLine(xAxis.valueToPos(xMin), yAxis.valueToPos(yMin), xAxis.valueToPos(xMax), yAxis.valueToPos(yMax));
    }
}

