/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.sequence;

import adams.flow.core.Actor;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.FlowAwarePaintlet;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.core.plot.HitDetectorSupporter;
import adams.gui.visualization.sequence.AbstractXYSequencePaintlet;
import adams.gui.visualization.sequence.AbstractXYSequencePointHitDetector;
import adams.gui.visualization.sequence.LinePaintlet;
import adams.gui.visualization.sequence.XYSequencePaintlet;
import java.awt.Graphics;

public class PaintletWithFixedYRange
extends AbstractXYSequencePaintlet
implements adams.gui.visualization.core.PaintletWithFixedYRange,
FlowAwarePaintlet {
    private static final long serialVersionUID = 354723429582771889L;
    protected double m_MinY;
    protected double m_MaxY;
    protected XYSequencePaintlet m_Paintlet;
    protected Actor m_Actor;

    @Override
    public String globalInfo() {
        return "Meta-paintlet that uses a fixed Y range (for faster drawing) and a base-paintlet to draw the actual data.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("min-y", "minY", 0.0, null, null);
        this.m_OptionManager.add("max-y", "maxY", 1000.0, null, null);
        this.m_OptionManager.add("paintlet", "paintlet", this.getDefaultPaintlet());
    }

    @Override
    protected void initialize() {
        this.setPaintlet(this.getDefaultPaintlet());
        super.initialize();
    }

    protected XYSequencePaintlet getDefaultPaintlet() {
        return new LinePaintlet();
    }

    @Override
    public void setPanel(PaintablePanel value) {
        if (this.m_Paintlet != null) {
            this.m_Paintlet.setPanel(value);
        }
        super.setPanel(value);
    }

    public void setMinY(double value) {
        this.m_MinY = value;
        this.memberChanged(true);
    }

    public double getMinY() {
        return this.m_MinY;
    }

    @Override
    public double getMinimumY() {
        return this.m_MinY;
    }

    public String minYTipText() {
        return "The minimum value for the Y range.";
    }

    public void setMaxY(double value) {
        this.m_MaxY = value;
        this.memberChanged(true);
    }

    public double getMaxY() {
        return this.m_MaxY;
    }

    @Override
    public double getMaximumY() {
        return this.m_MaxY;
    }

    public String maxYTipText() {
        return "The maximum value for the Y range.";
    }

    public void setPaintlet(XYSequencePaintlet value) {
        if (this.m_Paintlet != null) {
            this.m_Paintlet.setPanel(null);
        }
        this.m_Paintlet = value;
        this.m_Paintlet.setPanel(this.getPanel());
        this.memberChanged();
    }

    public XYSequencePaintlet getPaintlet() {
        return this.m_Paintlet;
    }

    public String paintletTipText() {
        return "The actual paintlet to use for drawing the data.";
    }

    @Override
    public void performPaint(Graphics g, PaintEvent.PaintMoment moment) {
        this.m_Paintlet.performPaint(g, moment);
    }

    @Override
    public AbstractXYSequencePointHitDetector newHitDetector() {
        return this.m_Paintlet.newHitDetector();
    }

    @Override
    public AbstractXYSequencePointHitDetector getHitDetector() {
        if (this.m_Paintlet instanceof HitDetectorSupporter) {
            return (AbstractXYSequencePointHitDetector)((HitDetectorSupporter)((Object)this.m_Paintlet)).getHitDetector();
        }
        return this.m_HitDetector;
    }

    @Override
    public void setActor(Actor actor) {
        this.m_Actor = actor;
    }

    @Override
    public Actor getActor() {
        return this.m_Actor;
    }
}

