/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.sequence;

import adams.gui.core.AntiAliasingSupporter;
import adams.gui.core.GUIHelper;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AbstractStrokePaintlet;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.sequence.AbstractXYSequencePointHitDetector;
import adams.gui.visualization.sequence.XYSequencePaintlet;
import adams.gui.visualization.sequence.XYSequencePanel;
import java.awt.Color;
import java.awt.Graphics;

public class StraightLineOverlayPaintlet
extends AbstractStrokePaintlet
implements XYSequencePaintlet,
AntiAliasingSupporter {
    private static final long serialVersionUID = 6292059403058224856L;
    protected double m_XFactor;
    protected double m_YOffset;
    protected Color m_Color;
    protected boolean m_AntiAliasingEnabled;

    @Override
    public String globalInfo() {
        return "Draws a straight line. The inclination can be influenced using the x-factor.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("x-factor", "XFactor", 1.0);
        this.m_OptionManager.add("y-offset", "YOffset", 0.0);
        this.m_OptionManager.add("color", "color", Color.BLACK);
        this.m_OptionManager.add("anti-aliasing-enabled", "antiAliasingEnabled", GUIHelper.getBoolean(this.getClass(), "antiAliasingEnabled", true));
    }

    public void setXFactor(double value) {
        this.m_XFactor = value;
        this.memberChanged();
    }

    public double getXFactor() {
        return this.m_XFactor;
    }

    public String XFactorTipText() {
        return "The factor to multiply the X values with to determine the inclination of the line ('slope').";
    }

    public void setYOffset(double value) {
        this.m_YOffset = value;
        this.memberChanged();
    }

    public double getYOffset() {
        return this.m_YOffset;
    }

    public String YOffsetTipText() {
        return "The offset to shift the line up or down on the Y axis ('intercept').";
    }

    public void setColor(Color value) {
        this.m_Color = value;
        this.memberChanged();
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color for the line.";
    }

    @Override
    public void setAntiAliasingEnabled(boolean value) {
        this.m_AntiAliasingEnabled = value;
        this.memberChanged();
    }

    @Override
    public boolean isAntiAliasingEnabled() {
        return this.m_AntiAliasingEnabled;
    }

    @Override
    public String antiAliasingEnabledTipText() {
        return "If enabled, uses anti-aliasing for drawing lines.";
    }

    @Override
    public PaintEvent.PaintMoment getPaintMoment() {
        return PaintEvent.PaintMoment.GRID;
    }

    @Override
    public XYSequencePanel getSequencePanel() {
        return (XYSequencePanel)this.getPanel();
    }

    @Override
    public AbstractXYSequencePointHitDetector newHitDetector() {
        return null;
    }

    @Override
    public void performPaint(Graphics g, PaintEvent.PaintMoment moment) {
        AxisPanel xAxis = this.getPlot().getAxis(Axis.BOTTOM);
        AxisPanel yAxis = this.getPlot().getAxis(Axis.LEFT);
        double xMin = xAxis.getActualMinimum();
        double yMin = xMin * this.m_XFactor + this.m_YOffset;
        double xMax = xAxis.getActualMaximum();
        double yMax = xMax * this.m_XFactor + this.m_YOffset;
        g.setColor(this.m_Color);
        GUIHelper.configureAntiAliasing(g, this.m_AntiAliasingEnabled);
        g.drawLine(xAxis.valueToPos(xMin), yAxis.valueToPos(yMin), xAxis.valueToPos(xMax), yAxis.valueToPos(yMax));
    }
}

