/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.wizard;

import adams.core.Properties;
import adams.core.option.OptionUtils;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.GUIHelper;
import adams.gui.goe.PropertySheetPanel;
import adams.gui.wizard.AbstractWizardPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public class PropertySheetPanelPage
extends AbstractWizardPage {
    private static final long serialVersionUID = -7633802524155866313L;
    public static final String PROPERTY_CMDLINE = "Commandline";
    protected PropertySheetPanel m_PanelSheet;
    protected JPanel m_PanelButtons;
    protected JButton m_ButtonLoad;
    protected JButton m_ButtonSave;
    protected BaseFileChooser m_FileChooser;

    public PropertySheetPanelPage() {
    }

    public PropertySheetPanelPage(String pageName) {
        this();
        this.setPageName(pageName);
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_PanelSheet = new PropertySheetPanel();
        this.m_PanelSheet.setShowAboutBox(false);
        this.add((Component)this.m_PanelSheet, "Center");
        this.m_PanelButtons = new JPanel(new BorderLayout());
        this.add((Component)this.m_PanelButtons, "South");
        JPanel panel = new JPanel(new FlowLayout(0));
        this.m_PanelButtons.add((Component)panel, "West");
        this.m_ButtonLoad = new JButton(GUIHelper.getIcon("open.gif"));
        this.m_ButtonLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertySheetPanelPage.this.loadProperties();
            }
        });
        panel.add(this.m_ButtonLoad);
        this.m_ButtonSave = new JButton(GUIHelper.getIcon("save.gif"));
        this.m_ButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertySheetPanelPage.this.saveProperties();
            }
        });
        panel.add(this.m_ButtonSave);
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        this.setButtonPanelVisible(false);
    }

    public PropertySheetPanel getParameterPanel() {
        return this.m_PanelSheet;
    }

    public void setTarget(Object value) {
        this.m_PanelSheet.setTarget(value);
    }

    public Object getTarget() {
        return this.m_PanelSheet.getTarget();
    }

    public void setProperties(Properties value) {
        String cmdline = value.getProperty(PROPERTY_CMDLINE, OptionUtils.getCommandLine(this.m_PanelSheet.getTarget()));
        try {
            this.setTarget(OptionUtils.forAnyCommandLine(Object.class, cmdline));
        }
        catch (Exception e) {
            System.err.println("Failed to parse commandline: " + cmdline);
            e.printStackTrace();
            this.setTarget(this.m_PanelSheet.getTarget());
        }
        this.updateButtons();
    }

    @Override
    public Properties getProperties() {
        Properties result = new Properties();
        result.setProperty(PROPERTY_CMDLINE, OptionUtils.getCommandLine(this.m_PanelSheet.getTarget()));
        return result;
    }

    protected synchronized BaseFileChooser getFileChooser() {
        if (this.m_FileChooser == null) {
            this.m_FileChooser = new BaseFileChooser();
            this.m_FileChooser.setAutoAppendExtension(true);
            ExtensionFileFilter filter = ExtensionFileFilter.getPropertiesFileFilter();
            this.m_FileChooser.addChoosableFileFilter(filter);
            this.m_FileChooser.setFileFilter(filter);
        }
        return this.m_FileChooser;
    }

    protected void loadProperties() {
        int retVal = this.getFileChooser().showOpenDialog(this);
        if (retVal != 0) {
            return;
        }
        Properties props = new Properties();
        if (!props.load(this.getFileChooser().getSelectedFile().getAbsolutePath())) {
            GUIHelper.showErrorMessage(this, "Failed to load properties from: " + this.getFileChooser().getSelectedFile());
            return;
        }
        this.setProperties(props);
    }

    protected void saveProperties() {
        int retVal = this.getFileChooser().showSaveDialog(this);
        if (retVal != 0) {
            return;
        }
        Properties props = this.getProperties();
        if (!props.save(this.getFileChooser().getSelectedFile().getAbsolutePath())) {
            GUIHelper.showErrorMessage(this, "Failed to save properties to: " + this.getFileChooser().getSelectedFile());
        }
    }

    public void setButtonPanelVisible(boolean value) {
        this.m_PanelButtons.setVisible(value);
    }

    public boolean isButtonPanelVisible() {
        return this.m_PanelButtons.isVisible();
    }
}

