/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.wizard;

import adams.core.Properties;
import adams.gui.chooser.DirectoryChooserPanel;
import adams.gui.wizard.AbstractWizardPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SelectDirectoryPage
extends AbstractWizardPage {
    private static final long serialVersionUID = -7633802524155866313L;
    public static final String KEY_DIRECTORY = "directory";
    protected DirectoryChooserPanel m_PanelDir;

    public SelectDirectoryPage() {
    }

    public SelectDirectoryPage(String pageName) {
        this();
        this.setPageName(pageName);
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        JPanel panel = new JPanel(new BorderLayout());
        this.add((Component)panel, "Center");
        this.m_PanelDir = new DirectoryChooserPanel();
        this.m_PanelDir.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SelectDirectoryPage.this.updateButtons();
            }
        });
        panel.add((Component)this.m_PanelDir, "North");
    }

    public void setCurrentDirectory(File value) {
        if (value.exists() && value.isDirectory()) {
            this.m_PanelDir.setCurrentDirectory(value);
        }
    }

    public File getCurrentDirectory() {
        return this.m_PanelDir.getCurrentDirectory();
    }

    public boolean setCurrent(File value) {
        if (value.exists() && value.isDirectory()) {
            return this.m_PanelDir.setCurrent(value);
        }
        return false;
    }

    public File getCurrent() {
        return (File)this.m_PanelDir.getCurrent();
    }

    @Override
    public Properties getProperties() {
        Properties result = new Properties();
        result.setProperty(KEY_DIRECTORY, ((File)this.m_PanelDir.getCurrent()).getAbsolutePath());
        return result;
    }
}

