/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.wizard;

import adams.core.Properties;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionUtils;
import adams.gui.chooser.BaseDirectoryChooser;
import adams.gui.core.BaseListWithButtons;
import adams.gui.wizard.AbstractWizardPage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectMultipleDirectoriesPage
extends AbstractWizardPage {
    private static final long serialVersionUID = -7633802524155866313L;
    public static final String KEY_DIRECTORIES = "directories";
    protected BaseListWithButtons m_ListDirs;
    protected BaseDirectoryChooser m_DirChooser;
    protected JButton m_ButtonAdd;
    protected JButton m_ButtonRemove;
    protected JButton m_ButtonRemoveAll;
    protected JButton m_ButtonMoveUp;
    protected JButton m_ButtonMoveDown;

    public SelectMultipleDirectoriesPage() {
    }

    public SelectMultipleDirectoriesPage(String pageName) {
        this();
        this.setPageName(pageName);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_DirChooser = new BaseDirectoryChooser();
        this.m_DirChooser.setMultiSelectionEnabled(true);
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_ListDirs = new BaseListWithButtons(new DefaultListModel());
        this.m_ListDirs.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SelectMultipleDirectoriesPage.this.updateListButtons();
            }
        });
        this.add((Component)this.m_ListDirs, "Center");
        this.m_ButtonAdd = new JButton("Add...");
        this.m_ButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int retVal = SelectMultipleDirectoriesPage.this.m_DirChooser.showOpenDialog(SelectMultipleDirectoriesPage.this);
                if (retVal != 0) {
                    return;
                }
                File[] selected = SelectMultipleDirectoriesPage.this.m_DirChooser.getSelectedFiles();
                DefaultListModel model = (DefaultListModel)SelectMultipleDirectoriesPage.this.m_ListDirs.getModel();
                for (File file : selected) {
                    model.addElement(file.getAbsolutePath());
                }
                SelectMultipleDirectoriesPage.this.updateListButtons();
            }
        });
        this.m_ListDirs.addToButtonsPanel(this.m_ButtonAdd);
        this.m_ListDirs.addToButtonsPanel(new JLabel(""));
        this.m_ButtonMoveUp = new JButton("Up");
        this.m_ButtonMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectMultipleDirectoriesPage.this.m_ListDirs.moveUp();
            }
        });
        this.m_ListDirs.addToButtonsPanel(this.m_ButtonMoveUp);
        this.m_ButtonMoveDown = new JButton("Down");
        this.m_ButtonMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectMultipleDirectoriesPage.this.m_ListDirs.moveDown();
            }
        });
        this.m_ListDirs.addToButtonsPanel(this.m_ButtonMoveDown);
        this.m_ListDirs.addToButtonsPanel(new JLabel(""));
        this.m_ButtonRemove = new JButton("Remove");
        this.m_ButtonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indices = SelectMultipleDirectoriesPage.this.m_ListDirs.getSelectedIndices();
                DefaultListModel model = (DefaultListModel)SelectMultipleDirectoriesPage.this.m_ListDirs.getModel();
                for (int i = indices.length - 1; i >= 0; --i) {
                    model.remove(indices[i]);
                }
                SelectMultipleDirectoriesPage.this.updateListButtons();
            }
        });
        this.m_ListDirs.addToButtonsPanel(this.m_ButtonRemove);
        this.m_ButtonRemoveAll = new JButton("Remove all");
        this.m_ButtonRemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultListModel model = (DefaultListModel)SelectMultipleDirectoriesPage.this.m_ListDirs.getModel();
                model.removeAllElements();
                SelectMultipleDirectoriesPage.this.updateListButtons();
            }
        });
        this.m_ListDirs.addToButtonsPanel(this.m_ButtonRemoveAll);
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        this.updateListButtons();
    }

    protected void updateListButtons() {
        this.m_ButtonAdd.setEnabled(true);
        this.m_ButtonMoveUp.setEnabled(this.m_ListDirs.canMoveUp());
        this.m_ButtonMoveDown.setEnabled(this.m_ListDirs.canMoveDown());
        this.m_ButtonRemove.setEnabled(this.m_ListDirs.getSelectedIndices().length > 0);
        this.m_ButtonRemoveAll.setEnabled(this.m_ListDirs.getModel().getSize() > 0);
        this.updateButtons();
    }

    public void setCurrentDirectory(File value) {
        this.m_DirChooser.setCurrentDirectory(new PlaceholderFile(value));
    }

    public File getCurrentDirectory() {
        return this.m_DirChooser.getCurrentDirectory();
    }

    public void setCurrent(File[] value) {
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (File file : value) {
            model.addElement(file.getAbsolutePath());
        }
        this.m_ListDirs.setModel(model);
    }

    public File[] getCurrent() {
        ArrayList<File> result = new ArrayList<File>();
        for (int i = 0; i < this.m_ListDirs.getModel().getSize(); ++i) {
            result.add(new File("" + this.m_ListDirs.getModel().getElementAt(i)));
        }
        return result.toArray(new File[result.size()]);
    }

    @Override
    public Properties getProperties() {
        Properties result = new Properties();
        ArrayList<String> files = new ArrayList<String>();
        for (int i = 0; i < this.m_ListDirs.getModel().getSize(); ++i) {
            files.add("" + this.m_ListDirs.getModel().getElementAt(i));
        }
        result.setProperty(KEY_DIRECTORIES, OptionUtils.joinOptions(files.toArray(new String[files.size()])));
        return result;
    }
}

