/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.grid.refine;

import boofcv.alg.feature.detect.edge.CannyEdge;
import boofcv.alg.feature.detect.edge.EdgeContour;
import boofcv.alg.feature.detect.edge.EdgeSegment;
import boofcv.factory.feature.detect.edge.FactoryEdgeDetectors;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSingleBand;
import georegression.geometry.UtilPoint2D_F64;
import georegression.metric.Distance2D_F64;
import georegression.struct.line.LineParametric2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.optimization.FactoryOptimization;
import org.ddogleg.optimization.IterativeOptimization;
import org.ddogleg.optimization.UnconstrainedMinimization;
import org.ddogleg.optimization.UtilOptimize;
import org.ddogleg.optimization.functions.FunctionNtoS;
import org.ddogleg.struct.FastQueue;

public class RefineCornerCanny {
    private CostFunction func = new CostFunction();
    private UnconstrainedMinimization alg = FactoryOptimization.unconstrained();
    CannyEdge<ImageFloat32, ImageFloat32> detectEdge;
    Point2D_F64 corner;
    private FastQueue<Point2D_F64> points = new FastQueue(100, Point2D_F64.class, true);
    InitialEstimate initial = new InitialEstimate();

    public RefineCornerCanny() {
        this.detectEdge = FactoryEdgeDetectors.canny((int)2, (boolean)true, (boolean)true, ImageFloat32.class, ImageFloat32.class);
    }

    public void process(ImageFloat32 image) {
        this.detectEdge.process((ImageSingleBand)image, 0.1f, 0.3f, null);
        List edges = this.detectEdge.getContours();
        ArrayList<Point2D_I32> all = new ArrayList<Point2D_I32>();
        this.points.reset();
        for (EdgeContour e : edges) {
            for (EdgeSegment l : e.segments) {
                for (Point2D_I32 p : l.points) {
                    all.add(p);
                    ((Point2D_F64)this.points.grow()).set((double)p.x, (double)p.y);
                }
            }
        }
        this.selectEdgeParam(all, image.width, image.height);
        this.selectCornerParam(all);
        this.corner = this.optimizeFit();
    }

    private void selectEdgeParam(List<Point2D_I32> all, int w, int h) {
        ArrayList<Point2D_I32> onEdge = new ArrayList<Point2D_I32>();
        for (Point2D_I32 p : all) {
            if (p.x != 0 && p.x != w - 1 && p.y != 0 && p.y != h - 1) continue;
            onEdge.add(p);
        }
        int bestDistance = -1;
        Point2D_I32 bestA = null;
        Point2D_I32 bestB = null;
        for (int i = 0; i < onEdge.size(); ++i) {
            Point2D_I32 first = (Point2D_I32)onEdge.get(i);
            for (int j = i + 1; j < onEdge.size(); ++j) {
                Point2D_I32 second = (Point2D_I32)onEdge.get(j);
                int distance = first.distance2(second);
                if (distance <= bestDistance) continue;
                bestDistance = distance;
                bestA = first;
                bestB = second;
            }
        }
        if (bestDistance == -1) {
            throw new RuntimeException("Something went very wrong!");
        }
        this.initial.sideA = bestA;
        this.initial.sideB = bestB;
    }

    private void selectCornerParam(List<Point2D_I32> all) {
        Point2D_I32 a = this.initial.sideA;
        Point2D_I32 b = this.initial.sideB;
        Point2D_I32 bestPoint = null;
        double bestDist = -1.0;
        for (int i = 0; i < all.size(); ++i) {
            double distB;
            Point2D_I32 p = all.get(i);
            double distA = UtilPoint2D_F64.distance((double)a.x, (double)a.y, (double)p.x, (double)p.y);
            double sum = distA + (distB = UtilPoint2D_F64.distance((double)b.x, (double)b.y, (double)p.x, (double)p.y));
            if (!(sum >= bestDist)) continue;
            bestDist = sum;
            bestPoint = p;
        }
        this.initial.corner = new Point2D_F64((double)bestPoint.x, (double)bestPoint.y);
    }

    private Point2D_F64 optimizeFit() {
        double[] param = new double[]{this.initial.corner.x, this.initial.corner.y, Math.atan2((double)this.initial.sideA.y - this.initial.corner.y, (double)this.initial.sideA.x - this.initial.corner.x), Math.atan2((double)this.initial.sideB.y - this.initial.corner.y, (double)this.initial.sideB.x - this.initial.corner.x)};
        this.alg.setFunction((FunctionNtoS)this.func, null, 0.0);
        this.alg.initialize(param, 0.0, 1.0E-8);
        if (!UtilOptimize.process((IterativeOptimization)this.alg, (int)500)) {
            // empty if block
        }
        double[] found = this.alg.getParameters();
        return new Point2D_F64(found[0], found[1]);
    }

    public Point2D_F64 getCorner() {
        return this.corner;
    }

    private class CostFunction
    implements FunctionNtoS {
        LineParametric2D_F64 lineA = new LineParametric2D_F64();
        LineParametric2D_F64 lineB = new LineParametric2D_F64();

        private CostFunction() {
        }

        public int getNumOfInputsN() {
            return 4;
        }

        public double process(double[] input) {
            double x = input[0];
            double y = input[1];
            double thetaA = input[2];
            double thetaB = input[3];
            this.lineA.p.set(x, y);
            this.lineB.p.set(x, y);
            this.lineA.slope.set(Math.cos(thetaA), Math.sin(thetaA));
            this.lineB.slope.set(Math.cos(thetaB), Math.sin(thetaB));
            double cost = 0.0;
            for (int i = 0; i < ((RefineCornerCanny)RefineCornerCanny.this).points.size; ++i) {
                double distB;
                Point2D_F64 p = (Point2D_F64)RefineCornerCanny.this.points.get(i);
                double distA = Distance2D_F64.distanceSq((LineParametric2D_F64)this.lineA, (Point2D_F64)p);
                double distMin = Math.min(distA, distB = Distance2D_F64.distanceSq((LineParametric2D_F64)this.lineB, (Point2D_F64)p));
                if (distMin < 4.0) {
                    cost += distMin;
                    continue;
                }
                cost += 4.0;
            }
            return cost;
        }
    }

    private static class InitialEstimate {
        Point2D_I32 sideA;
        Point2D_I32 sideB;
        Point2D_F64 corner;

        private InitialEstimate() {
        }
    }
}

