/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.Utils;
import adams.core.base.BaseObject;
import adams.core.base.TwitterFilterExpression;
import adams.core.option.AbstractOption;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTextArea;
import adams.gui.core.GUIHelper;
import adams.gui.dialog.HelpDialog;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import adams.gui.goe.InlineEditorSupport;
import adams.gui.goe.MultiLineValueDialog;
import adams.gui.goe.MultiSelectionEditor;
import adams.parser.TwitterFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;

public class TwitterFilterExpressionEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler,
MultiSelectionEditor,
InlineEditorSupport {
    protected JTextComponent m_TextValue;
    protected JButton m_ButtonHelp;

    public static String toString(AbstractOption option, Object object) {
        return ((TwitterFilterExpression)((Object)object)).getValue();
    }

    public static Object valueOf(AbstractOption option, String str) {
        return new TwitterFilterExpression(str);
    }

    public String toCustomStringRepresentation(Object obj) {
        return TwitterFilterExpressionEditor.toString(null, obj);
    }

    public Object fromCustomStringRepresentation(String str) {
        return TwitterFilterExpressionEditor.valueOf(null, str);
    }

    public String getJavaInitializationString() {
        String result = "new " + this.getValue().getClass().getName() + "(\"" + TwitterFilterExpressionEditor.toString(null, this.getValue()) + "\")";
        return result;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        String val = this.getValue() == null ? "null" : TwitterFilterExpressionEditor.toString(null, this.getValue());
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }

    protected JComponent createCustomEditor() {
        this.m_TextValue = new BaseTextArea(1, 20);
        ((BaseTextArea)this.m_TextValue).setLineWrap(true);
        this.m_TextValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    TwitterFilterExpressionEditor.this.acceptInput();
                } else if (e.getKeyCode() == 27) {
                    e.consume();
                    TwitterFilterExpressionEditor.this.discardInput();
                } else {
                    super.keyPressed(e);
                }
            }
        });
        JPanel panelAll = new JPanel(new BorderLayout());
        JLabel label = new JLabel("Value");
        label.setDisplayedMnemonic('V');
        label.setLabelFor(this.m_TextValue);
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(label);
        panelAll.add((Component)panel, "West");
        panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 0));
        panel.add((Component)new BaseScrollPane((Component)this.m_TextValue), "Center");
        panelAll.add((Component)panel, "Center");
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        panelAll.add((Component)panelButtons, "South");
        this.m_ButtonHelp = new JButton(GUIHelper.getIcon((String)"help2.png"));
        this.m_ButtonHelp.setToolTipText("Display grammar");
        this.m_ButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpDialog dialog = new HelpDialog((Dialog)null);
                dialog.setHelp(new TwitterFilter().getGrammar(), false);
                dialog.setSize(800, 600);
                dialog.setLocationRelativeTo(null);
                dialog.setVisible(true);
            }
        });
        panel = new JPanel(new FlowLayout(0));
        panelAll.add((Component)panel, "East");
        panel.add(this.m_ButtonHelp);
        JButton buttonOK = new JButton("OK");
        buttonOK.setMnemonic('O');
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TwitterFilterExpressionEditor.this.acceptInput();
            }
        });
        panelButtons.add(buttonOK);
        JButton buttonClose = new JButton("Cancel");
        buttonClose.setMnemonic('C');
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TwitterFilterExpressionEditor.this.discardInput();
            }
        });
        panelButtons.add(buttonClose);
        return panelAll;
    }

    protected TwitterFilterExpression parse(String s) {
        TwitterFilterExpression result;
        try {
            result = new TwitterFilterExpression(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    protected void acceptInput() {
        String s = this.m_TextValue.getText();
        if (this.isValid(s) && !this.isUnchanged(s)) {
            this.setValue((Object)this.parse(s));
        }
        this.closeDialog(1);
    }

    protected void discardInput() {
        this.closeDialog(0);
    }

    protected void initForDisplay() {
        super.initForDisplay();
        if (!this.m_TextValue.getText().equals("" + this.getValue())) {
            this.m_TextValue.setText("" + this.getValue());
        }
        this.m_TextValue.setCaretPosition(0);
        this.m_TextValue.setToolTipText(((BaseObject)this.getValue()).getTipText());
        this.m_TextValue.grabFocus();
    }

    protected boolean isValid(String s) {
        return ((BaseObject)this.getValue()).isValid(s);
    }

    protected boolean isUnchanged(String s) {
        return s.equals(((BaseObject)this.getValue()).getValue());
    }

    public Object[] getSelectedObjects(Container parent) {
        TwitterFilterExpression[] result;
        MultiLineValueDialog dialog = new MultiLineValueDialog();
        dialog.setInfoText("Enter the filter expressions, one per line:");
        dialog.setLocationRelativeTo((Component)parent);
        dialog.setVisible(true);
        if (dialog.getOption() == 0) {
            Vector<String> lines = new Vector<String>(Arrays.asList(dialog.getContent().split("\n")));
            Utils.removeEmptyLines(lines);
            result = new TwitterFilterExpression[lines.size()];
            for (int i = 0; i < lines.size(); ++i) {
                result[i] = new TwitterFilterExpression(lines.get(i));
            }
        } else {
            result = new TwitterFilterExpression[]{};
        }
        return result;
    }

    public boolean isInlineEditingAvailable() {
        return true;
    }

    public void setInlineValue(String value) {
        if (this.isInlineValueValid(value)) {
            this.setValue((Object)new TwitterFilterExpression(value));
        }
    }

    public String getInlineValue() {
        return ((BaseObject)this.getValue()).getValue();
    }

    public boolean isInlineValueValid(String value) {
        return ((BaseObject)this.getValue()).isValid(value);
    }
}

