/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.ColumnBuilder;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.IndexBuilder;
import com.healthmarketscience.jackcess.impl.ColumnImpl;
import com.healthmarketscience.jackcess.impl.DatabaseImpl;
import com.healthmarketscience.jackcess.impl.JetFormat;
import com.healthmarketscience.jackcess.impl.PageChannel;
import com.healthmarketscience.jackcess.impl.TableImpl;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TableCreator {
    private final DatabaseImpl _database;
    private final String _name;
    private final List<ColumnBuilder> _columns;
    private final List<IndexBuilder> _indexes;
    private final Map<IndexBuilder, IndexState> _indexStates = new IdentityHashMap<IndexBuilder, IndexState>();
    private final Map<ColumnBuilder, ColumnState> _columnStates = new IdentityHashMap<ColumnBuilder, ColumnState>();
    private final List<ColumnBuilder> _lvalCols = new ArrayList<ColumnBuilder>();
    private int _tdefPageNumber = -1;
    private int _umapPageNumber = -1;
    private int _indexCount;
    private int _logicalIndexCount;

    public TableCreator(DatabaseImpl database, String name, List<ColumnBuilder> columns, List<IndexBuilder> indexes) {
        this._database = database;
        this._name = name;
        this._columns = columns;
        this._indexes = indexes != null ? indexes : Collections.emptyList();
    }

    public JetFormat getFormat() {
        return this._database.getFormat();
    }

    public PageChannel getPageChannel() {
        return this._database.getPageChannel();
    }

    public Charset getCharset() {
        return this._database.getCharset();
    }

    public int getTdefPageNumber() {
        return this._tdefPageNumber;
    }

    public int getUmapPageNumber() {
        return this._umapPageNumber;
    }

    public List<ColumnBuilder> getColumns() {
        return this._columns;
    }

    public List<IndexBuilder> getIndexes() {
        return this._indexes;
    }

    public boolean hasIndexes() {
        return !this._indexes.isEmpty();
    }

    public int getIndexCount() {
        return this._indexCount;
    }

    public int getLogicalIndexCount() {
        return this._logicalIndexCount;
    }

    public IndexState getIndexState(IndexBuilder idx) {
        return this._indexStates.get(idx);
    }

    public int reservePageNumber() throws IOException {
        return this.getPageChannel().allocateNewPage();
    }

    public ColumnState getColumnState(ColumnBuilder col) {
        return this._columnStates.get(col);
    }

    public List<ColumnBuilder> getLongValueColumns() {
        return this._lvalCols;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTable() throws IOException {
        this.validate();
        short columnNumber = 0;
        for (ColumnBuilder col : this._columns) {
            short s = columnNumber;
            columnNumber = (short)(columnNumber + 1);
            col.setColumnNumber(s);
            if (!col.getType().isLongValue()) continue;
            this._lvalCols.add(col);
            this._columnStates.put(col, new ColumnState());
        }
        if (this.hasIndexes()) {
            for (IndexBuilder idx : this._indexes) {
                IndexState idxState = new IndexState();
                idxState.setIndexNumber(this._logicalIndexCount++);
                idxState.setIndexDataNumber(this._indexCount++);
                this._indexStates.put(idx, idxState);
            }
        }
        this.getPageChannel().startWrite();
        try {
            this._tdefPageNumber = this.reservePageNumber();
            this._umapPageNumber = this.reservePageNumber();
            TableImpl.writeTableDefinition(this);
            this._database.addNewTable(this._name, this._tdefPageNumber, DatabaseImpl.TYPE_TABLE, null, null);
        }
        finally {
            this.getPageChannel().finishWrite();
        }
    }

    private void validate() {
        DatabaseImpl.validateIdentifierName(this._name, this.getFormat().MAX_TABLE_NAME_LENGTH, "table");
        if (this._columns == null || this._columns.isEmpty()) {
            throw new IllegalArgumentException("Cannot create table with no columns");
        }
        if (this._columns.size() > this.getFormat().MAX_COLUMNS_PER_TABLE) {
            throw new IllegalArgumentException("Cannot create table with more than " + this.getFormat().MAX_COLUMNS_PER_TABLE + " columns");
        }
        ColumnImpl.SortOrder dbSortOrder = null;
        try {
            dbSortOrder = this._database.getDefaultSortOrder();
        }
        catch (IOException e) {
            // empty catch block
        }
        HashSet<String> colNames = new HashSet<String>();
        for (ColumnBuilder column : this._columns) {
            if (column.getType() == DataType.COMPLEX_TYPE) {
                throw new UnsupportedOperationException("Complex column creation is not yet implemented");
            }
            column.validate(this.getFormat());
            if (!colNames.add(column.getName().toUpperCase())) {
                throw new IllegalArgumentException("duplicate column name: " + column.getName());
            }
            if (!column.getType().isTextual() || column.getTextSortOrder() != null) continue;
            column.setTextSortOrder(dbSortOrder);
        }
        List<ColumnBuilder> autoCols = this.getAutoNumberColumns();
        if (autoCols.size() > 1) {
            EnumSet<DataType> autoTypes = EnumSet.noneOf(DataType.class);
            for (ColumnBuilder c : autoCols) {
                if (c.getType().isMultipleAutoNumberAllowed() || autoTypes.add(c.getType())) continue;
                throw new IllegalArgumentException("Can have at most one AutoNumber column of type " + (Object)((Object)c.getType()) + " per table");
            }
        }
        if (this.hasIndexes()) {
            if (this._indexes.size() > this.getFormat().MAX_INDEXES_PER_TABLE) {
                throw new IllegalArgumentException("Cannot create table with more than " + this.getFormat().MAX_INDEXES_PER_TABLE + " indexes");
            }
            HashSet<String> idxNames = new HashSet<String>();
            boolean foundPk = false;
            for (IndexBuilder index : this._indexes) {
                index.validate(colNames, this.getFormat());
                if (!idxNames.add(index.getName().toUpperCase())) {
                    throw new IllegalArgumentException("duplicate index name: " + index.getName());
                }
                if (!index.isPrimaryKey()) continue;
                if (foundPk) {
                    throw new IllegalArgumentException("found second primary key index: " + index.getName());
                }
                foundPk = true;
            }
        }
    }

    private List<ColumnBuilder> getAutoNumberColumns() {
        ArrayList<ColumnBuilder> autoCols = new ArrayList<ColumnBuilder>(1);
        for (ColumnBuilder c : this._columns) {
            if (!c.isAutoNumber()) continue;
            autoCols.add(c);
        }
        return autoCols;
    }

    static final class ColumnState {
        private byte _umapOwnedRowNumber;
        private byte _umapFreeRowNumber;
        private int _umapPageNumber;

        ColumnState() {
        }

        public byte getUmapOwnedRowNumber() {
            return this._umapOwnedRowNumber;
        }

        public void setUmapOwnedRowNumber(byte newUmapOwnedRowNumber) {
            this._umapOwnedRowNumber = newUmapOwnedRowNumber;
        }

        public byte getUmapFreeRowNumber() {
            return this._umapFreeRowNumber;
        }

        public void setUmapFreeRowNumber(byte newUmapFreeRowNumber) {
            this._umapFreeRowNumber = newUmapFreeRowNumber;
        }

        public int getUmapPageNumber() {
            return this._umapPageNumber;
        }

        public void setUmapPageNumber(int newUmapPageNumber) {
            this._umapPageNumber = newUmapPageNumber;
        }
    }

    static final class IndexState {
        private int _indexNumber;
        private int _indexDataNumber;
        private byte _umapRowNumber;
        private int _umapPageNumber;
        private int _rootPageNumber;

        IndexState() {
        }

        public int getIndexNumber() {
            return this._indexNumber;
        }

        public void setIndexNumber(int newIndexNumber) {
            this._indexNumber = newIndexNumber;
        }

        public int getIndexDataNumber() {
            return this._indexDataNumber;
        }

        public void setIndexDataNumber(int newIndexDataNumber) {
            this._indexDataNumber = newIndexDataNumber;
        }

        public byte getUmapRowNumber() {
            return this._umapRowNumber;
        }

        public void setUmapRowNumber(byte newUmapRowNumber) {
            this._umapRowNumber = newUmapRowNumber;
        }

        public int getUmapPageNumber() {
            return this._umapPageNumber;
        }

        public void setUmapPageNumber(int newUmapPageNumber) {
            this._umapPageNumber = newUmapPageNumber;
        }

        public int getRootPageNumber() {
            return this._rootPageNumber;
        }

        public void setRootPageNumber(int newRootPageNumber) {
            this._rootPageNumber = newRootPageNumber;
        }
    }
}

