/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.core.driftdetection;

import moa.classifiers.core.driftdetection.AbstractChangeDetector;
import moa.core.ObjectRepository;
import moa.options.FloatOption;
import moa.options.MultiChoiceOption;
import moa.tasks.TaskMonitor;

public class HDDM_W_Test
extends AbstractChangeDetector {
    protected static final long serialVersionUID = 1L;
    public FloatOption driftConfidenceOption = new FloatOption("driftConfidence", 'd', "Confidence to the drift", 0.001, 0.0, 1.0);
    public FloatOption warningConfidenceOption = new FloatOption("warningConfidence", 'w', "Confidence to the warning", 0.005, 0.0, 1.0);
    public FloatOption lambdaOption = new FloatOption("lambda", 'm', "Controls how much weight is given to more recent data compared to older data. Smaller values mean less weight given to recent data.", 0.05, 0.0, 1.0);
    public MultiChoiceOption oneSidedTestOption = new MultiChoiceOption("typeOfTest", 't', "Monitors error increments and decrements (two-sided) or only increments (one-sided)", new String[]{"One-sided", "Two-sided"}, new String[]{"One-sided", "Two-sided"}, 0);
    private static SampleInfo sample1_IncrMonitoring;
    private static SampleInfo sample2_IncrMonitoring;
    private static SampleInfo sample1_DecrMonitoring;
    private static SampleInfo sample2_DecrMonitoring;
    private static SampleInfo total;
    protected double incrCutPoint;
    protected double decrCutPoint;
    protected double lambda;
    protected double warningConfidence;
    protected double driftConfidence;
    protected boolean oneSidedTest;
    protected int width;

    public HDDM_W_Test() {
        this.resetLearning();
    }

    @Override
    public void resetLearning() {
        super.resetLearning();
        total = new SampleInfo();
        sample1_DecrMonitoring = new SampleInfo();
        sample1_IncrMonitoring = new SampleInfo();
        sample2_DecrMonitoring = new SampleInfo();
        sample2_IncrMonitoring = new SampleInfo();
        this.incrCutPoint = Double.MAX_VALUE;
        this.decrCutPoint = Double.MIN_VALUE;
        this.lambda = this.lambdaOption.getValue();
        this.driftConfidence = this.driftConfidenceOption.getValue();
        this.warningConfidence = this.warningConfidenceOption.getValue();
        this.oneSidedTest = this.oneSidedTestOption.getChosenIndex() == 0;
        this.width = 0;
        this.delay = 0.0;
    }

    public void input(boolean prediction) {
        double value = !prediction ? 1.0 : 0.0;
        this.input(value);
    }

    @Override
    public void input(double value) {
        double auxDecayRate = 1.0 - this.lambda;
        ++this.width;
        if (HDDM_W_Test.total.EWMA_Estimator < 0.0) {
            HDDM_W_Test.total.EWMA_Estimator = value;
            HDDM_W_Test.total.independentBoundedConditionSum = 1.0;
        } else {
            HDDM_W_Test.total.EWMA_Estimator = this.lambda * value + auxDecayRate * HDDM_W_Test.total.EWMA_Estimator;
            HDDM_W_Test.total.independentBoundedConditionSum = this.lambda * this.lambda + auxDecayRate * auxDecayRate * HDDM_W_Test.total.independentBoundedConditionSum;
        }
        this.updateIncrStatistics(value, this.driftConfidence);
        if (this.monitorMeanIncr(value, this.driftConfidence)) {
            this.resetLearning();
            this.isChangeDetected = true;
            this.isWarningZone = false;
        } else if (this.monitorMeanIncr(value, this.warningConfidence)) {
            this.isChangeDetected = false;
            this.isWarningZone = true;
        } else {
            this.isChangeDetected = false;
            this.isWarningZone = false;
        }
        this.updateDecrStatistics(value, this.driftConfidence);
        if (!this.oneSidedTest && this.monitorMeanDecr(value, this.driftConfidence)) {
            this.resetLearning();
        }
        this.estimation = HDDM_W_Test.total.EWMA_Estimator;
    }

    public boolean detectMeanIncrement(SampleInfo sample1, SampleInfo sample2, double confidence) {
        if (sample1.EWMA_Estimator < 0.0 || sample2.EWMA_Estimator < 0.0) {
            return false;
        }
        double bound = Math.sqrt((sample1.independentBoundedConditionSum + sample2.independentBoundedConditionSum) * Math.log(1.0 / confidence) / 2.0);
        return sample2.EWMA_Estimator - sample1.EWMA_Estimator > bound;
    }

    void updateIncrStatistics(double valor, double confidence) {
        double auxDecay = 1.0 - this.lambda;
        double bound = Math.sqrt(HDDM_W_Test.total.independentBoundedConditionSum * Math.log(1.0 / this.driftConfidence) / 2.0);
        if (HDDM_W_Test.total.EWMA_Estimator + bound < this.incrCutPoint) {
            this.incrCutPoint = HDDM_W_Test.total.EWMA_Estimator + bound;
            HDDM_W_Test.sample1_IncrMonitoring.EWMA_Estimator = HDDM_W_Test.total.EWMA_Estimator;
            HDDM_W_Test.sample1_IncrMonitoring.independentBoundedConditionSum = HDDM_W_Test.total.independentBoundedConditionSum;
            sample2_IncrMonitoring = new SampleInfo();
            this.delay = 0.0;
        } else {
            this.delay += 1.0;
            if (HDDM_W_Test.sample2_IncrMonitoring.EWMA_Estimator < 0.0) {
                HDDM_W_Test.sample2_IncrMonitoring.EWMA_Estimator = valor;
                HDDM_W_Test.sample2_IncrMonitoring.independentBoundedConditionSum = 1.0;
            } else {
                HDDM_W_Test.sample2_IncrMonitoring.EWMA_Estimator = this.lambda * valor + auxDecay * HDDM_W_Test.sample2_IncrMonitoring.EWMA_Estimator;
                HDDM_W_Test.sample2_IncrMonitoring.independentBoundedConditionSum = this.lambda * this.lambda + auxDecay * auxDecay * HDDM_W_Test.sample2_IncrMonitoring.independentBoundedConditionSum;
            }
        }
    }

    protected boolean monitorMeanIncr(double valor, double confidence) {
        return this.detectMeanIncrement(sample1_IncrMonitoring, sample2_IncrMonitoring, confidence);
    }

    void updateDecrStatistics(double valor, double confidence) {
        double auxDecay = 1.0 - this.lambda;
        double epsilon = Math.sqrt(HDDM_W_Test.total.independentBoundedConditionSum * Math.log(1.0 / this.driftConfidence) / 2.0);
        if (HDDM_W_Test.total.EWMA_Estimator - epsilon > this.decrCutPoint) {
            this.decrCutPoint = HDDM_W_Test.total.EWMA_Estimator - epsilon;
            HDDM_W_Test.sample1_DecrMonitoring.EWMA_Estimator = HDDM_W_Test.total.EWMA_Estimator;
            HDDM_W_Test.sample1_DecrMonitoring.independentBoundedConditionSum = HDDM_W_Test.total.independentBoundedConditionSum;
            sample2_DecrMonitoring = new SampleInfo();
        } else if (HDDM_W_Test.sample2_DecrMonitoring.EWMA_Estimator < 0.0) {
            HDDM_W_Test.sample2_DecrMonitoring.EWMA_Estimator = valor;
            HDDM_W_Test.sample2_DecrMonitoring.independentBoundedConditionSum = 1.0;
        } else {
            HDDM_W_Test.sample2_DecrMonitoring.EWMA_Estimator = this.lambda * valor + auxDecay * HDDM_W_Test.sample2_DecrMonitoring.EWMA_Estimator;
            HDDM_W_Test.sample2_DecrMonitoring.independentBoundedConditionSum = this.lambda * this.lambda + auxDecay * auxDecay * HDDM_W_Test.sample2_DecrMonitoring.independentBoundedConditionSum;
        }
    }

    protected boolean monitorMeanDecr(double valor, double confidence) {
        return this.detectMeanIncrement(sample2_DecrMonitoring, sample1_DecrMonitoring, confidence);
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        this.resetLearning();
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    public static class SampleInfo {
        private static final long serialVersionUID = 1L;
        public double EWMA_Estimator = -1.0;
        public double independentBoundedConditionSum;
    }
}

