/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.rowscore;

import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.rowscore.AbstractRowScore;

public class DistanceFromConstant
extends AbstractRowScore {
    private static final long serialVersionUID = -13137285273610739L;
    protected double m_Constant;

    public String globalInfo() {
        return "Calculates the Euclidean distance to a timeseries that is basically a 'flat-liner' with a constant value.\nOnly non-missing, numeric cells are included in the calculation.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("constant", "constant", (Object)0.0);
    }

    public void setConstant(double value) {
        this.m_Constant = value;
        this.reset();
    }

    public double getConstant() {
        return this.m_Constant;
    }

    public String constantTipText() {
        return "The constant to use for calculating the distance.";
    }

    public int getNumScores() {
        return 1;
    }

    protected Double[] doCalculateScore(SpreadSheet sheet, int rowIndex) {
        Double[] result = new Double[]{0.0};
        DataRow row = sheet.getRow(rowIndex);
        for (Cell cell : row.cells()) {
            if (!cell.isNumeric()) continue;
            Double[] doubleArray = result;
            Double.valueOf(doubleArray[0] + Math.pow(cell.toDouble() - this.m_Constant, 2.0));
        }
        result[0] = Math.sqrt(result[0]);
        return result;
    }
}

