/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.openstreetmapviewer;

import adams.core.base.BaseDateTime;
import adams.data.mapobject.TimestampSupporter;
import adams.flow.sink.openstreetmapviewer.AbstractMapObjectPruner;
import java.util.Date;
import org.openstreetmap.gui.jmapviewer.JMapViewerTree;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;
import org.openstreetmap.gui.jmapviewer.interfaces.MapObject;

public class MaxAgePruner
extends AbstractMapObjectPruner {
    private static final long serialVersionUID = -135743438219473331L;
    protected BaseDateTime m_MaxAge;

    public String globalInfo() {
        return "Removes map objects that are older than a specific timespan compared to the newest map object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("max-age", "maxAge", (Object)new BaseDateTime("START -7 DAY"));
    }

    public void setMaxAge(BaseDateTime value) {
        this.m_MaxAge = value;
        this.reset();
    }

    public BaseDateTime getMaxAge() {
        return this.m_MaxAge;
    }

    public String maxAgeTipText() {
        return "The maximum age; eg 'START -7 DAY' with 'START' being the date of the newest mapobject.";
    }

    @Override
    protected void doPrune(JMapViewerTree tree) {
        MapObject mapobject;
        Date newest = new BaseDateTime("-INF").dateValue();
        for (MapMarker item : tree.getViewer().getMapMarkerList()) {
            if (!(item instanceof TimestampSupporter) || ((TimestampSupporter)item).getTimestamp().compareTo(newest) <= 0) continue;
            newest = ((TimestampSupporter)item).getTimestamp();
        }
        for (MapMarker item : tree.getViewer().getMapRectangleList()) {
            if (!(item instanceof TimestampSupporter) || ((TimestampSupporter)item).getTimestamp().compareTo(newest) <= 0) continue;
            newest = ((TimestampSupporter)item).getTimestamp();
        }
        for (MapMarker item : tree.getViewer().getMapPolygonList()) {
            if (!(item instanceof TimestampSupporter) || ((TimestampSupporter)item).getTimestamp().compareTo(newest) <= 0) continue;
            newest = ((TimestampSupporter)item).getTimestamp();
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("newest: " + newest);
        }
        this.m_MaxAge.setStart(newest);
        Date cutoff = this.m_MaxAge.dateValue();
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("cutoff: " + cutoff);
        }
        int i = 0;
        int pruned = 0;
        while (i < tree.getViewer().getMapMarkerList().size()) {
            mapobject = (MapObject)tree.getViewer().getMapMarkerList().get(i);
            if (mapobject instanceof TimestampSupporter && ((TimestampSupporter)mapobject).getTimestamp().compareTo(cutoff) < 0) {
                tree.getViewer().getMapMarkerList().remove(i);
                ++pruned;
                continue;
            }
            ++i;
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("Markers pruned: " + pruned);
        }
        i = 0;
        pruned = 0;
        while (i < tree.getViewer().getMapRectangleList().size()) {
            mapobject = (MapObject)tree.getViewer().getMapRectangleList().get(i);
            if (mapobject instanceof TimestampSupporter && ((TimestampSupporter)mapobject).getTimestamp().compareTo(cutoff) < 0) {
                tree.getViewer().getMapRectangleList().remove(i);
                continue;
            }
            ++i;
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("Rectangles pruned: " + pruned);
        }
        i = 0;
        pruned = 0;
        while (i < tree.getViewer().getMapPolygonList().size()) {
            mapobject = (MapObject)tree.getViewer().getMapPolygonList().get(i);
            if (mapobject instanceof TimestampSupporter && ((TimestampSupporter)mapobject).getTimestamp().compareTo(cutoff) < 0) {
                tree.getViewer().getMapPolygonList().remove(i);
                continue;
            }
            ++i;
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("Polygons pruned: " + pruned);
        }
    }
}

