/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.rowfinder.AbstractRowFinder;
import adams.data.spreadsheet.rowfinder.NullFinder;
import adams.data.spreadsheet.rowfinder.RowFinder;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractSpreadSheetTransformer;

public class SpreadSheetRowFilter
extends AbstractSpreadSheetTransformer {
    private static final long serialVersionUID = 3754073511732133649L;
    protected RowFinder m_Finder;

    public String globalInfo() {
        return "Filters spreadsheets using the specified row finder.\nThe output contains all the rows that the specified finder selected.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("finder", "finder", (Object)new NullFinder());
    }

    public void setFinder(RowFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public RowFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The row finder to use for identifying rows for the output.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"finder", (Object)this.m_Finder);
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet input = (SpreadSheet)this.m_InputToken.getPayload();
        SpreadSheet output = AbstractRowFinder.filter(input, this.m_Finder);
        this.m_OutputToken = new Token((Object)output);
        return result;
    }
}

