/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.plotgenerator;

import adams.core.QuickInfoHelper;
import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.flow.container.SequencePlotterContainer;
import adams.flow.transformer.plotgenerator.AbstractPlotGenerator;
import java.util.ArrayList;
import java.util.List;

public class AndrewsCurvesGenerator
extends AbstractPlotGenerator
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 5687113015681744506L;
    protected int m_NumPoints;
    protected String m_Prefix;
    protected SpreadSheetColumnRange m_PlotColumns;
    protected SpreadSheetColumnRange m_MetaDataColumns;

    public String globalInfo() {
        return "Generates plot containers from row-based data for Andrews Curves.\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.YEAR, "2003");
        result.setValue(TechnicalInformation.Field.AUTHOR, "C\u00e9sar Ignacio Garc\u00eda Osorio and Colin Fyfe");
        result.setValue(TechnicalInformation.Field.TITLE, "AN EXTENSION OF ANDREWS CURVES FOR DATA ANALYSIS");
        result.setValue(TechnicalInformation.Field.HTTP, "http://cib.uco.es/documents/Garcia03SIGEF.pdf");
        return result;
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-points", "numPoints", (Object)100, (Number)1, null);
        this.m_OptionManager.add("prefix", "prefix", (Object)"");
        this.m_OptionManager.add("columns", "plotColumns", (Object)"");
        this.m_OptionManager.add("meta-data-columns", "metaDataColumns", (Object)"");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_PlotColumns = new SpreadSheetColumnRange();
        this.m_MetaDataColumns = new SpreadSheetColumnRange();
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"plotColumns", (Object)(this.getPlotColumns().isEmpty() ? "-none-" : this.getPlotColumns()), (String)", cols: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"prefix", (Object)(this.getPrefix().isEmpty() ? "-none-" : this.getPrefix()), (String)", prefix: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"metaDataColumns", (Object)(this.getMetaDataColumns().isEmpty() ? "-none-" : this.getMetaDataColumns()), (String)", meta-data: ");
        return result;
    }

    public void setNumPoints(int value) {
        this.m_NumPoints = value;
        this.reset();
    }

    public int getNumPoints() {
        return this.m_NumPoints;
    }

    public String numPointsTipText() {
        return "The number of points to generate for the curves.";
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The prefix to use for the plot names.";
    }

    public void setPlotColumns(String value) {
        this.m_PlotColumns.setRange(value);
        this.reset();
    }

    public String getPlotColumns() {
        return this.m_PlotColumns.getRange();
    }

    public String plotColumnsTipText() {
        return "The range of columns to include in the curves; " + this.m_PlotColumns.getExample();
    }

    public void setMetaDataColumns(String value) {
        this.m_MetaDataColumns.setRange(value);
        this.reset();
    }

    public String getMetaDataColumns() {
        return this.m_MetaDataColumns.getRange();
    }

    public String metaDataColumnsTipText() {
        return "The range of columns to add as meta-data in the plot; " + this.m_MetaDataColumns.getExample();
    }

    @Override
    protected void check(SpreadSheet sheet) {
        super.check(sheet);
        this.m_PlotColumns.setSpreadSheet(sheet);
        if (this.m_PlotColumns.getIntIndices().length == 0) {
            throw new IllegalStateException("No plot columns defined/available?");
        }
        this.m_MetaDataColumns.setSpreadSheet(sheet);
    }

    @Override
    protected List<SequencePlotterContainer> doGenerate(SpreadSheet sheet) {
        ArrayList<SequencePlotterContainer> result = new ArrayList<SequencePlotterContainer>();
        int r = 0;
        int[] cols = this.m_PlotColumns.getIntIndices();
        int[] metaCols = this.m_MetaDataColumns.getIntIndices();
        for (Row row : sheet.rows()) {
            ++r;
            for (int i = 0; i < this.m_NumPoints; ++i) {
                double t = -Math.PI + Math.PI * 2 / (double)this.m_NumPoints * (double)i;
                double y = row.getCell(cols[0]).toDouble() / Math.sqrt(2.0);
                for (int n = 1; n < cols.length; ++n) {
                    if ((n + 1) % 2 == 0) {
                        y += row.getCell(cols[n]).toDouble() * Math.sin(t * Math.ceil(n / 2));
                        continue;
                    }
                    y += row.getCell(cols[n]).toDouble() * Math.cos(t * Math.ceil(n / 2));
                }
                SequencePlotterContainer cont = new SequencePlotterContainer(this.getActualPlotName(row, this.m_Prefix + r), (Comparable)Double.valueOf(t), (Comparable)Double.valueOf(y));
                for (int m = 0; m < metaCols.length; ++m) {
                    cont.addMetaData(sheet.getColumnName(metaCols[m]), this.getCellObject(row, metaCols[m], null));
                }
                result.add(cont);
            }
        }
        return result;
    }
}

