/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer;

import adams.core.ClassLister;
import adams.core.ShallowCopySupporter;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.tools.spreadsheetviewer.SpreadSheetPanel;
import java.util.Hashtable;

public abstract class AbstractDataPlugin
extends AbstractOptionHandler
implements ShallowCopySupporter<AbstractDataPlugin> {
    private static final long serialVersionUID = -5749133065210106163L;
    protected static Hashtable<Class, Object> m_LastSetup = new Hashtable();
    protected SpreadSheetPanel m_CurrentPanel;
    protected boolean m_CanceledByUser;

    public abstract String getMenuText();

    public abstract String getMenuIcon();

    public abstract boolean isInPlace();

    public void setCurrentPanel(SpreadSheetPanel value) {
        this.m_CurrentPanel = value;
    }

    public SpreadSheetPanel getCurrentPanel() {
        return this.m_CurrentPanel;
    }

    protected boolean hasLastSetup() {
        return m_LastSetup.containsKey(((Object)((Object)this)).getClass());
    }

    protected Object getLastSetup() {
        return m_LastSetup.get(((Object)((Object)this)).getClass());
    }

    protected void setLastSetup(Object setup) {
        m_LastSetup.put(((Object)((Object)this)).getClass(), setup);
    }

    public boolean getCanceledByUser() {
        return this.m_CanceledByUser;
    }

    public boolean canProcess(SpreadSheetPanel panel) {
        return panel != null && panel.getSheet() != null;
    }

    protected String check(SpreadSheet sheet) {
        if (sheet == null) {
            return "No spreadsheet supplied!";
        }
        return null;
    }

    protected abstract SpreadSheet doProcess(SpreadSheet var1);

    public SpreadSheet process(SpreadSheet sheet) {
        String msg = this.check(sheet);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        return this.doProcess(sheet);
    }

    public AbstractDataPlugin shallowCopy() {
        return this.shallowCopy(false);
    }

    public AbstractDataPlugin shallowCopy(boolean expand) {
        return (AbstractDataPlugin)OptionUtils.shallowCopy((OptionHandler)this, (boolean)expand);
    }

    public static String[] getPlugins() {
        return ClassLister.getSingleton().getClassnames(AbstractDataPlugin.class);
    }
}

