/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer.chart;

import adams.data.spreadsheet.SpreadSheet;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.SequencePlotter;
import adams.flow.sink.sequenceplotter.MouseClickAction;
import adams.flow.sink.sequenceplotter.ViewDataClickAction;
import adams.flow.transformer.SpreadSheetPlotGenerator;
import adams.gui.tools.spreadsheetviewer.chart.AbstractXYChartGenerator;
import adams.gui.visualization.sequence.LinePaintlet;
import adams.gui.visualization.sequence.XYSequencePaintlet;

public class LinePlot
extends AbstractXYChartGenerator {
    private static final long serialVersionUID = -2088311829009151566L;

    public String globalInfo() {
        return "Generates a line plot by plotting the X column against one or more Y columns.";
    }

    @Override
    protected void addChartGeneration(Flow flow, String name, SpreadSheet sheet) {
        super.addChartGeneration(flow, name, sheet);
        SpreadSheetPlotGenerator pg = this.configureGenerator(sheet);
        flow.add((AbstractActor)pg);
        SequencePlotter plotter = new SequencePlotter();
        if (name != null) {
            plotter.setName(name);
        } else {
            plotter.setName("Line plot");
        }
        plotter.setTitle(plotter.getName());
        this.configureSequencePlotter(sheet, plotter);
        LinePaintlet paintlet = new LinePaintlet();
        plotter.setPaintlet((XYSequencePaintlet)paintlet);
        ViewDataClickAction action = new ViewDataClickAction();
        action.setHitDetector(paintlet.getHitDetector());
        plotter.setMouseClickAction((MouseClickAction)action);
        flow.add((AbstractActor)plotter);
    }
}

