/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.Utils;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import java.util.Arrays;
import java.util.HashSet;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPInteger;
import org.rosuda.REngine.REXPList;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.REXPVector;
import org.rosuda.REngine.RList;

public class RDataHelper {
    public static REXP spreadsheetToDataframe(SpreadSheet sheet) throws REXPMismatchException {
        RList atts = new RList(sheet.getColumnCount(), true);
        block4: for (int col = 0; col < sheet.getColumnCount(); ++col) {
            Cell.ContentType type = sheet.getContentType(col);
            if (type == null) {
                type = sheet.isNumeric(col) ? Cell.ContentType.DOUBLE : Cell.ContentType.STRING;
            }
            switch (type) {
                case LONG: {
                    Cell cell;
                    int row;
                    int[] i = new int[sheet.getRowCount()];
                    for (row = 0; row < sheet.getRowCount(); ++row) {
                        cell = sheet.getCell(row, col);
                        i[row] = cell == null || cell.isMissing() ? Integer.MIN_VALUE : cell.toLong().intValue();
                    }
                    atts.put((Object)sheet.getHeaderRow().getCell(col).getContent(), (Object)new REXPInteger(i));
                    continue block4;
                }
                case DOUBLE: {
                    Cell cell;
                    int row;
                    double[] d = new double[sheet.getRowCount()];
                    for (row = 0; row < sheet.getRowCount(); ++row) {
                        cell = sheet.getCell(row, col);
                        d[row] = cell == null || cell.isMissing() ? REXPDouble.NA : cell.toDouble();
                    }
                    atts.put((Object)sheet.getHeaderRow().getCell(col).getContent(), (Object)new REXPDouble(d));
                    continue block4;
                }
                default: {
                    Cell cell;
                    int row;
                    String[] s = new String[sheet.getRowCount()];
                    for (row = 0; row < sheet.getRowCount(); ++row) {
                        cell = sheet.getCell(row, col);
                        s[row] = cell == null || cell.isMissing() ? "" : cell.getContent();
                    }
                    atts.put((Object)sheet.getHeaderRow().getCell(col).getContent(), (Object)new REXPString(s));
                }
            }
        }
        return REXP.createDataFrame((RList)atts);
    }

    public static SpreadSheet dataframeToSpreadsheet(REXP dframe) throws REXPMismatchException {
        return RDataHelper.dataframeToSpreadsheet(dframe, null);
    }

    public static SpreadSheet dataframeToSpreadsheet(REXP dframe, String[] columns) throws REXPMismatchException {
        String colName;
        SpreadSheet result = new SpreadSheet();
        RList list = dframe.asList();
        HashSet<String> cols = columns == null ? null : new HashSet<String>(Arrays.asList(columns));
        HeaderRow row = result.getHeaderRow();
        for (Object key : list.keySet()) {
            colName = key.toString();
            if (cols != null && !cols.contains(colName)) continue;
            row.addCell(colName).setContent(colName);
        }
        for (Object key : list.keySet()) {
            int r;
            colName = key.toString();
            if (cols != null && !cols.contains(colName)) continue;
            REXPVector dcol = (REXPVector)list.get(key);
            int c = result.getHeaderRow().indexOf(colName);
            while (result.getRowCount() < dcol.length()) {
                result.addRow();
            }
            if (dcol.isInteger()) {
                int[] i = dcol.asIntegers();
                for (r = 0; r < i.length; ++r) {
                    result.getCell(r, c).setContent(Integer.valueOf(i[r]));
                }
                continue;
            }
            if (dcol.isNumeric()) {
                double[] d = dcol.asDoubles();
                for (r = 0; r < d.length; ++r) {
                    result.getCell(r, c).setContent(Double.valueOf(d[r]));
                }
                continue;
            }
            if (!dcol.isList()) continue;
            RList elements = dcol.asList();
            for (r = 0; r < elements.size(); ++r) {
                result.getCell(r, c).setContent(RDataHelper.objectToString(elements.get(r)));
            }
        }
        return result;
    }

    protected static String listToString(RList list) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                result.append(",");
            }
            if (list.get(i) instanceof RList) {
                result.append("{");
                result.append(RDataHelper.objectToString((RList)list.get(i)));
                result.append("}");
                continue;
            }
            result.append("" + RDataHelper.objectToString(list.get(i)));
        }
        return result.toString();
    }

    public static String objectToString(Object obj) {
        if (obj instanceof RList) {
            return RDataHelper.listToString((RList)obj);
        }
        if (obj instanceof REXPInteger) {
            return Utils.arrayToString((Object)((REXPInteger)obj).asIntegers());
        }
        if (obj instanceof REXPDouble) {
            return Utils.arrayToString((Object)((REXPDouble)obj).asDoubles());
        }
        if (obj instanceof REXPString) {
            return Utils.arrayToString((Object)((REXPString)obj).asStrings());
        }
        if (obj instanceof REXPList) {
            return RDataHelper.listToString(((REXPList)obj).asList());
        }
        return obj.toString();
    }
}

