/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.lang.reflect.Array;

public class CircularQueue<T> {
    public T[] data;
    public int start;
    public int size;
    Class<T> type;

    public CircularQueue(Class<T> type) {
        this(type, 10);
    }

    public CircularQueue(Class<T> type, int maxSize) {
        this.type = type;
        this.data = (Object[])Array.newInstance(type, maxSize);
    }

    public void reset() {
        this.size = 0;
        this.start = 0;
    }

    public T popHead() {
        T r = this.data[this.start];
        this.removeHead();
        return r;
    }

    public T popTail() {
        T r = this.tail();
        this.removeTail();
        return r;
    }

    public T head() {
        return this.data[this.start];
    }

    public T tail() {
        return this.data[(this.start + this.size - 1) % this.data.length];
    }

    public void removeHead() {
        this.start = (this.start + 1) % this.data.length;
        --this.size;
    }

    public void removeTail() {
        --this.size;
    }

    public T get(int index) {
        return this.data[(this.start + index) % this.data.length];
    }

    public T grow() {
        if (this.size >= this.data.length) {
            T a = this.createInstance();
            this.add(a);
            return a;
        }
        T a = this.data[(this.start + this.size) % this.data.length];
        if (a == null) {
            this.data[(this.start + this.size) % this.data.length] = a = this.createInstance();
        }
        ++this.size;
        return a;
    }

    public T growW() {
        T a;
        if (this.size >= this.data.length) {
            a = this.data[this.start];
            if (a == null) {
                this.data[this.start] = a = this.createInstance();
            }
            this.start = (this.start + 1) % this.data.length;
        } else {
            a = this.data[(this.start + this.size) % this.data.length];
            if (a == null) {
                this.data[(this.start + this.size) % this.data.length] = a = this.createInstance();
            }
            ++this.size;
        }
        return a;
    }

    public void add(T value) {
        if (this.size >= this.data.length) {
            this.growInnerArray();
        }
        this.data[(this.start + this.size) % this.data.length] = value;
        ++this.size;
    }

    private void growInnerArray() {
        Object[] a = (Object[])Array.newInstance(this.type, this.nextDataSize());
        System.arraycopy(this.data, this.start, a, 0, this.data.length - this.start);
        System.arraycopy(this.data, 0, a, this.data.length - this.start, this.start);
        this.start = 0;
        this.data = a;
    }

    public void addW(T value) {
        if (this.size >= this.data.length) {
            this.data[this.start] = value;
            this.start = (this.start + 1) % this.data.length;
        } else {
            this.data[(this.start + this.size) % this.data.length] = value;
            ++this.size;
        }
    }

    private int nextDataSize() {
        if (this.data.length < 1000) {
            return this.data.length * 2;
        }
        if (this.data.length < 10000) {
            return this.data.length * 3 / 2;
        }
        return this.data.length * 6 / 5;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isFull() {
        return this.size == this.data.length;
    }

    protected T createInstance() {
        try {
            return this.type.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

