/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.statistics;

public class SampleStatistics {
    private int n = 0;
    private double sum = 0.0;
    private double sumSqr = 0.0;
    private double min = Double.POSITIVE_INFINITY;
    private double max = Double.NEGATIVE_INFINITY;

    public void update(double d) {
        ++this.n;
        this.sum += d;
        this.sumSqr += d * d;
        this.min = Math.min(d, this.min);
        this.max = Math.max(d, this.max);
    }

    public int getCount() {
        return this.n;
    }

    public double getMean() {
        return this.sum / (double)this.n;
    }

    public double getVariance() {
        return (this.sumSqr - this.sum * this.sum / (double)this.n) / (double)(this.n - 1);
    }

    public double getMinimum() {
        return this.min;
    }

    public double getMaximum() {
        return this.max;
    }
}

