/*
 * Decompiled with CFR 0.152.
 */
package JSci.physics.relativity;

import JSci.GlobalSettings;
import JSci.maths.DimensionException;
import JSci.maths.vectors.Double3Vector;
import JSci.physics.relativity.Rank2Tensor;
import JSci.physics.relativity.Rank3Tensor;
import JSci.physics.relativity.Rank4Tensor;
import JSci.physics.relativity.Tensor;

public class Rank1Tensor
extends Tensor {
    protected double[] rank1 = new double[4];

    public Rank1Tensor() {
    }

    public Rank1Tensor(double d, Double3Vector double3Vector) {
        this();
        this.rank1[0] = d;
        this.rank1[1] = double3Vector.getComponent(0);
        this.rank1[2] = double3Vector.getComponent(1);
        this.rank1[3] = double3Vector.getComponent(2);
    }

    public Rank1Tensor(double d, double d2, double d3, double d4) {
        this();
        this.rank1[0] = d;
        this.rank1[1] = d2;
        this.rank1[2] = d3;
        this.rank1[3] = d4;
    }

    public boolean equals(Object object) {
        if (object instanceof Rank1Tensor) {
            Rank1Tensor rank1Tensor = (Rank1Tensor)object;
            return Math.abs(this.rank1[0] - rank1Tensor.rank1[0]) <= GlobalSettings.ZERO_TOL && Math.abs(this.rank1[1] - rank1Tensor.rank1[1]) <= GlobalSettings.ZERO_TOL && Math.abs(this.rank1[2] - rank1Tensor.rank1[2]) <= GlobalSettings.ZERO_TOL && Math.abs(this.rank1[3] - rank1Tensor.rank1[3]) <= GlobalSettings.ZERO_TOL;
        }
        return false;
    }

    public String toString() {
        return new String(this.rank1[0] + "," + this.rank1[1] + "," + this.rank1[2] + "," + this.rank1[3]);
    }

    public int hashCode() {
        return (int)Math.exp(this.norm());
    }

    public double getComponent(int n) {
        if (n >= 0 && n < 4) {
            return this.rank1[n];
        }
        throw new DimensionException("Invalid component.");
    }

    public void setComponent(int n, double d) {
        if (n < 0 || n >= 4) {
            throw new DimensionException("Invalid component.");
        }
        this.rank1[n] = d;
    }

    public double norm() {
        return Math.sqrt(this.rank1[0] * this.rank1[0] - this.rank1[1] * this.rank1[1] - this.rank1[2] * this.rank1[2] - this.rank1[3] * this.rank1[3]);
    }

    public Rank1Tensor add(Rank1Tensor rank1Tensor) {
        Rank1Tensor rank1Tensor2 = new Rank1Tensor();
        rank1Tensor2.rank1[0] = this.rank1[0] + rank1Tensor.rank1[0];
        rank1Tensor2.rank1[1] = this.rank1[1] + rank1Tensor.rank1[1];
        rank1Tensor2.rank1[2] = this.rank1[2] + rank1Tensor.rank1[2];
        rank1Tensor2.rank1[3] = this.rank1[3] + rank1Tensor.rank1[3];
        return rank1Tensor2;
    }

    public Rank1Tensor subtract(Rank1Tensor rank1Tensor) {
        Rank1Tensor rank1Tensor2 = new Rank1Tensor();
        rank1Tensor2.rank1[0] = this.rank1[0] - rank1Tensor.rank1[0];
        rank1Tensor2.rank1[1] = this.rank1[1] - rank1Tensor.rank1[1];
        rank1Tensor2.rank1[2] = this.rank1[2] - rank1Tensor.rank1[2];
        rank1Tensor2.rank1[3] = this.rank1[3] - rank1Tensor.rank1[3];
        return rank1Tensor2;
    }

    public Rank2Tensor tensorProduct(Rank1Tensor rank1Tensor) {
        Rank2Tensor rank2Tensor = new Rank2Tensor();
        for (int i = 0; i < 4; ++i) {
            rank2Tensor.setComponent(i, 0, this.rank1[i] * rank1Tensor.rank1[0]);
            rank2Tensor.setComponent(i, 1, this.rank1[i] * rank1Tensor.rank1[1]);
            rank2Tensor.setComponent(i, 2, this.rank1[i] * rank1Tensor.rank1[2]);
            rank2Tensor.setComponent(i, 3, this.rank1[i] * rank1Tensor.rank1[3]);
        }
        return rank2Tensor;
    }

    public Rank3Tensor tensorProduct(Rank2Tensor rank2Tensor) {
        Rank3Tensor rank3Tensor = new Rank3Tensor();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                rank3Tensor.setComponent(i, j, 0, this.rank1[i] * rank2Tensor.getComponent(j, 0));
                rank3Tensor.setComponent(i, j, 1, this.rank1[i] * rank2Tensor.getComponent(j, 1));
                rank3Tensor.setComponent(i, j, 2, this.rank1[i] * rank2Tensor.getComponent(j, 2));
                rank3Tensor.setComponent(i, j, 3, this.rank1[i] * rank2Tensor.getComponent(j, 3));
            }
        }
        return rank3Tensor;
    }

    public Rank4Tensor tensorProduct(Rank3Tensor rank3Tensor) {
        Rank4Tensor rank4Tensor = new Rank4Tensor();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    rank4Tensor.setComponent(i, j, k, 0, this.rank1[i] * rank3Tensor.getComponent(j, k, 0));
                    rank4Tensor.setComponent(i, j, k, 1, this.rank1[i] * rank3Tensor.getComponent(j, k, 1));
                    rank4Tensor.setComponent(i, j, k, 2, this.rank1[i] * rank3Tensor.getComponent(j, k, 2));
                    rank4Tensor.setComponent(i, j, k, 3, this.rank1[i] * rank3Tensor.getComponent(j, k, 3));
                }
            }
        }
        return rank4Tensor;
    }
}

