/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.io.FlowFile;
import adams.core.option.OptionHandler;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorUtils;
import adams.flow.core.ErrorHandler;
import java.util.ArrayList;

public abstract class AbstractIncludeExternalActor
extends AbstractActor {
    private static final long serialVersionUID = -7860206690560690212L;
    protected FlowFile m_ActorFile;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("file", "actorFile", (Object)new FlowFile("."));
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"actorFile", (Object)this.m_ActorFile);
    }

    public void setActorFile(FlowFile value) {
        this.m_ActorFile = value;
        this.reset();
    }

    public FlowFile getActorFile() {
        return this.m_ActorFile;
    }

    public String actorFileTipText() {
        return "The file containing the external actor.";
    }

    protected abstract String checkExternalActor(AbstractActor var1);

    public String setUpExternalActor() {
        String result = null;
        if (!this.m_ActorFile.isFile()) {
            result = "'" + this.m_ActorFile.getAbsolutePath() + "' does not point to a file!";
        } else {
            ArrayList errors = new ArrayList();
            if (this.isLoggingEnabled()) {
                this.getLogger().fine("Attempting to load actor file: " + this.m_ActorFile);
            }
            AbstractActor externalActor = ActorUtils.read((String)this.m_ActorFile.getAbsolutePath(), errors);
            if (!errors.isEmpty()) {
                result = "Error loading external actor '" + this.m_ActorFile.getAbsolutePath() + "':\n" + Utils.flatten(errors, (String)"\n");
            } else if (externalActor == null) {
                result = "Error loading external actor '" + this.m_ActorFile.getAbsolutePath() + "'!";
            } else {
                result = this.checkExternalActor(externalActor);
                if (result == null) {
                    if (externalActor.getName().equals(externalActor.getDefaultName())) {
                        externalActor.setName(this.getName());
                    }
                    externalActor.setVariables(this.getVariables());
                    ((ActorHandler)this.getParent()).set(this.index(), externalActor);
                    result = externalActor.setUp();
                    if (this.getErrorHandler() != this) {
                        ActorUtils.updateErrorHandler((Actor)externalActor, (ErrorHandler)this.getErrorHandler(), (boolean)this.isLoggingEnabled());
                    }
                    if (result == null) {
                        externalActor.getOptionManager().updateVariableValues(true);
                    }
                    this.setParent(null);
                    this.cleanUp();
                }
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().fine("Actor file load/setUp result: " + result);
            }
        }
        return result;
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            result = this.setUpExternalActor();
        }
        return result;
    }

    protected String doExecute() {
        return null;
    }
}

