/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsLookAndFeel;
import com.pagosoft.plaf.PgsUtils;
import com.pagosoft.plaf.PlafOptions;
import com.pagosoft.swing.ColorUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.plaf.UIResource;

public class PgsIconFactory {
    private static Icon emptyIcon;
    private static Icon checkBoxIcon;
    private static Icon checkBoxMenuItemIcon;
    private static Icon radioButtonIcon;
    private static Icon radioMenuItemIcon;

    public static Icon getEmptyIcon() {
        if (emptyIcon == null) {
            emptyIcon = new EmptyIcon(PlafOptions.getDefaultMenuItemIconSize());
        }
        return emptyIcon;
    }

    protected static void drawCheck(Component c, Graphics g, int x, int y) {
        g.translate(x, y);
        g.drawLine(3, 5, 3, 5);
        g.fillRect(3, 6, 2, 2);
        g.drawLine(4, 8, 9, 3);
        g.drawLine(5, 8, 9, 4);
        g.drawLine(5, 9, 9, 5);
        g.translate(-x, -y);
    }

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getCheckBoxMenuItemIcon() {
        if (checkBoxMenuItemIcon == null) {
            checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
        }
        return checkBoxMenuItemIcon;
    }

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getRadioButtonMenuItemIcon() {
        if (radioMenuItemIcon == null) {
            radioMenuItemIcon = new RadioButtonIcon();
        }
        return radioMenuItemIcon;
    }

    private static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private RadioButtonIcon() {
        }

        protected int getControlSize() {
            return 13;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            AbstractButton cb = (AbstractButton)c;
            ButtonModel model = cb.getModel();
            int controlSize = this.getControlSize();
            boolean drawDot = model.isSelected();
            Graphics2D gfx = (Graphics2D)g;
            gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (model.isEnabled()) {
                gfx.setColor(PgsLookAndFeel.getControlHighlight());
                gfx.fillOval(x, y, controlSize, controlSize);
                if (model.isRollover()) {
                    gfx.setColor(PgsLookAndFeel.getGlow());
                    gfx.drawOval(x + 1, y + 1, controlSize - 3, controlSize - 3);
                }
                gfx.setColor(PgsLookAndFeel.getControlDarkShadow());
                gfx.drawOval(x, y, controlSize - 1, controlSize - 1);
                if (model.isPressed() && model.isArmed()) {
                    gfx.setColor(PgsLookAndFeel.getControlShadow());
                    gfx.fillOval(x + 1, y + 1, controlSize - 2, controlSize - 2);
                }
                gfx.setColor(PgsLookAndFeel.getControlInfo());
            } else {
                gfx.setColor(PgsLookAndFeel.getControlShadow());
                gfx.drawOval(x, y, controlSize - 1, controlSize - 1);
            }
            if (drawDot) {
                if (model.isEnabled()) {
                    gfx.setColor(PgsLookAndFeel.getPrimaryControlDarkShadow());
                } else {
                    gfx.setColor(model.isEnabled() ? PgsLookAndFeel.getPrimaryControlDarkShadow() : PgsLookAndFeel.getControlShadow());
                }
                gfx.fillOval(x + 3, y + 3, controlSize - 6, controlSize - 6);
            }
            gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }

        public int getIconWidth() {
            return this.getControlSize();
        }

        public int getIconHeight() {
            return this.getControlSize();
        }
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private CheckBoxMenuItemIcon() {
        }

        protected int getControlSize() {
            return 13;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JMenuItem cb = (JMenuItem)c;
            ButtonModel model = cb.getModel();
            int controlSize = this.getControlSize();
            boolean drawCheck = model.isSelected();
            if (model.isEnabled()) {
                g.setColor(PgsLookAndFeel.getControlHighlight());
                g.fillRect(x, y, controlSize, controlSize);
                if (model.isRollover()) {
                    g.setColor(PgsLookAndFeel.getPrimaryControl());
                    g.drawRect(x + 1, y + 1, controlSize - 3, controlSize - 3);
                }
                g.setColor(PgsLookAndFeel.getControlDarkShadow());
                g.drawRect(x, y, controlSize - 1, controlSize - 1);
                if (model.isPressed() && model.isArmed()) {
                    g.setColor(PgsLookAndFeel.getControlShadow());
                    g.fillRect(x + 1, y + 1, controlSize - 2, controlSize - 2);
                }
                g.setColor(PgsLookAndFeel.getControlInfo());
            } else {
                g.setColor(PgsLookAndFeel.getControlShadow());
                g.drawRect(x, y, controlSize - 1, controlSize - 1);
            }
            if (drawCheck) {
                g.setColor(model.isEnabled() ? PgsLookAndFeel.getPrimaryControlDarkShadow() : PgsLookAndFeel.getControlShadow());
                PgsIconFactory.drawCheck(c, g, x, y);
            }
        }

        public int getIconWidth() {
            return this.getControlSize();
        }

        public int getIconHeight() {
            return this.getControlSize();
        }
    }

    private static class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private CheckBoxIcon() {
        }

        protected int getControlSize() {
            return 13;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JCheckBox cb = (JCheckBox)c;
            ButtonModel model = cb.getModel();
            int controlSize = this.getControlSize();
            boolean drawCheck = model.isSelected();
            if (model.isEnabled()) {
                g.setColor(PgsLookAndFeel.getControlHighlight());
                g.fillRect(x, y, controlSize, controlSize);
                PgsUtils.drawGradient(g, x, y, controlSize, controlSize, ColorUtils.getTranslucentColor(PgsLookAndFeel.getControlShadow(), 0), ColorUtils.getTranslucentColor(PgsLookAndFeel.getControlShadow(), 50));
                if (model.isRollover()) {
                    g.setColor(PgsLookAndFeel.getGlow());
                    g.drawRect(x + 1, y + 1, controlSize - 3, controlSize - 3);
                }
                g.setColor(PgsLookAndFeel.getControlDarkShadow());
                g.drawRect(x, y, controlSize - 1, controlSize - 1);
                if (model.isPressed() && model.isArmed()) {
                    g.setColor(PgsLookAndFeel.getControlShadow());
                    g.fillRect(x + 1, y + 1, controlSize - 2, controlSize - 2);
                }
                g.setColor(PgsLookAndFeel.getControlInfo());
            } else {
                g.setColor(PgsLookAndFeel.getControlShadow());
                g.drawRect(x, y, controlSize - 1, controlSize - 1);
            }
            if (drawCheck) {
                g.setColor(model.isEnabled() ? PgsLookAndFeel.getPrimaryControlDarkShadow() : PgsLookAndFeel.getControlShadow());
                PgsIconFactory.drawCheck(c, g, x, y);
            }
        }

        public int getIconWidth() {
            return this.getControlSize();
        }

        public int getIconHeight() {
            return this.getControlSize();
        }
    }

    private static class EmptyIcon
    implements Icon,
    UIResource,
    Serializable {
        private Dimension size;

        public EmptyIcon(Dimension dim) {
            this.size = dim;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        public int getIconWidth() {
            return this.size.width;
        }

        public int getIconHeight() {
            return this.size.height;
        }
    }
}

