/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsUtils;
import com.pagosoft.plaf.PlafOptions;
import com.pagosoft.plaf.ToolBarButtonUI;
import com.pagosoft.plaf.ToolBarToggleButtonUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalToolBarUI;

public class PgsToolBarUI
extends MetalToolBarUI {
    public static ComponentUI createUI(JComponent c) {
        return new PgsToolBarUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.putClientProperty("gradientStart", UIManager.get("ToolBar.gradientStart"));
        c.putClientProperty("gradientEnd", UIManager.get("ToolBar.gradientEnd"));
        int limit = c.getComponentCount();
        for (int i = 0; i < limit; ++i) {
            this.setToolBarUI((JComponent)c.getComponent(i));
        }
    }

    public void paint(Graphics g, JComponent b) {
        if (b.isOpaque()) {
            if (PlafOptions.getStyle("ToolBar") == 0) {
                g.setColor(b.getBackground());
                g.drawRect(0, 0, b.getWidth(), b.getHeight());
            } else {
                int orient = ((JToolBar)b).getOrientation();
                if (orient == 0) {
                    PgsUtils.drawGradient(g, b);
                } else {
                    PgsUtils.drawGradient(g, 0, 0, b.getWidth(), b.getHeight(), (Color)b.getClientProperty("gradientStart"), (Color)b.getClientProperty("gradientEnd"));
                }
            }
        }
        super.paint(g, b);
    }

    protected ContainerListener createContainerListener() {
        return new ToolBarContListener();
    }

    protected void setToolBarUI(JComponent c) {
        if (c instanceof JButton) {
            ((AbstractButton)c).setUI((ToolBarButtonUI)ToolBarButtonUI.createUI(c));
        } else if (c instanceof JToggleButton) {
            ((AbstractButton)c).setUI((ToolBarToggleButtonUI)ToolBarToggleButtonUI.createUI(c));
        }
    }

    protected class ToolBarContListener
    implements ContainerListener {
        protected ToolBarContListener() {
        }

        public void componentAdded(ContainerEvent e) {
            PgsToolBarUI.this.setToolBarUI((JComponent)e.getChild());
        }

        public void componentRemoved(ContainerEvent e) {
            JComponent c = (JComponent)e.getChild();
            if (c instanceof JButton || c instanceof JToggleButton) {
                ((AbstractButton)c).setUI((ButtonUI)UIManager.getUI(c));
            }
        }
    }
}

