/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsLookAndFeel;
import com.pagosoft.plaf.PlafOptions;
import com.pagosoft.swing.ColorUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.RGBImageFilter;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.UIManager;
import javax.swing.plaf.IconUIResource;
import javax.swing.text.View;
import javax.swing.text.html.HTMLDocument;

public class PgsUtils {
    private static HashMap gpCache;
    public static Stroke borderStroke;
    public static Stroke rolloverBorderStroke;
    private static Map hintsMap;
    private static Map oldHintsMap;

    public static String createHtmlToolTip(String text) {
        Font defaultFont = UIManager.getFont("Button.font");
        return new StringBuffer().append("<html><head><style type='text/css'>").append("body {padding: 5px}").append("h1 {font-size: ").append(defaultFont.getSize()).append("pt; margin: 0 0 2px 0; padding:0; color: ").append(ColorUtils.toString(PgsLookAndFeel.getPrimaryControlDarkShadow())).append("}").append("p {margin-left: 15px}").append("</style></head><body>").append(text).append("</body>").toString();
    }

    public static boolean isFlat(JComponent b) {
        return Boolean.TRUE.equals(b.getClientProperty("pgs.isFlat"));
    }

    public static boolean isFlat(String id) {
        return Boolean.TRUE.equals(UIManager.get(id + ".isFlat"));
    }

    public static void paintSprite(Graphics g, int x, int y, int[][] sprite, Color[] colors) {
        for (int i = 0; i < sprite.length; ++i) {
            for (int j = 0; j < sprite[i].length; ++j) {
                if (sprite[i][j] == 0) continue;
                g.setColor(colors[sprite[i][j] - 1]);
                g.drawLine(x + i, y + j, x + i, y + j);
            }
        }
    }

    public static GradientPaint getGradientPaint(int x, int y, int width, int height, Color from, Color to) {
        long bits;
        int hash;
        Integer key;
        GradientPaint result;
        if (gpCache == null) {
            gpCache = new HashMap(20);
        }
        if ((result = (GradientPaint)gpCache.get(key = new Integer(hash = ((int)(bits = Double.doubleToLongBits(x) + Double.doubleToLongBits(y) * 37L + Double.doubleToLongBits(width) * 43L + Double.doubleToLongBits(height) * 47L) ^ (int)(bits >> 32) ^ from.hashCode() ^ to.hashCode() * 17) * 31))) == null) {
            result = new GradientPaint(0.0f, 0.0f, from, 0.0f, height, to, true);
            if (gpCache.size() > 40) {
                gpCache.clear();
            }
            gpCache.put(key, result);
        }
        return result;
    }

    public static void drawGradient(Graphics g, int width, int height, Color from, Color to) {
        PgsUtils.drawGradient(g, 0, 0, width, height, from, to);
    }

    public static void drawGradient(Graphics g, int x, int y, int width, int height, Color from, Color to) {
        Graphics2D gfx = (Graphics2D)g;
        gfx.setPaint(PgsUtils.getGradientPaint(x, y, width, height, from, to));
        gfx.fill(new Rectangle(x, y, width, height));
    }

    public static void drawGradient(Graphics g, JComponent c, String prefix, int x, int y, int width, int height) {
        PgsUtils.drawGradient(g, x, y, width, height, (Color)c.getClientProperty(prefix + ".gradientStart"), (Color)c.getClientProperty(prefix + ".gradientEnd"));
    }

    public static void drawGradient(Graphics g, JComponent c, String prefix) {
        PgsUtils.drawGradient(g, c.getWidth(), c.getHeight(), (Color)c.getClientProperty(prefix + ".gradientStart"), (Color)c.getClientProperty(prefix + ".gradientEnd"));
    }

    public static void drawGradient(Graphics g, JComponent c, String prefix1, String prefix2) {
        PgsUtils.drawGradient(g, c.getWidth(), c.getHeight(), (Color)c.getClientProperty(prefix1 + ".gradientStart"), (Color)c.getClientProperty(prefix2 + ".gradientEnd"));
    }

    public static void drawGradient(Graphics g, JComponent c) {
        PgsUtils.drawGradient(g, c.getWidth(), c.getHeight(), (Color)c.getClientProperty("gradientStart"), (Color)c.getClientProperty("gradientEnd"));
    }

    public static void drawVistaBackground(Graphics g, Component b, String prefix) {
        PgsUtils.drawVistaBackground(g, 0, 0, b.getWidth(), b.getHeight(), UIManager.getColor(prefix + ".gradientStart"), UIManager.getColor(prefix + ".gradientMiddle"), UIManager.getColor(prefix + ".gradientEnd"));
    }

    public static void drawVistaBackground(Graphics g, Component b, Color start, Color mid, Color end) {
        PgsUtils.drawVistaBackground(g, 0, 0, b.getWidth(), b.getHeight(), start, mid, end);
    }

    public static void drawVistaBackground(Graphics g, int x, int y, int width, int height, Color start, Color mid, Color end) {
        g.setColor(start);
        g.fillRect(x, y, width, height / 2);
        g.setColor(end);
        g.fillRect(x, y + height / 2, width, height / 2 + 1);
        g.setColor(mid);
        g.drawLine(x, y + height / 2, width, y + height / 2);
    }

    protected static void paintMenuItemBackground(Graphics g, AbstractButton menuItem, Color bgColor, String prefix) {
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        Dimension size = menuItem.getSize();
        Insets ins = UIManager.getInsets(prefix + ".selectedBorderMargin");
        Rectangle rect = new Rectangle(ins.left, ins.top, size.width - ins.right - ins.left, size.height - ins.top - ins.bottom - 2);
        if (menuItem.isOpaque()) {
            g.setColor(menuItem.getBackground());
            g.fillRect(0, 0, size.width, size.height);
            if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                g.setColor(bgColor);
                if (PgsUtils.isFlat("MenuItem")) {
                    g.fillRect((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
                } else {
                    PgsUtils.drawGradient(g, (int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight(), UIManager.getColor(prefix + ".gradientStart"), UIManager.getColor(prefix + ".gradientEnd"));
                }
                g.setColor(UIManager.getColor(prefix + ".selectedBorderColor"));
                g.drawRect((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
            }
            g.setColor(oldColor);
        }
    }

    public static boolean isLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    public static Icon getToolBarIcon(Image i) {
        if (!PlafOptions.isToolBarIconUsed()) {
            return null;
        }
        return new IconUIResource(new ShadowedIcon(new ImageIcon(i)));
    }

    public static Icon getDisabledButtonIcon(Image image) {
        if (!PlafOptions.isDisabledIconUsed()) {
            return null;
        }
        return new IconUIResource(new ImageIcon(GrayFilter.createDisabledImage(image)));
    }

    public static void drawVerticalBumps(Graphics g, int x, int y, int height) {
        int loops = height / 6;
        for (int i = 0; i < loops; ++i) {
            g.setColor(PgsLookAndFeel.getControlShadow());
            g.fillRect(x, y + i * 6, 2, 2);
            g.fillRect(x + 3, 3 + y + i * 6, 2, 2);
            g.setColor(ColorUtils.getTranslucentColor(PgsLookAndFeel.getControl(), 180));
            g.fillRect(x + 1, 1 + y + i * 6, 2, 2);
            g.fillRect(x + 4, 4 + y + i * 6, 2, 2);
        }
    }

    public static void drawHorizontalBumps(Graphics g, int x, int y, int width) {
        int loops = width / 6;
        for (int i = 0; i < loops; ++i) {
            g.setColor(PgsLookAndFeel.getControlShadow());
            g.fillRect(x + i * 6, y, 2, 2);
            g.fillRect(3 + x + i * 6, y + 3, 2, 2);
            g.setColor(ColorUtils.getTranslucentColor(PgsLookAndFeel.getControl(), 180));
            g.fillRect(1 + x + i * 6, y + 1, 2, 2);
            g.fillRect(4 + x + i * 6, y + 4, 2, 2);
        }
    }

    public static boolean hasFocus(Component component) {
        if (component instanceof Container) {
            Container c = (Container)component;
            for (int i = 0; i < c.getComponentCount(); ++i) {
                if (!PgsUtils.hasFocus(c.getComponent(i))) continue;
                return true;
            }
        }
        return component != null && component.isFocusOwner();
    }

    public static void regenerateBorderStroke() {
        rolloverBorderStroke = PlafOptions.isClearBorderEnabled() ? new BasicStroke(2.4f, 2, 0) : new BasicStroke(2.4f, 1, 1);
    }

    public static void drawButtonBorder(Graphics g, int x, int y, int w, int h, Stroke st, Color c) {
        Graphics2D gfx = (Graphics2D)g;
        Stroke s = gfx.getStroke();
        gfx.setStroke(st);
        g.setColor(c);
        if (PlafOptions.isClearBorderEnabled()) {
            g.drawRect(x + 1, y + 1, w - 1, h - 1);
            g.drawLine(x, y, x, y + h);
        } else {
            PgsUtils.drawRoundRect(g, x, y, w, h);
        }
        gfx.setStroke(s);
    }

    public static void drawButtonBorder(Graphics g, int x, int y, int w, int h, Color c) {
        if (PlafOptions.isClearBorderEnabled()) {
            g.setColor(c);
            g.drawRect(x, y, w, h);
        } else {
            Graphics2D gfx = (Graphics2D)g;
            Stroke s = gfx.getStroke();
            gfx.setStroke(borderStroke);
            g.setColor(c);
            PgsUtils.drawRoundRect(g, x, y, w, h);
            gfx.setStroke(s);
        }
    }

    public static void drawButtonBorder(Graphics g, int x, int y, int w, int h, int c1, int c2, Color c) {
        if (PlafOptions.isClearBorderEnabled()) {
            g.setColor(c);
            g.drawRect(x, y, w, h);
        } else {
            Graphics2D gfx = (Graphics2D)g;
            Stroke s = gfx.getStroke();
            gfx.setStroke(borderStroke);
            g.setColor(c);
            PgsUtils.drawRoundRect(g, x, y, w, h, c1, c2);
            gfx.setStroke(s);
        }
    }

    public static void drawDefaultButtonBorder(Graphics g, int x, int y, int w, int h, boolean isRollover) {
        PgsUtils.clearButtonBorder(g, x, y, w, h);
        PgsUtils.drawButtonBorder(g, x + 1, y + 1, w - 3, h - 3, borderStroke, PgsLookAndFeel.getPrimaryControlShadow());
        if (isRollover) {
            PgsUtils.drawRolloverButtonBorder(g, x + 1, y + 1, w - 3, h - 3);
        }
        PgsUtils.drawButtonBorder(g, x, y, w - 1, h - 1, PgsLookAndFeel.getPrimaryControlDarkShadow());
    }

    public static void drawButtonBorder(Graphics g, int x, int y, int w, int h) {
        PgsUtils.clearButtonBorder(g, x, y, w, h);
        PgsUtils.drawButtonBorder(g, x, y, w - 1, h - 1, PgsLookAndFeel.getControlDarkShadow());
    }

    public static void drawRolloverButtonBorder(Graphics g, int x, int y, int w, int h) {
        if (UIManager.getBoolean("Button.rolloverVistaStyle")) {
            PgsUtils.drawButtonBorder(g, x, y, w - 1, h - 1, PgsLookAndFeel.getGlow());
        } else {
            PgsUtils.drawButtonBorder(g, x + 1, y + 1, w - 3, h - 3, rolloverBorderStroke, PgsLookAndFeel.getGlow());
            PgsUtils.drawButtonBorder(g, x, y, w, h);
        }
    }

    private static void clearButtonBorder(Graphics g, int x, int y, int w, int h) {
        if (PlafOptions.isClearBorderEnabled()) {
            return;
        }
        g.setColor(UIManager.getColor("Panel.background"));
        g.drawRect(x, y, w - 1, h - 1);
    }

    public static void drawDisabledBorder(Graphics g, int x, int y, int w, int h) {
        PgsUtils.drawDisabledBorder(g, x, y, w, h, 4, 4);
    }

    public static void drawDisabledBorder(Graphics g, int x, int y, int w, int h, int c1, int c2) {
        PgsUtils.clearButtonBorder(g, x, y, w, h);
        g.setColor(PgsLookAndFeel.getControlShadow());
        if (PlafOptions.isClearBorderEnabled()) {
            g.drawRect(x, y, w, h);
        } else {
            PgsUtils.drawRoundRect(g, x, y, w, h, c1, c2);
        }
    }

    public static void drawRoundRect(Graphics g, int x, int y, int w, int h) {
        PgsUtils.drawRoundRect(g, x, y, w, h, 4, 4);
    }

    public static void drawRoundRect(Graphics g, int x, int y, int w, int h, int c1, int c2) {
        Graphics2D gfx = (Graphics2D)g;
        gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gfx.drawRoundRect(x, y, w, h, c1, c2);
        gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    public static void installAntialiasing(Graphics g) {
        if (!PlafOptions.isAntialiasingEnabled()) {
            return;
        }
        Graphics2D gfx = (Graphics2D)g;
        if (hintsMap == null) {
            hintsMap = new HashMap();
            hintsMap.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            hintsMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            oldHintsMap = new HashMap();
            oldHintsMap.put(RenderingHints.KEY_FRACTIONALMETRICS, gfx.getRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS));
            oldHintsMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, gfx.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING));
            oldHintsMap.put(RenderingHints.KEY_ANTIALIASING, gfx.getRenderingHint(RenderingHints.KEY_ANTIALIASING));
        }
        gfx.addRenderingHints(hintsMap);
    }

    public static void uninstallAntialiasing(Graphics g) {
        if (!PlafOptions.isAntialiasingEnabled()) {
            return;
        }
        ((Graphics2D)g).addRenderingHints(oldHintsMap);
    }

    public static void fixHtmlDisplay(JComponent component) {
        Font defaultFont = UIManager.getFont("Button.font");
        String stylesheet = "body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; font-family: " + defaultFont.getName() + "; font-size: " + defaultFont.getSize() + "pt;\t}" + "a, p, li { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; font-family: " + defaultFont.getName() + "; font-size: " + defaultFont.getSize() + "pt;\t}";
        try {
            HTMLDocument doc = null;
            if (component instanceof JEditorPane) {
                if (((JEditorPane)component).getDocument() instanceof HTMLDocument) {
                    doc = (HTMLDocument)((JEditorPane)component).getDocument();
                }
            } else {
                View v = (View)component.getClientProperty("html");
                if (v != null && v.getDocument() instanceof HTMLDocument) {
                    doc = (HTMLDocument)v.getDocument();
                }
            }
            if (doc != null) {
                doc.getStyleSheet().loadRules(new StringReader(stylesheet), null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        borderStroke = new BasicStroke(1.3f, 1, 1);
        rolloverBorderStroke = new BasicStroke(2.4f, 1, 1);
    }

    private static class ToolBarImageFilter
    extends RGBImageFilter {
        public ToolBarImageFilter() {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int x, int y, int rgb) {
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            int gray = Math.max(Math.max(r, g), b);
            return rgb & 0xFF000000 | gray << 16 | gray << 8 | gray << 0;
        }
    }

    public static class ShadowedIcon
    implements Icon {
        private int shadowWidth = 2;
        private int shadowHeight = 2;
        private Icon icon;
        private Icon shadow;

        public ShadowedIcon(Icon icon) {
            this.icon = icon;
            this.shadow = new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)icon).getImage()));
        }

        public ShadowedIcon(Icon icon, int shadowWidth, int shadowHeight) {
            this(icon);
            this.shadowWidth = shadowWidth;
            this.shadowHeight = shadowHeight;
        }

        public int getIconHeight() {
            return this.icon.getIconWidth() + this.shadowWidth;
        }

        public int getIconWidth() {
            return this.icon.getIconHeight() + this.shadowHeight;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.shadow.paintIcon(c, g, x + this.shadowWidth, y + this.shadowHeight);
            this.icon.paintIcon(c, g, x, y);
        }
    }
}

