/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.Range;
import adams.data.io.input.AbstractMultiSheetSpreadSheetReaderWithMissingValueSupport;
import adams.data.io.input.NoHeaderSpreadSheetReader;

public abstract class AbstractExcelSpreadSheetReader
extends AbstractMultiSheetSpreadSheetReaderWithMissingValueSupport
implements NoHeaderSpreadSheetReader {
    private static final long serialVersionUID = 4755872204697328246L;
    protected boolean m_AutoExtendHeader;
    protected Range m_TextColumns;
    protected boolean m_NoHeader;
    protected String m_CustomColumnHeaders;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("no-auto-extend-header", "autoExtendHeader", (Object)true);
        this.m_OptionManager.add("text-columns", "textColumns", (Object)new Range());
        this.m_OptionManager.add("no-header", "noHeader", (Object)false);
        this.m_OptionManager.add("custom-column-headers", "customColumnHeaders", (Object)"");
    }

    protected void initialize() {
        super.initialize();
        this.m_TextColumns = new Range();
    }

    protected String getDefaultMissingValue() {
        return "";
    }

    public void setAutoExtendHeader(boolean value) {
        this.m_AutoExtendHeader = value;
        this.reset();
    }

    public boolean getAutoExtendHeader() {
        return this.m_AutoExtendHeader;
    }

    public String autoExtendHeaderTipText() {
        return "If enabled, the header gets automatically extended if rows have more cells than the header.";
    }

    public void setTextColumns(Range value) {
        this.m_TextColumns = value;
        this.reset();
    }

    public Range getTextColumns() {
        return this.m_TextColumns;
    }

    public String textColumnsTipText() {
        return "The range of columns to treat as text.";
    }

    public void setNoHeader(boolean value) {
        this.m_NoHeader = value;
        this.reset();
    }

    public boolean getNoHeader() {
        return this.m_NoHeader;
    }

    public String noHeaderTipText() {
        return "If enabled, all rows get added as data rows and a dummy header will get inserted.";
    }

    public void setCustomColumnHeaders(String value) {
        this.m_CustomColumnHeaders = value;
        this.reset();
    }

    public String getCustomColumnHeaders() {
        return this.m_CustomColumnHeaders;
    }

    public String customColumnHeadersTipText() {
        return "The custom headers to use for the columns instead (comma-separated list); ignored if empty.";
    }
}

