/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.timeseries.eval;

import java.util.List;
import weka.classifiers.evaluation.NumericPrediction;
import weka.classifiers.timeseries.eval.ErrorModule;
import weka.core.Instance;
import weka.core.Utils;

public class RAEModule
extends ErrorModule {
    protected double[] m_previousActual;
    protected double[] m_sumOfAbsE;
    protected RAEModule m_relativeRAE;
    protected static final double SMALL = 1.0E-6;

    @Override
    public void reset() {
        super.reset();
        this.m_previousActual = new double[this.m_targetFieldNames.size()];
        this.m_sumOfAbsE = new double[this.m_targetFieldNames.size()];
        for (int i = 0; i < this.m_targetFieldNames.size(); ++i) {
            this.m_previousActual[i] = Utils.missingValue();
            this.m_sumOfAbsE[i] = 0.0;
        }
    }

    public void setRelativeRAEModule(RAEModule relative) {
        this.m_relativeRAE = relative;
    }

    public double[] getPreviousActual() {
        return this.m_previousActual;
    }

    @Override
    public String getEvalName() {
        return "RAE";
    }

    @Override
    public String getDescription() {
        return "Relative absolute error";
    }

    @Override
    public String getDefinition() {
        return "sum(abs(predicted - actual)) / sum(abs(previous_target - actual))";
    }

    protected void evaluatePredictionForTargetForInstance(int targetIndex, NumericPrediction forecast, double actualValue) {
        double predictedValue = forecast.predicted();
        double[][] intervals = forecast.predictionIntervals();
        NumericPrediction pred = new NumericPrediction(actualValue, predictedValue, 1.0, intervals);
        ((List)this.m_predictions.get(targetIndex)).add(pred);
        int n = targetIndex;
        this.m_counts[n] = this.m_counts[n] + 1.0;
    }

    @Override
    public void evaluateForInstance(List<NumericPrediction> forecasts, Instance inst) throws Exception {
        for (int i = 0; i < this.m_targetFieldNames.size(); ++i) {
            double actualValue = this.getTargetValue((String)this.m_targetFieldNames.get(i), inst);
            if (this.m_relativeRAE != null) {
                this.m_previousActual = this.m_relativeRAE.getPreviousActual();
            }
            if (this.m_relativeRAE == null && Utils.isMissingValue((double)this.m_previousActual[i])) {
                this.m_previousActual[i] = actualValue;
                continue;
            }
            if (!Utils.isMissingValue((double)actualValue) && !Utils.isMissingValue((double)this.m_previousActual[i])) {
                this.evaluatePredictionForTargetForInstance(i, forecasts.get(i), actualValue);
                int n = i;
                this.m_sumOfAbsE[n] = this.m_sumOfAbsE[n] + Math.abs(this.m_previousActual[i] - actualValue);
            }
            if (this.m_relativeRAE != null) continue;
            this.m_previousActual[i] = actualValue;
        }
    }

    @Override
    public double[] calculateMeasure() throws Exception {
        int i;
        double[] result = new double[this.m_targetFieldNames.size()];
        for (i = 0; i < result.length; ++i) {
            result[i] = Utils.missingValue();
        }
        for (i = 0; i < this.m_targetFieldNames.size(); ++i) {
            double sumAbs = 0.0;
            double count = 0.0;
            List preds = (List)this.m_predictions.get(i);
            for (NumericPrediction p : preds) {
                if (Utils.isMissingValue((double)p.error())) continue;
                sumAbs += Math.abs(p.error());
                count += 1.0;
            }
            if (this.m_sumOfAbsE[i] == 0.0) {
                this.m_sumOfAbsE[i] = 1.0E-6;
            }
            result[i] = count == 0.0 ? Utils.missingValue() : sumAbs / count / (this.m_sumOfAbsE[i] / count) * 100.0;
        }
        return result;
    }
}

