/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.timeseries.eval.graph;

import java.awt.Image;
import java.util.List;
import javax.swing.JPanel;
import weka.classifiers.evaluation.NumericPrediction;
import weka.classifiers.timeseries.TSForecaster;
import weka.classifiers.timeseries.eval.ErrorModule;
import weka.classifiers.timeseries.eval.graph.JFreeChartDriver;
import weka.core.Instances;

public abstract class GraphDriver {
    public static GraphDriver getDriver(String driverName) throws IllegalArgumentException {
        if (driverName.equals("JFreeChartDriver")) {
            return new JFreeChartDriver();
        }
        try {
            Object candidateModule = Class.forName(driverName).newInstance();
            if (candidateModule instanceof GraphDriver) {
                return (GraphDriver)candidateModule;
            }
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Unable to instantiate " + driverName);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Unknown evaluation moduel " + driverName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unable to instantiate " + driverName);
        }
        throw new IllegalArgumentException("Unknown evaluation moduel " + driverName);
    }

    public static GraphDriver getDefaultDriver() {
        return new JFreeChartDriver();
    }

    public abstract void saveChartToFile(JPanel var1, String var2, int var3, int var4) throws Exception;

    public abstract Image getImageFromChart(JPanel var1, int var2, int var3) throws Exception;

    public abstract JPanel getGraphPanelTargets(TSForecaster var1, ErrorModule var2, List<String> var3, int var4, int var5, Instances var6) throws Exception;

    public abstract JPanel getGraphPanelSteps(TSForecaster var1, List<ErrorModule> var2, String var3, List<Integer> var4, int var5, Instances var6) throws Exception;

    public abstract JPanel getPanelFutureForecast(TSForecaster var1, List<List<NumericPrediction>> var2, List<String> var3, Instances var4) throws Exception;
}

