/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.timeseries.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import weka.classifiers.timeseries.core.CustomPeriodicTest;
import weka.classifiers.timeseries.gui.CustomPeriodicTestEditor;

public class CustomPeriodicEditor
extends JPanel {
    private static final long serialVersionUID = 9027916898659519804L;
    protected List<CustomPeriodicTest> m_testsToEdit;
    protected CustomPeriodicTestEditor m_lowerBoundEditor = new CustomPeriodicTestEditor(false);
    protected CustomPeriodicTestEditor m_upperBoundEditor = new CustomPeriodicTestEditor(true);
    protected JTextField m_fieldName = new JTextField("MyNewField");
    protected JList m_testsToEditList;
    protected JButton m_newBut = new JButton("New");
    protected JButton m_deleteBut = new JButton("Delete");
    protected JTextField m_labelField = new JTextField();

    public CustomPeriodicEditor(List<CustomPeriodicTest> tests) {
        this.m_testsToEdit = tests;
        final DefaultListModel<CustomPeriodicTest> testVec = new DefaultListModel<CustomPeriodicTest>();
        for (CustomPeriodicTest t : tests) {
            testVec.addElement(t);
        }
        this.m_testsToEditList = new JList(testVec);
        JScrollPane js = new JScrollPane(this.m_testsToEditList);
        js.setBorder(BorderFactory.createTitledBorder("Test list (rows are OR'ed)"));
        this.m_testsToEditList.setVisibleRowCount(5);
        this.m_deleteBut.setEnabled(false);
        this.setLayout(new BorderLayout());
        JPanel fieldHolder = new JPanel();
        fieldHolder.setLayout(new BorderLayout());
        fieldHolder.setBorder(BorderFactory.createTitledBorder("Field name"));
        fieldHolder.add((Component)this.m_fieldName, "Center");
        JPanel buttHolder = new JPanel();
        buttHolder.setLayout(new BorderLayout());
        buttHolder.setBorder(BorderFactory.createTitledBorder("Edit"));
        JPanel tempH = new JPanel();
        tempH.setLayout(new BorderLayout());
        tempH.add((Component)this.m_newBut, "West");
        tempH.add((Component)this.m_deleteBut, "East");
        buttHolder.add((Component)tempH, "West");
        JPanel fieldAndButtHolder = new JPanel();
        fieldAndButtHolder.setLayout(new BorderLayout());
        fieldAndButtHolder.add((Component)fieldHolder, "North");
        fieldAndButtHolder.add((Component)buttHolder, "Center");
        JPanel testEditorHolder = new JPanel();
        testEditorHolder.setLayout(new BorderLayout());
        JPanel tempP = new JPanel();
        tempP.setLayout(new BorderLayout());
        testEditorHolder.setBorder(BorderFactory.createTitledBorder("Test interval"));
        tempP.add((Component)this.m_lowerBoundEditor, "North");
        tempP.add((Component)this.m_upperBoundEditor, "South");
        JPanel labelHolder = new JPanel();
        labelHolder.setLayout(new BorderLayout());
        JLabel labelLabel = new JLabel("Label");
        labelLabel.setToolTipText("The label for this test. If all tests have a label then a nominal attribute is created; otherwise it is binary");
        labelHolder.add((Component)labelLabel, "West");
        labelHolder.add((Component)this.m_labelField, "Center");
        this.m_labelField.setToolTipText("The label for this test. If all tests have a label then a nominal attribute is created; otherwise it is binary");
        testEditorHolder.add((Component)tempP, "North");
        testEditorHolder.add((Component)labelHolder, "South");
        fieldAndButtHolder.add((Component)testEditorHolder, "South");
        this.add((Component)fieldAndButtHolder, "North");
        this.add((Component)js, "Center");
        this.m_testsToEditList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    Object test;
                    if (!CustomPeriodicEditor.this.m_deleteBut.isEnabled()) {
                        CustomPeriodicEditor.this.m_deleteBut.setEnabled(true);
                    }
                    if ((test = CustomPeriodicEditor.this.m_testsToEditList.getSelectedValue()) != null) {
                        CustomPeriodicTest t = (CustomPeriodicTest)test;
                        CustomPeriodicEditor.this.m_lowerBoundEditor.setTestToEdit(t);
                        CustomPeriodicEditor.this.m_upperBoundEditor.setTestToEdit(t);
                        if (t.getLabel() != null && t.getLabel().length() > 0) {
                            CustomPeriodicEditor.this.m_labelField.setText(t.getLabel());
                        } else {
                            CustomPeriodicEditor.this.m_labelField.setText("");
                        }
                    }
                }
            }
        });
        this.m_newBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomPeriodicTest newTest = new CustomPeriodicTest(">*:*:*:*:*:*:*:*:*:* <*:*:*:*:*:*:*:*:*:*");
                CustomPeriodicEditor.this.m_lowerBoundEditor.setTestToEdit(newTest);
                CustomPeriodicEditor.this.m_upperBoundEditor.setTestToEdit(newTest);
                testVec.addElement(newTest);
                CustomPeriodicEditor.this.m_testsToEdit.add(newTest);
                CustomPeriodicEditor.this.m_labelField.setText("");
                CustomPeriodicEditor.this.m_testsToEditList.setSelectedIndex(CustomPeriodicEditor.this.m_testsToEdit.size() - 1);
            }
        });
        this.m_deleteBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = CustomPeriodicEditor.this.m_testsToEditList.getSelectedIndex();
                if (selected >= 0) {
                    testVec.removeElementAt(selected);
                    CustomPeriodicEditor.this.m_testsToEdit.remove(selected);
                }
            }
        });
        this.m_lowerBoundEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                CustomPeriodicEditor.this.m_testsToEditList.repaint();
                if (CustomPeriodicEditor.this.m_lowerBoundEditor.getTestBeingEdited().getLowerTest().m_boundOperator == CustomPeriodicTest.Operator.EQUALS) {
                    CustomPeriodicEditor.this.m_upperBoundEditor.setEnabled(false);
                } else {
                    CustomPeriodicEditor.this.m_upperBoundEditor.setEnabled(true);
                }
            }
        });
        this.m_upperBoundEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                CustomPeriodicEditor.this.m_testsToEditList.repaint();
            }
        });
        this.m_labelField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                Object test = CustomPeriodicEditor.this.m_testsToEditList.getSelectedValue();
                if (test != null) {
                    CustomPeriodicTest t = (CustomPeriodicTest)test;
                    t.setLabel(CustomPeriodicEditor.this.m_labelField.getText());
                    CustomPeriodicEditor.this.m_testsToEditList.repaint();
                }
            }
        });
    }

    public String getFieldName() {
        return this.m_fieldName.getText();
    }

    public void setFieldName(String name) {
        this.m_fieldName.setText(name);
    }

    public static void main(String[] args) {
        try {
            final ArrayList<CustomPeriodicTest> testList = new ArrayList<CustomPeriodicTest>();
            CustomPeriodicEditor ed = new CustomPeriodicEditor(testList);
            final JFrame jf = new JFrame("Periodic test editor");
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)ed, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    for (CustomPeriodicTest t : testList) {
                        System.out.println(t.toString());
                    }
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

