/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.parser;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocumentElement;
import de.intarsys.pdf.cos.COSFalse;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSObjectKey;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.cos.COSTrue;
import de.intarsys.pdf.crypt.COSSecurityException;
import de.intarsys.pdf.crypt.ISystemSecurityHandler;
import de.intarsys.pdf.parser.COSDocumentParser;
import de.intarsys.pdf.parser.COSLoadError;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.parser.COSLoadWarning;
import de.intarsys.pdf.parser.IPDFParserExceptionHandler;
import de.intarsys.pdf.st.STDocType;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import de.intarsys.tools.stream.FastByteArrayOutputStream;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public abstract class PDFParser {
    public static char CHAR_CR = (char)13;
    public static char CHAR_LF = (char)10;
    public static char CHAR_HT = (char)9;
    public static char CHAR_BS = (char)8;
    public static char CHAR_FF = (char)12;
    public static final byte[] TOKEN_PDFHEADER = "%PDF".getBytes();
    public static final byte[] TOKEN_FDFHEADER = "%FDF".getBytes();
    public static final byte[] TOKEN_EOF = "%%EOF".getBytes();
    public static final byte[] TOKEN_obj = "obj".getBytes();
    public static final byte[] TOKEN_endobj = "endobj".getBytes();
    public static final byte[] TOKEN_false = "false".getBytes();
    public static final byte[] TOKEN_true = "true".getBytes();
    public static final byte[] TOKEN_null = "null".getBytes();
    public static final byte[] TOKEN_startxref = "startxref".getBytes();
    public static final byte[] TOKEN_trailer = "trailer".getBytes();
    public static final byte[] TOKEN_xref = "xref".getBytes();
    public static final byte[] TOKEN_stream = "stream".getBytes();
    public static final byte[] TOKEN_s_tream = "tream".getBytes();
    public static final byte[] TOKEN_endstream = "endstream".getBytes();
    public static final byte[] TOKEN_ndstream = "ndstream".getBytes();
    public static final byte[] TOKEN_R = "R".getBytes();
    public static final String C_WARN_UNEVENHEX = "616a";
    public static final String C_WARN_ILLEGALHEX = "616b";
    public static final String C_WARN_STRINGTOLONG = "ImplLimitString";
    public static final String C_WARN_NAMETOLONG = "ImplLimitName";
    public static final String C_WARN_ARRAYSIZE = "ImplLimitArray";
    public static final String C_WARN_SINGLESPACE = "614a";
    public static final String C_WARN_SINGLEEOL = "614b";
    public static final String C_WARN_STREAMEOL = "617a";
    public static final String C_WARN_ENDSTREAMEOL = "617b";
    public static final String C_WARN_ENDSTREAMCORRUPT = "617c";
    public static final String C_WARN_STREAMEXTERNAL = "617d";
    public static final String C_WARN_STREAMLENGTH = "617e";
    public static final String C_WARN_SINGLESPACE_OBJ = "618a";
    public static final String C_WARN_SINGLEEOL_OBJ = "618b";
    public static final String C_WARN_ENDOBJ_MISSING = "618c";
    public static final String C_WARN_LARGE_INT = "6112a";
    protected static final String C_TOKEN_ADDWSB = "additional whitespace before";
    protected static final String C_TOKEN_WSB = "whitespace before";
    protected static final String C_TOKEN_ADDWSA = "additional whitespace after";
    protected static final String C_TOKEN_ADDWSA2 = "second add whitespace after";
    protected static final String C_TOKEN_COMMENT = "comment";
    protected static final String C_TOKEN_NOWSA = "no whitespace after";
    protected static final byte[] characterClass = new byte[256];
    protected static final byte CHARCLASS_ANY = 0;
    protected static final byte CHARCLASS_DELIMITER = 1;
    protected static final byte CHARCLASS_WHITESPACE = 2;
    protected static final byte CHARCLASS_TOKEN = 3;
    protected static final byte CHARCLASS_DIGIT = 4;
    protected static final byte CHARCLASS_NUMBERSPECIAL = 5;
    public static final byte[] TOKEN_def = "def".getBytes();
    private COSObject[] lookahead = new COSObject[3];
    private int lookaheadCount = 0;
    private ISystemSecurityHandler securityHandler;
    private boolean flushLookahead = false;
    private FastByteArrayOutputStream localStream = new FastByteArrayOutputStream();
    private IPDFParserExceptionHandler exceptionHandler;
    private COSObjectKey objectKey;
    protected boolean check = false;

    static {
        int n = 0;
        while (n < 256) {
            PDFParser.characterClass[n] = 0;
            ++n;
        }
        PDFParser.characterClass[40] = 1;
        PDFParser.characterClass[41] = 1;
        PDFParser.characterClass[60] = 1;
        PDFParser.characterClass[62] = 1;
        PDFParser.characterClass[91] = 1;
        PDFParser.characterClass[93] = 1;
        PDFParser.characterClass[123] = 1;
        PDFParser.characterClass[125] = 1;
        PDFParser.characterClass[47] = 1;
        PDFParser.characterClass[37] = 1;
        PDFParser.characterClass[32] = 2;
        PDFParser.characterClass[9] = 2;
        PDFParser.characterClass[13] = 2;
        PDFParser.characterClass[10] = 2;
        PDFParser.characterClass[12] = 2;
        PDFParser.characterClass[0] = 2;
        PDFParser.characterClass[48] = 4;
        PDFParser.characterClass[49] = 4;
        PDFParser.characterClass[50] = 4;
        PDFParser.characterClass[51] = 4;
        PDFParser.characterClass[52] = 4;
        PDFParser.characterClass[53] = 4;
        PDFParser.characterClass[54] = 4;
        PDFParser.characterClass[55] = 4;
        PDFParser.characterClass[56] = 4;
        PDFParser.characterClass[57] = 4;
        PDFParser.characterClass[46] = 5;
        PDFParser.characterClass[45] = 5;
        PDFParser.characterClass[43] = 5;
        n = 97;
        while (n <= 122) {
            PDFParser.characterClass[n] = 3;
            ++n;
        }
        n = 65;
        while (n <= 90) {
            PDFParser.characterClass[n] = 3;
            ++n;
        }
        PDFParser.characterClass[39] = 3;
        PDFParser.characterClass[34] = 3;
    }

    public static final boolean isDelimiter(int n) {
        return characterClass[n] == 1;
    }

    public static final boolean isDigit(int n) {
        return characterClass[n] == 4;
    }

    public static final boolean isEOL(int n) {
        return n == CHAR_CR || n == CHAR_LF || n == 12;
    }

    public static final boolean isNumberStart(int n) {
        byte by = characterClass[n];
        return by == 4 || by == 5;
    }

    public static final boolean isOctalDigit(int n) {
        return n >= 48 && n <= 55;
    }

    public static final boolean isTokenStart(int n) {
        return characterClass[n] == 3;
    }

    public static final boolean isWhitespace(int n) {
        return characterClass[n] == 2;
    }

    public static COSObject toCOSObject(byte[] byArray) throws IOException, COSLoadException {
        COSDocumentParser cOSDocumentParser = new COSDocumentParser(null);
        return (COSObject)cOSDocumentParser.parseElement((IRandomAccess)new RandomAccessByteArray(byArray));
    }

    protected abstract COSIndirectObject createObjectReference(IRandomAccess var1) throws IOException, COSLoadException;

    public IPDFParserExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    protected COSObjectKey getObjectKey() {
        return this.objectKey;
    }

    protected ISystemSecurityHandler getSecurityHandler() {
        return this.securityHandler;
    }

    public void handleError(COSLoadError cOSLoadError) throws COSLoadException {
        if (this.exceptionHandler == null) {
            throw cOSLoadError;
        }
        this.exceptionHandler.error(cOSLoadError);
    }

    public void handleWarning(COSLoadWarning cOSLoadWarning) throws COSLoadException {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.warning(cOSLoadWarning);
        }
    }

    protected COSObject lookaheadPop() {
        COSObject cOSObject = this.lookahead[0];
        this.lookahead[0] = this.lookahead[1];
        this.lookahead[1] = this.lookahead[2];
        this.lookahead[2] = null;
        --this.lookaheadCount;
        if (this.lookaheadCount <= 0) {
            this.lookaheadCount = 0;
            this.flushLookahead = false;
        }
        return cOSObject;
    }

    protected void lookaheadPush(COSObject cOSObject) {
        this.lookahead[this.lookaheadCount++] = cOSObject;
    }

    protected void parseComment(IRandomAccess iRandomAccess) throws IOException {
        int n;
        while ((n = iRandomAccess.read()) != -1 && !PDFParser.isEOL(n)) {
        }
    }

    public Object parseElement(IRandomAccess iRandomAccess) throws IOException, COSLoadException {
        int n;
        while (true) {
            if ((n = iRandomAccess.read()) == -1) {
                return null;
            }
            if (PDFParser.isNumberStart(n)) {
                return this.parseOnObjectNumber(iRandomAccess, n);
            }
            if (n == 40) {
                return this.parseOnObjectString(iRandomAccess);
            }
            if (PDFParser.isTokenStart(n)) {
                byte[] byArray = this.readTokenElement(iRandomAccess, n);
                if (byArray.length == 1) {
                    if (byArray[0] == TOKEN_R[0]) {
                        return TOKEN_R;
                    }
                } else if (byArray.length == 4) {
                    if (byArray[0] == TOKEN_true[0] && byArray[1] == TOKEN_true[1] && byArray[2] == TOKEN_true[2] && byArray[3] == TOKEN_true[3]) {
                        return COSTrue.create();
                    }
                    if (byArray[0] == TOKEN_null[0] && byArray[1] == TOKEN_null[1] && byArray[2] == TOKEN_null[2] && byArray[3] == TOKEN_null[3]) {
                        return COSNull.create();
                    }
                } else if (byArray.length == 5 && byArray[0] == TOKEN_false[0] && byArray[1] == TOKEN_false[1] && byArray[2] == TOKEN_false[2] && byArray[3] == TOKEN_false[3] && byArray[4] == TOKEN_false[4]) {
                    return COSFalse.create();
                }
                return byArray;
            }
            if (n == 47) {
                return this.parseOnObjectName(iRandomAccess);
            }
            if (n == 32 || PDFParser.isWhitespace(n)) continue;
            if (n != 37) break;
            this.parseComment(iRandomAccess);
        }
        if (this.lookaheadCount > 0) {
            iRandomAccess.seekBy(-1L);
            return null;
        }
        if (n == 60) {
            return this.parseOnObjectStreamOrDictionaryOrHexString(iRandomAccess);
        }
        if (n == 91) {
            return this.parseOnObjectArray(iRandomAccess);
        }
        iRandomAccess.seekBy(-1L);
        return null;
    }

    public STDocType parseHeader(IRandomAccess iRandomAccess) throws IOException, COSLoadException {
        int n;
        boolean bl = false;
        while ((n = iRandomAccess.read()) != -1 && n != 37) {
            bl = true;
        }
        STDocType sTDocType = new STDocType();
        if (n == -1) {
            COSLoadError cOSLoadError = new COSLoadError("file format error. document must start with %PDF or %FDF");
            this.handleError(cOSLoadError);
        } else {
            Object object;
            byte[] byArray = new byte[4];
            byArray[0] = (byte)n;
            iRandomAccess.read(byArray, 1, 3);
            if (Arrays.equals(byArray, TOKEN_PDFHEADER)) {
                sTDocType.setTypeName("PDF");
            } else if (Arrays.equals(byArray, TOKEN_FDFHEADER)) {
                sTDocType.setTypeName("FDF");
            } else {
                iRandomAccess.seekBy((long)(-byArray.length));
                object = new COSLoadError("file format error. document must start with %PDF or %FDF at character index " + iRandomAccess.getOffset());
                this.handleError((COSLoadError)object);
            }
            if (bl) {
                object = new COSLoadWarning("file format error. document must start with %PDF or %FDF at character index " + iRandomAccess.getOffset());
                this.handleWarning((COSLoadWarning)object);
            }
            iRandomAccess.read();
            object = this.readToken(iRandomAccess);
            if (object == null) {
                COSLoadError cOSLoadError = new COSLoadError("file format error. no pdf/fdf version info found at character index " + iRandomAccess.getOffset());
                this.handleError(cOSLoadError);
            } else {
                sTDocType.setVersion(StringTools.toString((byte[])object));
            }
        }
        return sTDocType;
    }

    protected COSDocumentElement parseObject(IRandomAccess iRandomAccess) throws IOException, COSLoadException {
        if (this.flushLookahead) {
            return this.lookaheadPop();
        }
        Object object = this.parseElement(iRandomAccess);
        if (object == null) {
            this.flushLookahead = true;
            return this.lookaheadPop();
        }
        if (object instanceof byte[]) {
            if (TOKEN_R == object) {
                return this.createObjectReference(iRandomAccess);
            }
            iRandomAccess.seekBy(-1L);
            int n = iRandomAccess.read();
            if (n == 32 || PDFParser.isWhitespace(n)) {
                iRandomAccess.seekBy(-1L);
            }
            iRandomAccess.seekBy((long)(-((byte[])object).length));
            this.flushLookahead = true;
            return this.lookaheadPop();
        }
        COSObject cOSObject = (COSObject)object;
        if (cOSObject instanceof COSNumber) {
            this.lookaheadPush(cOSObject);
            if (this.lookaheadCount > 2) {
                return this.lookaheadPop();
            }
            return this.parseObject(iRandomAccess);
        }
        if (this.lookaheadCount > 0) {
            this.lookaheadPush(cOSObject);
            this.flushLookahead = true;
            return this.lookaheadPop();
        }
        return cOSObject;
    }

    protected COSObject parseObjectDictionary(IRandomAccess iRandomAccess) throws IOException, COSLoadException {
        COSLoadError cOSLoadError;
        int n = iRandomAccess.read();
        if (n != 60) {
            iRandomAccess.seekBy(-1L);
            cOSLoadError = new COSLoadError("'<' expected at character index " + iRandomAccess.getOffset());
            this.handleError(cOSLoadError);
        }
        if ((n = iRandomAccess.read()) != 60) {
            iRandomAccess.seekBy(-1L);
            cOSLoadError = new COSLoadError("'<' expected at character index " + iRandomAccess.getOffset());
            this.handleError(cOSLoadError);
        }
        return this.parseOnObjectDictionary(iRandomAccess);
    }

    protected COSObject parseOnObjectArray(IRandomAccess iRandomAccess) throws COSLoadException, IOException {
        try {
            Object object;
            COSArray cOSArray = COSArray.create();
            if (this.securityHandler != null) {
                this.securityHandler.pushContextObject(cOSArray);
            }
            while (true) {
                if ((object = this.parseObject(iRandomAccess)) == null) {
                    int n = iRandomAccess.read();
                    if (n == -1) {
                        this.unexpectedEndOfInput(iRandomAccess);
                    }
                    if (n == 93) break;
                    byte[] byArray = this.readTokenElement(iRandomAccess, n);
                    if (!this.check) continue;
                    COSLoadWarning cOSLoadWarning = new COSLoadWarning("bad array element (" + new String(byArray) + ")");
                    cOSLoadWarning.setHint(cOSArray);
                    this.handleWarning(cOSLoadWarning);
                    continue;
                }
                cOSArray.basicAddSilent((COSDocumentElement)object);
            }
            if (this.check && cOSArray.size() > 8191) {
                object = new COSLoadWarning(C_WARN_ARRAYSIZE);
                ((COSLoadException)object).setHint(cOSArray);
                this.handleWarning((COSLoadWarning)object);
            }
            COSArray cOSArray2 = cOSArray;
            return cOSArray2;
        }
        finally {
            if (this.securityHandler != null) {
                this.securityHandler.popContextObject();
            }
        }
    }

    protected COSObject parseOnObjectDictionary(IRandomAccess iRandomAccess) throws IOException, COSLoadException {
        try {
            Object object;
            COSDictionary cOSDictionary = COSDictionary.create();
            if (this.securityHandler != null) {
                this.securityHandler.pushContextObject(cOSDictionary);
            }
            try {
                while (true) {
                    Object object2;
                    if ((object = this.parseObject(iRandomAccess)) == null) {
                        iRandomAccess.mark();
                        object2 = this.parseElement(iRandomAccess);
                        if (object2 != null && object2 instanceof byte[] && Arrays.equals(TOKEN_def, (byte[])object2)) continue;
                        iRandomAccess.reset();
                        break;
                    }
                    object2 = (COSName)object;
                    COSDocumentElement cOSDocumentElement = this.parseObject(iRandomAccess);
                    if (cOSDocumentElement == null) {
                        COSLoadError cOSLoadError = new COSLoadError("missing value for key '" + object + "' at character index " + iRandomAccess.getOffset());
                        this.handleError(cOSLoadError);
                        continue;
                    }
                    cOSDictionary.basicPutSilent((COSName)object2, cOSDocumentElement);
                }
            }
            catch (ClassCastException classCastException) {
                COSLoadError cOSLoadError = new COSLoadError("name expected at character index " + iRandomAccess.getOffset());
                this.handleError(cOSLoadError);
            }
            int n = iRandomAccess.read();
            if (n != 62) {
                object = new COSLoadError("unexpected character (" + (char)n + ") at character index " + iRandomAccess.getOffset());
                this.handleError((COSLoadError)object);
            }
            if ((n = iRandomAccess.read()) != 62) {
                object = new COSLoadError("unexpected character (" + (char)n + ") at character index " + iRandomAccess.getOffset());
                this.handleError((COSLoadError)object);
            }
            COSDictionary cOSDictionary2 = cOSDictionary;
            return cOSDictionary2;
        }
        finally {
            if (this.securityHandler != null) {
                this.securityHandler.popContextObject();
            }
        }
    }

    protected COSObject parseOnObjectHexString(IRandomAccess iRandomAccess, int n) throws IOException, COSLoadException {
        Object object;
        Object object2;
        this.localStream.reset();
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            if ((n2 = HexTools.hexDigitToInt((char)((char)n))) == -1) {
                if (n == -1 || n == 62) break;
                if (!PDFParser.isWhitespace(n)) {
                    IOException iOException = new IOException("<" + n + "> '" + (char)n + "' not a valid hex char");
                    COSLoadWarning cOSLoadWarning = new COSLoadWarning(C_WARN_ILLEGALHEX);
                    cOSLoadWarning.setHint(new Long(iRandomAccess.getOffset()));
                    this.handleWarning(cOSLoadWarning);
                    throw iOException;
                }
            } else if (bl) {
                n3 = (n3 << 4) + n2;
                this.localStream.write(n3);
                bl = false;
            } else {
                bl = true;
                n3 = n2;
            }
            n = iRandomAccess.read();
        }
        if (bl) {
            if (this.check) {
                object2 = new COSLoadWarning(C_WARN_UNEVENHEX);
                ((COSLoadException)object2).setHint(new Long(iRandomAccess.getOffset()));
                this.handleWarning((COSLoadWarning)object2);
            }
            this.localStream.write(n3 <<= 4);
        }
        if (this.securityHandler == null || this.objectKey == null) {
            object2 = COSString.createHex(this.localStream.toByteArray());
        } else {
            object = this.localStream.toByteArray();
            try {
                byte[] byArray = this.securityHandler.decryptString(this.objectKey, (byte[])object);
                object2 = COSString.createHex(byArray);
            }
            catch (COSSecurityException cOSSecurityException) {
                object2 = COSString.createHex((byte[])object);
                COSLoadWarning cOSLoadWarning = new COSLoadWarning("error decrypting string " + this.objectKey, cOSSecurityException);
                this.handleWarning(cOSLoadWarning);
            }
        }
        if (this.check && ((COSString)object2).stringValue().length() > 65535) {
            object = new COSLoadWarning(C_WARN_STRINGTOLONG);
            ((COSLoadException)object).setHint(object2);
            this.handleWarning((COSLoadWarning)object);
        }
        return object2;
    }

    protected COSObject parseOnObjectName(IRandomAccess iRandomAccess) throws IOException, COSLoadException {
        COSLoadException cOSLoadException;
        int n;
        this.localStream.reset();
        while ((n = iRandomAccess.read()) != -1 && n != 32 && !PDFParser.isWhitespace(n)) {
            if (PDFParser.isDelimiter(n)) {
                iRandomAccess.seekBy(-1L);
                break;
            }
            if (n == 35) {
                int n2;
                n = iRandomAccess.read();
                int n3 = HexTools.hexDigitToInt((char)((char)n));
                if (n3 == -1) {
                    COSLoadError cOSLoadError = new COSLoadError("<" + n + "> not a valid hex char at character index " + iRandomAccess.getOffset());
                    this.handleError(cOSLoadError);
                }
                if ((n2 = HexTools.hexDigitToInt((char)((char)(n = iRandomAccess.read())))) == -1) {
                    cOSLoadException = new COSLoadError("<" + n + "> not a valid hex char at character index " + iRandomAccess.getOffset());
                    this.handleError((COSLoadError)cOSLoadException);
                }
                this.localStream.write((n3 << 4) + n2);
                continue;
            }
            this.localStream.write(n);
        }
        byte[] byArray = this.localStream.toByteArray();
        COSName cOSName = COSName.create(byArray);
        if (this.check && cOSName.stringValue().length() > 127) {
            cOSLoadException = new COSLoadWarning(C_WARN_NAMETOLONG);
            cOSLoadException.setHint(cOSName);
            this.handleWarning((COSLoadWarning)cOSLoadException);
        }
        return cOSName;
    }

    protected COSObject parseOnObjectNumber(IRandomAccess iRandomAccess, int n) throws IOException, COSLoadException {
        boolean bl = false;
        this.localStream.reset();
        bl = n == 46;
        this.localStream.write((int)((byte)n));
        while ((n = iRandomAccess.read()) != -1) {
            if (PDFParser.isDigit(n)) {
                this.localStream.write((int)((byte)n));
                continue;
            }
            if (n == 46) {
                bl = true;
                this.localStream.write((int)((byte)n));
                continue;
            }
            if (n == 32 || PDFParser.isWhitespace(n)) break;
            iRandomAccess.seekBy(-1L);
            break;
        }
        if (bl) {
            COSFixed cOSFixed = COSFixed.create(this.localStream.getBytes(), 0, this.localStream.size());
            return cOSFixed;
        }
        byte[] byArray = this.localStream.getBytes();
        int n2 = this.localStream.size();
        if (this.exceptionHandler != null) {
            COSInteger cOSInteger = COSInteger.createStrict(byArray, 0, n2);
            if (cOSInteger != null) {
                return cOSInteger;
            }
            COSLoadWarning cOSLoadWarning = new COSLoadWarning(C_WARN_LARGE_INT);
            this.handleWarning(cOSLoadWarning);
        }
        return COSInteger.create(byArray, 0, n2);
    }

    protected COSObject parseOnObjectStream(IRandomAccess iRandomAccess, COSDictionary cOSDictionary) throws IOException, COSLoadException {
        COSLoadException cOSLoadException;
        int n;
        Object object;
        int n2;
        COSStream cOSStream = COSStream.create(cOSDictionary);
        byte[] byArray = new byte[5];
        iRandomAccess.read(byArray);
        if (!Arrays.equals(byArray, TOKEN_s_tream)) {
            iRandomAccess.seekBy((long)(-byArray.length - 1));
            COSLoadError cOSLoadError = new COSLoadError("file format error. 'stream' expected at character index " + iRandomAccess.getOffset());
            this.handleError(cOSLoadError);
        }
        if ((n2 = iRandomAccess.read()) == -1) {
            this.unexpectedEndOfInput(iRandomAccess);
        }
        if (n2 == CHAR_CR) {
            n2 = iRandomAccess.read();
        }
        if (n2 != CHAR_LF) {
            if (this.check) {
                COSLoadWarning cOSLoadWarning = new COSLoadWarning(C_WARN_STREAMEOL);
                cOSLoadWarning.setHint(new Long(iRandomAccess.getOffset()));
                this.handleWarning(cOSLoadWarning);
            }
            iRandomAccess.seekBy(-1L);
        }
        long l = iRandomAccess.getOffset();
        int n3 = -1;
        COSInteger cOSInteger = cOSDictionary.get(COSStream.DK_Length).asInteger();
        if (cOSInteger == null) {
            if (this.check) {
                object = new COSLoadWarning(C_WARN_STREAMLENGTH);
                ((COSLoadException)object).setHint(new Long(iRandomAccess.getOffset()));
                this.handleWarning((COSLoadWarning)object);
            }
        } else {
            n3 = ((COSNumber)cOSInteger).intValue();
        }
        iRandomAccess.seek(l);
        object = null;
        if (n3 < 0) {
            object = this.readStream(iRandomAccess);
        } else {
            object = new byte[n3];
            n = iRandomAccess.read((byte[])object);
            if (n < n3) {
                if (this.check) {
                    cOSLoadException = new COSLoadWarning(C_WARN_STREAMLENGTH);
                    cOSLoadException.setHint(new Long(iRandomAccess.getOffset()));
                    this.handleWarning((COSLoadWarning)cOSLoadException);
                }
                this.unexpectedEndOfInput(iRandomAccess);
            }
        }
        if (this.check) {
            n = this.readEOL(iRandomAccess);
            if (n != 1) {
                cOSLoadException = new COSLoadWarning(C_WARN_ENDSTREAMEOL);
                cOSLoadException.setHint(new Long(iRandomAccess.getOffset()));
                this.handleWarning((COSLoadWarning)cOSLoadException);
            }
        } else {
            this.readSpaces(iRandomAccess);
        }
        byArray = new byte[9];
        iRandomAccess.read(byArray);
        if (!Arrays.equals(byArray, TOKEN_endstream)) {
            iRandomAccess.seekBy((long)(-byArray.length - 1));
            COSLoadWarning cOSLoadWarning = new COSLoadWarning(C_WARN_ENDSTREAMCORRUPT);
            cOSLoadWarning.setHint(new Long(iRandomAccess.getOffset()));
            this.handleWarning(cOSLoadWarning);
            if (n3 > 0) {
                iRandomAccess.seek(l);
                object = this.readStream(iRandomAccess);
                byArray = new byte[9];
                iRandomAccess.read(byArray);
                if (!Arrays.equals(byArray, TOKEN_endstream)) {
                    cOSLoadException = new COSLoadError("file format error. 'endstream' expected at character index " + iRandomAccess.getOffset());
                    this.handleError((COSLoadError)cOSLoadException);
                }
            } else {
                cOSLoadException = new COSLoadError("file format error. 'endstream' expected at character index " + iRandomAccess.getOffset());
                this.handleError((COSLoadError)cOSLoadException);
            }
        }
        if (this.securityHandler == null || this.objectKey == null) {
            cOSStream.basicSetEncodedBytes((byte[])object);
        } else {
            try {
                byte[] byArray2 = this.securityHandler.decryptStream(this.objectKey, cOSDictionary, (byte[])object);
                cOSStream.basicSetEncodedBytes(byArray2);
            }
            catch (COSSecurityException cOSSecurityException) {
                cOSStream.basicSetEncodedBytes((byte[])object);
                cOSLoadException = new COSLoadWarning("error decrypting stream " + this.objectKey, cOSSecurityException);
                this.handleWarning((COSLoadWarning)cOSLoadException);
            }
        }
        return cOSStream;
    }

    protected COSObject parseOnObjectStreamOrDictionary(IRandomAccess iRandomAccess) throws IOException, COSLoadException {
        int n;
        COSObject cOSObject = this.parseOnObjectDictionary(iRandomAccess);
        boolean bl = false;
        while (true) {
            if ((n = iRandomAccess.read()) == -1) {
                return cOSObject;
            }
            if (n != 32 && !PDFParser.isWhitespace(n)) break;
            if (n == 10 || n == 13) {
                bl = true;
                continue;
            }
            bl = false;
        }
        if (n == 115) {
            return this.parseOnObjectStream(iRandomAccess, (COSDictionary)cOSObject);
        }
        if (n == 101 && this.check && !bl) {
            COSLoadWarning cOSLoadWarning = new COSLoadWarning(C_WARN_SINGLEEOL_OBJ);
            cOSLoadWarning.setHint(new Long(iRandomAccess.getOffset()));
            this.handleWarning(cOSLoadWarning);
        }
        iRandomAccess.seekBy(-1L);
        return cOSObject;
    }

    protected COSObject parseOnObjectStreamOrDictionaryOrHexString(IRandomAccess iRandomAccess) throws IOException, COSLoadException {
        int n = iRandomAccess.read();
        if (n == 60) {
            return this.parseOnObjectStreamOrDictionary(iRandomAccess);
        }
        return this.parseOnObjectHexString(iRandomAccess, n);
    }

    protected COSObject parseOnObjectString(IRandomAccess iRandomAccess) throws IOException, COSLoadException {
        Object object;
        COSString cOSString;
        int n = 0;
        this.localStream.reset();
        while (true) {
            int n2;
            if ((n2 = iRandomAccess.read()) == 92) {
                int n3 = this.readEscape(iRandomAccess);
                if (n3 == -1) continue;
                this.localStream.write(n3);
                continue;
            }
            if (n2 == 41) {
                if (n <= 0) break;
                --n;
                this.localStream.write(n2);
                continue;
            }
            if (n2 == CHAR_CR) {
                n2 = iRandomAccess.read();
                if (n2 != -1 && n2 != CHAR_LF) {
                    iRandomAccess.seekBy(-1L);
                }
                this.localStream.write((int)CHAR_LF);
                continue;
            }
            if (n2 == 40) {
                ++n;
                this.localStream.write(n2);
                continue;
            }
            if (n2 == -1) {
                this.unexpectedEndOfInput(iRandomAccess);
                continue;
            }
            this.localStream.write(n2);
        }
        if (this.securityHandler == null || this.objectKey == null) {
            cOSString = COSString.create(this.localStream.toByteArray());
        } else {
            object = this.localStream.toByteArray();
            try {
                byte[] byArray = this.securityHandler.decryptString(this.objectKey, (byte[])object);
                cOSString = COSString.create(byArray);
            }
            catch (COSSecurityException cOSSecurityException) {
                cOSString = COSString.create((byte[])object);
                COSLoadWarning cOSLoadWarning = new COSLoadWarning("error decrypting string " + this.objectKey, cOSSecurityException);
                this.handleWarning(cOSLoadWarning);
            }
        }
        if (this.check && cOSString.stringValue().length() > 65535) {
            object = new COSLoadWarning(C_WARN_STRINGTOLONG);
            ((COSLoadException)object).setHint(cOSString);
            this.handleWarning((COSLoadWarning)object);
        }
        return cOSString;
    }

    protected int readEOL(IRandomAccess iRandomAccess) throws IOException {
        int n = iRandomAccess.read();
        if (n == -1) {
            return 0;
        }
        if (n == CHAR_CR) {
            n = iRandomAccess.read();
            if (n == -1) {
                return 1;
            }
            if (n == CHAR_LF) {
                n = iRandomAccess.read();
                if (n == -1) {
                    return 1;
                }
                if (PDFParser.isWhitespace(n)) {
                    this.readSpaces(iRandomAccess);
                    return 2;
                }
                iRandomAccess.seekBy(-1L);
                return 1;
            }
            if (PDFParser.isWhitespace(n)) {
                this.readSpaces(iRandomAccess);
                return 2;
            }
            iRandomAccess.seekBy(-1L);
            return 1;
        }
        if (n == CHAR_LF) {
            n = iRandomAccess.read();
            if (n == -1) {
                return 1;
            }
            if (PDFParser.isWhitespace(n)) {
                this.readSpaces(iRandomAccess);
                return 2;
            }
            iRandomAccess.seekBy(-1L);
            return 1;
        }
        if (PDFParser.isWhitespace(n)) {
            this.readSpaces(iRandomAccess);
            return 2;
        }
        iRandomAccess.seekBy(-1L);
        return 0;
    }

    protected int readEscape(IRandomAccess iRandomAccess) throws IOException {
        int n = 0;
        n = iRandomAccess.read();
        if (n == -1) {
            return -1;
        }
        if (PDFParser.isOctalDigit(n)) {
            iRandomAccess.seekBy(-1L);
            return this.readOctalChar(iRandomAccess);
        }
        if (n == CHAR_LF) {
            return -1;
        }
        if (n == CHAR_CR) {
            n = iRandomAccess.read();
            if (n != -1 && n != CHAR_LF) {
                iRandomAccess.seekBy(-1L);
            }
            return -1;
        }
        if (n == 110) {
            return CHAR_LF;
        }
        if (n == 114) {
            return CHAR_CR;
        }
        if (n == 116) {
            return CHAR_HT;
        }
        if (n == 98) {
            return CHAR_BS;
        }
        if (n == 102) {
            return CHAR_FF;
        }
        return n;
    }

    public int readInteger(IRandomAccess iRandomAccess, boolean bl) throws IOException {
        int n;
        block6: {
            int n2;
            n = 0;
            while (true) {
                if ((n2 = iRandomAccess.read()) == -1) {
                    return n;
                }
                if (n2 == 32 || PDFParser.isWhitespace(n2)) continue;
                if (n2 != 37) break;
                this.parseComment(iRandomAccess);
            }
            boolean bl2 = false;
            do {
                if (!PDFParser.isDigit(n2)) {
                    if (!bl2) {
                        throw new IOException("digit expected at " + iRandomAccess.getOffset());
                    }
                    iRandomAccess.seekBy(-1L);
                    break block6;
                }
                bl2 = true;
                n = n * 10 + n2 - 48;
                n2 = iRandomAccess.read();
                if (n2 == -1) break block6;
            } while (n2 != 32 && !PDFParser.isWhitespace(n2));
            if (!bl) {
                iRandomAccess.seekBy(-1L);
            }
        }
        return n;
    }

    protected int readOctalChar(IRandomAccess iRandomAccess) throws IOException {
        int n = -1;
        int n2 = 0;
        n2 = iRandomAccess.read();
        if (PDFParser.isOctalDigit(n2)) {
            n = n2 - 48;
            n2 = iRandomAccess.read();
            if (PDFParser.isOctalDigit(n2)) {
                n = (n << 3) + n2 - 48;
                n2 = iRandomAccess.read();
                if (PDFParser.isOctalDigit(n2)) {
                    n = (n << 3) + n2 - 48;
                } else {
                    if (n2 == -1) {
                        return n;
                    }
                    iRandomAccess.seekBy(-1L);
                }
            } else {
                if (n2 == -1) {
                    return n;
                }
                iRandomAccess.seekBy(-1L);
            }
        } else {
            if (n2 == -1) {
                return n;
            }
            iRandomAccess.seekBy(-1L);
        }
        return n;
    }

    public void readSpaces(IRandomAccess iRandomAccess) throws IOException {
        int n = 0;
        while ((n = iRandomAccess.read()) != -1) {
            if (n == 32 || PDFParser.isWhitespace(n)) continue;
            iRandomAccess.seekBy(-1L);
            break;
        }
    }

    protected byte[] readStream(IRandomAccess iRandomAccess) throws IOException {
        byte[] byArray = new byte[8];
        this.localStream.reset();
        while (true) {
            int n;
            if ((n = iRandomAccess.read()) == 101) {
                iRandomAccess.read(byArray);
                if (Arrays.equals(byArray, TOKEN_ndstream)) {
                    iRandomAccess.seekBy((long)(-TOKEN_endstream.length));
                    return this.localStream.toByteArray();
                }
                iRandomAccess.seekBy((long)(-byArray.length));
            } else if (n == -1) break;
            this.localStream.write(n);
        }
        if (this.localStream.size() == 0) {
            return null;
        }
        return this.localStream.toByteArray();
    }

    public byte[] readToken(IRandomAccess iRandomAccess) throws IOException {
        int n;
        while (true) {
            if ((n = iRandomAccess.read()) == -1) {
                return null;
            }
            if (n == 32 || PDFParser.isWhitespace(n)) continue;
            if (n != 37) break;
            this.parseComment(iRandomAccess);
        }
        return this.readTokenElement(iRandomAccess, n);
    }

    public byte[] readToken(IRandomAccess iRandomAccess, List list, boolean bl) throws IOException {
        int n;
        int n2 = 0;
        boolean bl2 = false;
        while (true) {
            if ((n = iRandomAccess.read()) == -1) {
                return null;
            }
            if (n == 32 || PDFParser.isWhitespace(n)) {
                if (bl || bl2 || n != 32) {
                    ++n2;
                }
                if (!(n2 <= 1 || bl2 && n == 10)) {
                    list.add(C_TOKEN_ADDWSB);
                    continue;
                }
                if (bl && n == 32) {
                    list.add(C_TOKEN_WSB);
                    continue;
                }
                if (n == 13) {
                    bl2 = true;
                    continue;
                }
                bl2 = false;
                continue;
            }
            if (n != 37) break;
            list.add(C_TOKEN_COMMENT);
            this.parseComment(iRandomAccess);
        }
        return this.readTokenElement(iRandomAccess, n, list);
    }

    protected byte[] readTokenElement(IRandomAccess iRandomAccess, int n) throws IOException {
        this.localStream.reset();
        this.localStream.write(n);
        while ((n = iRandomAccess.read()) != -1 && n != 32 && !PDFParser.isWhitespace(n)) {
            if (PDFParser.isDelimiter(n)) {
                iRandomAccess.seekBy(-1L);
                break;
            }
            this.localStream.write(n);
        }
        return this.localStream.toByteArray();
    }

    protected byte[] readTokenElement(IRandomAccess iRandomAccess, int n, List list) throws IOException {
        this.localStream.reset();
        this.localStream.write(n);
        while ((n = iRandomAccess.read()) != -1) {
            if (n == 32 || PDFParser.isWhitespace(n)) {
                if (n == 32) {
                    list.add(C_TOKEN_ADDWSA);
                }
                if ((n = iRandomAccess.read()) == 32) {
                    list.add(C_TOKEN_ADDWSA2);
                }
                if (n == -1) break;
                iRandomAccess.seekBy(-1L);
                break;
            }
            if (PDFParser.isDelimiter(n)) {
                list.add(C_TOKEN_NOWSA);
                iRandomAccess.seekBy(-1L);
                break;
            }
            this.localStream.write(n);
        }
        return this.localStream.toByteArray();
    }

    public void setExceptionHandler(IPDFParserExceptionHandler iPDFParserExceptionHandler) {
        this.exceptionHandler = iPDFParserExceptionHandler;
        this.check = iPDFParserExceptionHandler != null;
    }

    protected void setObjectKey(COSObjectKey cOSObjectKey) {
        this.objectKey = cOSObjectKey;
    }

    protected void setSecurityHandler(ISystemSecurityHandler iSystemSecurityHandler) {
        this.securityHandler = iSystemSecurityHandler;
    }

    protected void unexpectedEndOfInput(IRandomAccess iRandomAccess) throws IOException, COSLoadException {
        COSLoadError cOSLoadError = new COSLoadError("file format error. unexpected end of input at character index " + iRandomAccess.getOffset());
        this.handleError(cOSLoadError);
    }
}

