/*
 * Decompiled with CFR 0.152.
 */
package org.openxml4j.document.wordprocessing.model.table;

import org.dom4j.Element;
import org.dom4j.QName;
import org.openxml4j.document.wordprocessing.WordDocument;
import org.openxml4j.document.wordprocessing.model.table.BorderStyle;

public class TableBorder {
    private BorderStyle lineStyle;
    private int size;
    private int space;
    private String color;
    private final String DEFAULT_COLOR = "auto";

    public TableBorder() {
        this.lineStyle = BorderStyle.BORDER_STYLE_SINGLE;
        this.size = 4;
        this.space = 0;
        this.color = "auto";
    }

    public TableBorder(BorderStyle lineStyle, int size, String color) {
        this.lineStyle = lineStyle;
        this.size = size;
        this.color = color;
        this.space = 0;
    }

    private void addBorderOpenXmlProperties(Element borderElement) {
        borderElement.addAttribute(new QName("val", WordDocument.namespaceWord), this.lineStyle.toString());
        borderElement.addAttribute(new QName("sz", WordDocument.namespaceWord), new Integer(this.size).toString());
        borderElement.addAttribute(new QName("space", WordDocument.namespaceWord), new Integer(this.space).toString());
        borderElement.addAttribute(new QName("color", WordDocument.namespaceWord), this.color);
    }

    public void build(Element tableElement) {
        Element borderXml = tableElement.addElement(new QName("tblBorders", WordDocument.namespaceWord));
        Element borderTopXml = borderXml.addElement(new QName("top", WordDocument.namespaceWord));
        Element borderBottomXml = borderXml.addElement(new QName("bottom", WordDocument.namespaceWord));
        Element borderLeftXml = borderXml.addElement(new QName("left", WordDocument.namespaceWord));
        Element borderRightXml = borderXml.addElement(new QName("right", WordDocument.namespaceWord));
        Element borderInsideVXml = borderXml.addElement(new QName("insideV", WordDocument.namespaceWord));
        Element borderinsideHXml = borderXml.addElement(new QName("insideH", WordDocument.namespaceWord));
        this.addBorderOpenXmlProperties(borderTopXml);
        this.addBorderOpenXmlProperties(borderBottomXml);
        this.addBorderOpenXmlProperties(borderLeftXml);
        this.addBorderOpenXmlProperties(borderRightXml);
        this.addBorderOpenXmlProperties(borderInsideVXml);
        this.addBorderOpenXmlProperties(borderinsideHXml);
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public BorderStyle getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(BorderStyle lineStyle) {
        this.lineStyle = lineStyle;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSpace() {
        return this.space;
    }

    public void setSpace(int space) {
        this.space = space;
    }
}

