/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spc;

import adams.core.Index;
import adams.core.TechnicalInformation;
import adams.data.spc.AbstractControlChart;
import adams.data.spc.Limits;
import adams.data.spc.MatrixControlChart;
import adams.data.statistics.SPCUtils;
import java.util.ArrayList;
import java.util.List;

public class UChart
extends AbstractControlChart
implements MatrixControlChart {
    private static final long serialVersionUID = 4352909660548550374L;
    protected Index m_NonConformitiesIndex;
    protected Index m_SizesIndex;

    public String globalInfo() {
        return "Generates data for a " + this.getName() + ".\n\n" + "For more information see:\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.AUTHOR, "QICacros");
        result.setValue(TechnicalInformation.Field.TITLE, "u Chart Formulas");
        result.setValue(TechnicalInformation.Field.URL, "http://www.qimacros.com/control-chart-formulas/u-chart-formula/");
        return result;
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("non-conform-index", "nonConformitiesIndex", (Object)new Index("1"));
        this.m_OptionManager.add("sizes-index", "sizesIndex", (Object)new Index("2"));
    }

    public void setNonConformitiesIndex(Index value) {
        this.m_NonConformitiesIndex = value;
        this.reset();
    }

    public Index getNonConformitiesIndex() {
        return this.m_NonConformitiesIndex;
    }

    public String nonConformitiesIndexTipText() {
        return "The index of the matrix column containing the non-conformities.";
    }

    public void setSizesIndex(Index value) {
        this.m_SizesIndex = value;
        this.reset();
    }

    public Index getSizesIndex() {
        return this.m_SizesIndex;
    }

    public String sizesIndexTipText() {
        return "The index of the matrix column containing the sample sizes.";
    }

    @Override
    public String getName() {
        return "u chart";
    }

    protected Number[] getSamples(Number[][] data) {
        this.m_SizesIndex.setMax(data[0].length);
        Number[] result = new Number[data.length];
        for (int i = 0; i < data.length; ++i) {
            result[i] = data[i][this.m_SizesIndex.getIntIndex()];
        }
        return result;
    }

    protected Number[] getSizes(Number[][] data) {
        this.m_NonConformitiesIndex.setMax(data[0].length);
        Number[] result = new Number[data.length];
        for (int i = 0; i < data.length; ++i) {
            result[i] = data[i][this.m_NonConformitiesIndex.getIntIndex()];
        }
        return result;
    }

    @Override
    public List<Limits> calculate(Number[][] data) {
        ArrayList<Limits> result = new ArrayList<Limits>();
        for (double[] stats : SPCUtils.stats_u((Number[])this.getSamples(data), (Number[])this.getSizes(data))) {
            result.add(new Limits(stats));
        }
        return result;
    }

    @Override
    public double[] prepare(Number[][] data) {
        return SPCUtils.prepare_data_u((Number[])this.getSamples(data), (Number[])this.getSizes(data));
    }
}

