/*
 * Decompiled with CFR 0.152.
 */
package georegression.metric;

import georegression.misc.GrlConstants;

public class UtilAngle {
    public static double radianToDegree(double angleRad) {
        return 180.0 * angleRad / Math.PI;
    }

    public static double degreeToRadian(double angleDegree) {
        return Math.PI * angleDegree / 180.0;
    }

    public static double atanSafe(double y, double x) {
        if (x == 0.0) {
            return 1.5707963267948966;
        }
        return Math.atan(y / x);
    }

    public static float atanSafe(float y, float x) {
        if (x == 0.0f) {
            return GrlConstants.F_PI / 2.0f;
        }
        return (float)Math.atan(y / x);
    }

    public static double toHalfCircle(double angle) {
        if (angle < 0.0) {
            angle += Math.PI;
        }
        if (angle > 1.5707963267948966) {
            angle -= Math.PI;
        }
        return angle;
    }

    public static float toHalfCircle(float angle) {
        if (angle >= 0.0f) {
            return angle;
        }
        return GrlConstants.F_PI + angle;
    }

    public static boolean isStandardDomain(double ang) {
        return ang <= Math.PI && ang >= -Math.PI;
    }

    public static boolean isHalfDomain(double ang) {
        return ang <= 1.5707963267948966 && ang >= -1.5707963267948966;
    }

    public static double bound(double ang) {
        if ((ang %= GrlConstants.PI2) > Math.PI) {
            return ang - GrlConstants.PI2;
        }
        if (ang < -Math.PI) {
            return ang + GrlConstants.PI2;
        }
        return ang;
    }

    public static double distanceCCW(double angA, double angB) {
        if (angB > angA) {
            return angB - angA;
        }
        return GrlConstants.PI2 - (angA - angB);
    }

    public static double distanceCW(double angA, double angB) {
        if (angA > angB) {
            return angA - angB;
        }
        return GrlConstants.PI2 - (angB - angA);
    }

    public static double minus(double angA, double angB) {
        double diff = angA - angB;
        if (diff > Math.PI) {
            return GrlConstants.PI2 - diff;
        }
        if (diff < -Math.PI) {
            return -GrlConstants.PI2 - diff;
        }
        return diff;
    }

    public static float minus(float angA, float angB) {
        float diff = angA - angB;
        if (diff > GrlConstants.F_PI) {
            return GrlConstants.F_PI2 - diff;
        }
        if (diff < -GrlConstants.F_PI) {
            return -GrlConstants.F_PI2 - diff;
        }
        return diff;
    }

    public static double dist(double angA, double angB) {
        return Math.abs(UtilAngle.minus(angA, angB));
    }

    public static float dist(float angA, float angB) {
        return Math.abs(UtilAngle.minus(angA, angB));
    }

    public static double distHalf(double angA, double angB) {
        double a = Math.abs(angA - angB);
        if (a <= 1.5707963267948966) {
            return a;
        }
        return Math.PI - a;
    }
}

