/*
 * Decompiled with CFR 0.152.
 */
package georegression.misc.autocode;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public class ConvertFile32From64 {
    InputStream in;
    PrintStream out;

    public ConvertFile32From64(File inputFile) throws FileNotFoundException {
        this.in = new FileInputStream(inputFile);
        String inputName = inputFile.getAbsolutePath();
        String outputFileName = inputName.substring(0, inputName.length() - 8) + "F32.java";
        this.out = new PrintStream(outputFileName);
    }

    public void process() throws IOException {
        int n;
        StringBuffer s = new StringBuffer(1024);
        boolean prevChar = false;
        this.copyTheCopyRight(s);
        while ((n = this.in.read()) != -1) {
            if (Character.isWhitespace((char)n)) {
                if (prevChar) {
                    this.handleToken(s.toString());
                    s.delete(0, s.length());
                    prevChar = false;
                }
                this.out.write(n);
                continue;
            }
            prevChar = true;
            s.append((char)n);
        }
        if (prevChar) {
            this.handleToken(s.toString());
        }
        this.out.close();
        this.in.close();
    }

    private void copyTheCopyRight(StringBuffer s) throws IOException {
        int n;
        while ((n = this.in.read()) != -1) {
            char c = (char)n;
            s.append(c);
            if (c != '\n') continue;
            this.out.print(s);
            boolean finished = s.length() == 4 && s.charAt(2) == '/';
            s.delete(0, s.length());
            if (!finished) continue;
            return;
        }
    }

    private void handleToken(String s) {
        s = s.replaceAll("/\\*\\*/double", "FIXED_DOUBLE");
        s = s.replaceAll("double", "float");
        s = s.replaceAll("Double", "Float");
        s = s.replaceAll("_F64", "_F32");
        s = s.replaceAll("DOUBLE_TEST_TOL", "FLOAT_TEST_TOL");
        s = s.replaceAll("GrlConstants.PI2", "GrlConstants.F_PI2");
        s = s.replaceAll("GrlConstants.PId2", "GrlConstants.F_PId2");
        s = s.replaceAll("GrlConstants.EPS", "GrlConstants.F_EPS");
        s = this.replaceStartString(s, "Math.", "(float)Math.");
        s = this.replaceStartString(s, "rand.nextGaussian", "(float)rand.nextGaussian");
        s = this.handleFloats(s);
        s = s.replaceAll("FIXED_DOUBLE", "/\\*\\*/double");
        this.out.print(s);
    }

    private String handleFloats(String input) {
        String regex = "\\d+\\.+\\d+";
        return input.replaceAll(regex, "$0f");
    }

    private String replaceStartString(String input, String from, String to) {
        if (input.startsWith(from)) {
            return to + input.substring(from.length());
        }
        return input;
    }
}

