/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Randomizable;
import adams.core.option.OptionHandler;
import adams.flow.container.WekaTrainTestSetContainer;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractTransformer;
import java.util.Hashtable;
import weka.classifiers.CrossValidationFoldGenerator;
import weka.core.Instances;

public class WekaCrossValidationSplit
extends AbstractTransformer
implements Randomizable,
ProvenanceSupporter {
    private static final long serialVersionUID = 4026105903223741240L;
    public static final String BACKUP_GENERATOR = "generator";
    protected long m_Seed;
    protected int m_Folds;
    protected String m_RelationName;
    protected CrossValidationFoldGenerator m_Generator;

    public String globalInfo() {
        return "Generates train/test pairs like during a cross-validation run. It is possible to generate pairs for leave-one-out cross-validation (LOOCV) as well.\nIt is essential that a class attribute is set. In case of a nominal class attribute, the data gets stratified automatically.\nEach of the pairs gets forwarded as a container. The training set can be accessed in the container with 'Train' and the test set with 'Test'.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("seed", "seed", (Object)1L);
        this.m_OptionManager.add("folds", "folds", (Object)10);
        this.m_OptionManager.add("relation", "relationName", (Object)"@");
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"folds", (Object)this.m_Folds, (String)"folds: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"seed", (Object)this.m_Seed, (String)", seed: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"relationName", (Object)this.m_RelationName, (String)", relation: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    public Class[] generates() {
        return new Class[]{WekaTrainTestSetContainer.class};
    }

    public void setSeed(long value) {
        this.m_Seed = value;
        this.reset();
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed value for the randomization.";
    }

    public void setFolds(int value) {
        if (value >= 2 || value == -1) {
            this.m_Folds = value;
            this.reset();
        } else {
            this.getLogger().severe("Folds must be >=2 or -1 for LOOCV (provided: " + value + ")!");
        }
    }

    public int getFolds() {
        return this.m_Folds;
    }

    public String foldsTipText() {
        return "The folds to use; using '-1' will generate folds for leave-one-out cross-validation (LOOCV).";
    }

    public void setRelationName(String value) {
        this.m_RelationName = value;
    }

    public String getRelationName() {
        return this.m_RelationName;
    }

    public String relationNameTipText() {
        return "The placeholders for creating the relation name: @ = original relation name, $T = type (train/test), $N = current fold number.";
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_GENERATOR);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_Generator != null) {
            result.put(BACKUP_GENERATOR, this.m_Generator);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_GENERATOR)) {
            this.m_Generator = (CrossValidationFoldGenerator)state.get(BACKUP_GENERATOR);
            state.remove(BACKUP_GENERATOR);
        }
        super.restoreState(state);
    }

    protected void reset() {
        super.reset();
        this.m_Generator = null;
    }

    protected String doExecute() {
        String result = null;
        try {
            this.m_Generator = new CrossValidationFoldGenerator((Instances)this.m_InputToken.getPayload(), this.m_Folds, this.m_Seed, true, this.m_RelationName);
        }
        catch (Exception e) {
            result = this.handleException("Failed to initalize fold generator!", e);
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_Generator != null && this.m_Generator.hasNext();
    }

    public Token output() {
        Token result = new Token((Object)this.m_Generator.next());
        this.updateProvenance((ProvenanceContainer)result);
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.DATAGENERATOR, this.m_InputToken.getPayload().getClass(), (AbstractActor)this, ((Token)cont).getPayload().getClass()));
        }
    }

    public void wrapUp() {
        this.m_Generator = null;
        super.wrapUp();
    }
}

