/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Range;
import adams.core.option.OptionHandler;
import adams.flow.container.SequencePlotterContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.ArrayList;
import java.util.List;
import weka.core.Instance;

public class WekaInstanceStreamPlotGenerator
extends AbstractTransformer {
    private static final long serialVersionUID = 6449128249417195569L;
    protected Range m_Attributes;
    protected List<SequencePlotterContainer> m_Containers;
    protected int m_Counter;

    public String globalInfo() {
        return "Generates plot containers from a range of attributes of the weka.core.Instance objects being passed through.\nThe generator merely uses the internal data representation for generating the Y value of the plot container.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("attributes", "attributes", (Object)new Range("first-last"));
    }

    protected void initialize() {
        super.initialize();
        this.m_Attributes = new Range();
        this.m_Containers = new ArrayList<SequencePlotterContainer>();
    }

    protected void reset() {
        super.reset();
        this.m_Containers.clear();
        this.m_Counter = 0;
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"attributes", (Object)this.m_Attributes);
    }

    public void setAttributes(Range value) {
        this.m_Attributes = value;
        this.reset();
    }

    public Range getAttributes() {
        return this.m_Attributes;
    }

    public String attributesTipText() {
        return "The range of attributes to create plot containers for; " + this.m_Attributes.getExample();
    }

    public Class[] accepts() {
        return new Class[]{Instance.class};
    }

    protected String doExecute() {
        String result = null;
        Instance inst = (Instance)this.m_InputToken.getPayload();
        ++this.m_Counter;
        this.m_Containers.clear();
        this.m_Attributes.setMax(inst.numAttributes());
        int[] indices = this.m_Attributes.getIntIndices();
        for (int i = 0; i < indices.length; ++i) {
            SequencePlotterContainer cont = inst.attribute(indices[i]).isNominal() ? new SequencePlotterContainer(inst.dataset().attribute(indices[i]).name(), (Comparable)new Double(this.m_Counter), (Comparable)((Object)inst.stringValue(indices[i]))) : new SequencePlotterContainer(inst.dataset().attribute(indices[i]).name(), (Comparable)new Double(this.m_Counter), (Comparable)Double.valueOf(inst.value(indices[i])));
            this.m_Containers.add(cont);
        }
        return result;
    }

    public Class[] generates() {
        return new Class[]{SequencePlotterContainer.class};
    }

    public boolean hasPendingOutput() {
        return this.m_Containers != null && this.m_Containers.size() > 0;
    }

    public Token output() {
        Token result = new Token((Object)this.m_Containers.get(0));
        this.m_InputToken = null;
        this.m_Containers.remove(0);
        return result;
    }
}

