/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.menu;

import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.ChildFrame;
import adams.gui.application.UserMode;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.GUIHelper;
import adams.gui.menu.AbstractParameterHandlingWekaMenuItemDefinition;
import java.awt.Component;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import weka.gui.treevisualizer.Node;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeBuild;

public class TreeVisualizer
extends AbstractParameterHandlingWekaMenuItemDefinition {
    private static final long serialVersionUID = -771667287275117680L;
    protected JFileChooser m_FileChooser;

    public TreeVisualizer() {
        this(null);
    }

    public TreeVisualizer(AbstractApplicationFrame owner) {
        super(owner);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
        this.m_FileChooser.setDialogTitle("Open DOT graph file...");
        ExtensionFileFilter filter = new ExtensionFileFilter("DOT graph", new String[]{"gv", "dot"});
        this.m_FileChooser.addChoosableFileFilter((FileFilter)filter);
        this.m_FileChooser.setFileFilter((FileFilter)filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch() {
        String filename;
        if (this.m_Parameters.length == 0) {
            int retVal = this.m_FileChooser.showOpenDialog(null);
            if (retVal != 0) {
                return;
            }
            filename = this.m_FileChooser.getSelectedFile().getAbsolutePath();
        } else {
            filename = new PlaceholderFile(this.m_Parameters[0]).getAbsolutePath();
        }
        TreeBuild builder = new TreeBuild();
        Node top = null;
        PlaceNode2 arrange = new PlaceNode2();
        FileReader reader = null;
        try {
            reader = new FileReader(filename);
            top = builder.create((Reader)reader);
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage((Component)this.getOwner(), (String)("Error loading file '" + filename + "':\n" + Utils.throwableToString((Throwable)e)));
            return;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        ChildFrame frame = this.createChildFrame((Component)new weka.gui.treevisualizer.TreeVisualizer(null, top, (NodePlace)arrange), 800, 600);
        frame.setTitle(frame.getTitle() + " - " + filename);
    }

    public String getTitle() {
        return "Tree visualizer";
    }

    public boolean isSingleton() {
        return false;
    }

    public UserMode getUserMode() {
        return UserMode.BASIC;
    }

    @Override
    public String getCategory() {
        return "Visualization";
    }
}

