/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.wizard;

import adams.core.Properties;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionUtils;
import adams.gui.chooser.WekaFileChooser;
import adams.gui.core.BaseListWithButtons;
import adams.gui.wizard.AbstractWizardPage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WekaSelectMultipleDatasetsPage
extends AbstractWizardPage {
    private static final long serialVersionUID = -7633802524155866313L;
    public static final String KEY_FILES = "files";
    protected BaseListWithButtons m_ListFiles;
    protected WekaFileChooser m_FileChooser;
    protected JButton m_ButtonAdd;
    protected JButton m_ButtonRemove;
    protected JButton m_ButtonRemoveAll;
    protected JButton m_ButtonMoveUp;
    protected JButton m_ButtonMoveDown;

    public WekaSelectMultipleDatasetsPage() {
    }

    public WekaSelectMultipleDatasetsPage(String pageName) {
        this();
        this.setPageName(pageName);
    }

    protected void initialize() {
        super.initialize();
        this.m_FileChooser = new WekaFileChooser();
        this.m_FileChooser.setMultiSelectionEnabled(true);
    }

    protected void initGUI() {
        super.initGUI();
        this.m_ListFiles = new BaseListWithButtons(new DefaultListModel());
        this.m_ListFiles.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                WekaSelectMultipleDatasetsPage.this.updateListButtons();
            }
        });
        this.add((Component)this.m_ListFiles, "Center");
        this.m_ButtonAdd = new JButton("Add...");
        this.m_ButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int retVal = WekaSelectMultipleDatasetsPage.this.m_FileChooser.showOpenDialog((Component)((Object)WekaSelectMultipleDatasetsPage.this));
                if (retVal != 0) {
                    return;
                }
                File[] selected = WekaSelectMultipleDatasetsPage.this.m_FileChooser.getSelectedFiles();
                DefaultListModel model = (DefaultListModel)WekaSelectMultipleDatasetsPage.this.m_ListFiles.getModel();
                for (File file : selected) {
                    model.addElement(file.getAbsolutePath());
                }
                WekaSelectMultipleDatasetsPage.this.updateListButtons();
            }
        });
        this.m_ListFiles.addToButtonsPanel((Component)this.m_ButtonAdd);
        this.m_ListFiles.addToButtonsPanel((Component)new JLabel(""));
        this.m_ButtonMoveUp = new JButton("Up");
        this.m_ButtonMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WekaSelectMultipleDatasetsPage.this.m_ListFiles.moveUp();
            }
        });
        this.m_ListFiles.addToButtonsPanel((Component)this.m_ButtonMoveUp);
        this.m_ButtonMoveDown = new JButton("Down");
        this.m_ButtonMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WekaSelectMultipleDatasetsPage.this.m_ListFiles.moveDown();
            }
        });
        this.m_ListFiles.addToButtonsPanel((Component)this.m_ButtonMoveDown);
        this.m_ListFiles.addToButtonsPanel((Component)new JLabel(""));
        this.m_ButtonRemove = new JButton("Remove");
        this.m_ButtonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indices = WekaSelectMultipleDatasetsPage.this.m_ListFiles.getSelectedIndices();
                DefaultListModel model = (DefaultListModel)WekaSelectMultipleDatasetsPage.this.m_ListFiles.getModel();
                for (int i = indices.length - 1; i >= 0; --i) {
                    model.remove(indices[i]);
                }
                WekaSelectMultipleDatasetsPage.this.updateListButtons();
            }
        });
        this.m_ListFiles.addToButtonsPanel((Component)this.m_ButtonRemove);
        this.m_ButtonRemoveAll = new JButton("Remove all");
        this.m_ButtonRemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultListModel model = (DefaultListModel)WekaSelectMultipleDatasetsPage.this.m_ListFiles.getModel();
                model.removeAllElements();
                WekaSelectMultipleDatasetsPage.this.updateListButtons();
            }
        });
        this.m_ListFiles.addToButtonsPanel((Component)this.m_ButtonRemoveAll);
    }

    protected void finishInit() {
        super.finishInit();
        this.updateListButtons();
    }

    protected void updateListButtons() {
        this.m_ButtonAdd.setEnabled(true);
        this.m_ButtonMoveUp.setEnabled(this.m_ListFiles.canMoveUp());
        this.m_ButtonMoveDown.setEnabled(this.m_ListFiles.canMoveDown());
        this.m_ButtonRemove.setEnabled(this.m_ListFiles.getSelectedIndices().length > 0);
        this.m_ButtonRemoveAll.setEnabled(this.m_ListFiles.getModel().getSize() > 0);
        this.updateButtons();
    }

    public void setCurrentDirectory(File value) {
        this.m_FileChooser.setCurrentDirectory((File)new PlaceholderFile(value));
    }

    public File getCurrentDirectory() {
        return this.m_FileChooser.getCurrentDirectory();
    }

    public void setCurrent(File[] value) {
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (File file : value) {
            model.addElement(file.getAbsolutePath());
        }
        this.m_ListFiles.setModel(model);
    }

    public File[] getCurrent() {
        ArrayList<File> result = new ArrayList<File>();
        for (int i = 0; i < this.m_ListFiles.getModel().getSize(); ++i) {
            result.add(new File("" + this.m_ListFiles.getModel().getElementAt(i)));
        }
        return result.toArray(new File[result.size()]);
    }

    public Properties getProperties() {
        Properties result = new Properties();
        ArrayList<String> files = new ArrayList<String>();
        for (int i = 0; i < this.m_ListFiles.getModel().getSize(); ++i) {
            files.add("" + this.m_ListFiles.getModel().getElementAt(i));
        }
        result.setProperty(KEY_FILES, OptionUtils.joinOptions((String[])files.toArray(new String[files.size()])));
        return result;
    }
}

