/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.functions.GaussianProcesses;
import weka.classifiers.functions.supportVector.Kernel;
import weka.classifiers.functions.supportVector.RBFKernel;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.Normalize;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;
import weka.filters.unsupervised.attribute.Standardize;

public class GPD
extends AbstractClassifier
implements WeightedInstancesHandler,
OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -8620066949967678545L;
    protected NominalToBinary m_NominalToBinary;
    public static final int FILTER_NORMALIZE = 0;
    public static final int FILTER_STANDARDIZE = 1;
    public static final int FILTER_NONE = 2;
    public static final Tag[] TAGS_FILTER = new Tag[]{new Tag(0, "Normalize training data"), new Tag(1, "Standardize training data"), new Tag(2, "No normalization/standardization")};
    protected Filter m_Filter = null;
    protected int m_filterType = 0;
    protected ReplaceMissingValues m_Missing;
    protected boolean m_checksTurnedOff = true;
    protected double m_delta = 0.01;
    protected int m_classIndex = -1;
    protected double[][] m_data = null;
    protected double m_gamma = 0.01;
    protected double m_Alin;
    protected double m_Blin;
    protected int m_NumTrain = 0;
    protected double m_avg_target;
    protected double[] m_t;
    protected GaussianProcesses m_FallBack;

    public String globalInfo() {
        return "Implements Gaussian Processes for regression without hyperparameter-tuning, with an inline RBF kernel.\nFor more information see\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.AUTHOR, "David J.C. Mackay");
        result.setValue(TechnicalInformation.Field.YEAR, "1998");
        result.setValue(TechnicalInformation.Field.TITLE, "Introduction to Gaussian Processes");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Dept. of Physics, Cambridge University, UK");
        result.setValue(TechnicalInformation.Field.PS, "http://wol.ra.phy.cam.ac.uk/mackay/gpB.ps.gz");
        return result;
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.addElement(enm.nextElement());
        }
        result.addElement(new Option("\tLevel of Gaussian Noise.\n\t(default: 1.0)", "L", 1, "-L <double>"));
        result.addElement(new Option("\tGamma for the RBF kernel.\n\t(default: 0.01)", "G", 1, "-G <double>"));
        result.addElement(new Option("\tWhether to 0=normalize/1=standardize/2=neither.\n\t(default: 0=normalize)", "N", 1, "-N"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            result.addElement(enu.nextElement());
        }
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((char)'L', (String[])options);
        if (tmpStr.length() != 0) {
            this.setNoise(Double.parseDouble(tmpStr));
        } else {
            this.setNoise(1.0);
        }
        tmpStr = Utils.getOption((char)'G', (String[])options);
        if (tmpStr.length() != 0) {
            this.setGamma(Double.parseDouble(tmpStr));
        } else {
            this.setGamma(0.01);
        }
        tmpStr = Utils.getOption((char)'N', (String[])options);
        if (tmpStr.length() != 0) {
            this.setFilterType(new SelectedTag(Integer.parseInt(tmpStr), TAGS_FILTER));
        } else {
            this.setFilterType(new SelectedTag(0, TAGS_FILTER));
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-G");
        result.add("" + this.getGamma());
        result.add("-L");
        result.add("" + this.getNoise());
        result.add("-N");
        result.add("" + this.m_filterType);
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    public void setFilterType(SelectedTag newType) {
        if (newType.getTags() == TAGS_FILTER) {
            this.m_filterType = newType.getSelectedTag().getID();
        }
    }

    public SelectedTag getFilterType() {
        return new SelectedTag(this.m_filterType, TAGS_FILTER);
    }

    public String filterTypeTipText() {
        return "Determines how/if the data will be transformed.";
    }

    public void setNoise(double v) {
        this.m_delta = v;
    }

    public double getNoise() {
        return this.m_delta;
    }

    public String noiseTipText() {
        return "The level of Gaussian Noise (added to the diagonal of the Covariance Matrix).";
    }

    public void setGamma(double v) {
        this.m_gamma = v;
    }

    public double getGamma() {
        return this.m_gamma;
    }

    public String gammaTipText() {
        return "gamma.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAllAttributes();
        result.disableAllAttributeDependencies();
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.disableAllClasses();
        result.disableAllClassDependencies();
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    protected double[][] choleskyDecomposition(double[][] A) {
        int n = A.length;
        double[][] L = new double[n][n];
        for (int j = 0; j < n; ++j) {
            int k;
            double[] Lrowj = L[j];
            double d = 0.0;
            for (k = 0; k < j; ++k) {
                double[] Lrowk = L[k];
                double s = 0.0;
                for (int i = 0; i < k; ++i) {
                    s += Lrowk[i] * Lrowj[i];
                }
                Lrowj[k] = s = (A[j][k] - s) / L[k][k];
                d += s * s;
            }
            d = A[j][j] - d;
            L[j][j] = 0.0;
            if (d > 0.0) {
                L[j][j] = Math.sqrt(d);
            }
            for (k = j + 1; k < n; ++k) {
                L[j][k] = 0.0;
            }
        }
        return L;
    }

    protected double[] solveChol(double[][] L, double[] b) {
        int i;
        int k;
        int n = b.length;
        double[] X = Arrays.copyOf(b, n);
        for (k = 0; k < n; ++k) {
            for (i = 0; i < k; ++i) {
                int n2 = k;
                X[n2] = X[n2] - X[i] * L[k][i];
            }
            int n3 = k;
            X[n3] = X[n3] / L[k][k];
        }
        for (k = n - 1; k >= 0; --k) {
            for (i = k + 1; i < n; ++i) {
                int n4 = k;
                X[n4] = X[n4] - X[i] * L[i][k];
            }
            int n5 = k;
            X[n5] = X[n5] / L[k][k];
        }
        return X;
    }

    protected double squaredDistance(double[] x, double[] y) {
        int n = x.length;
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            double delta = x[i] - y[i];
            sum += delta * delta;
        }
        return sum;
    }

    protected double rbfKernel(double[] x, double[] y, double gamma) {
        return Math.exp(-gamma * this.squaredDistance(x, y));
    }

    public void buildClassifier(Instances insts) throws Exception {
        int i;
        if (!this.m_checksTurnedOff) {
            this.getCapabilities().testWithFail(insts);
            insts = new Instances(insts);
            insts.deleteWithMissingClass();
        }
        Instances fallbackData = insts;
        if (!this.m_checksTurnedOff) {
            this.m_Missing = new ReplaceMissingValues();
            this.m_Missing.setInputFormat(insts);
            insts = Filter.useFilter((Instances)insts, (Filter)this.m_Missing);
        } else {
            this.m_Missing = null;
        }
        if (this.getCapabilities().handles(Capabilities.Capability.NUMERIC_ATTRIBUTES)) {
            boolean onlyNumeric = true;
            if (!this.m_checksTurnedOff) {
                for (int i2 = 0; i2 < insts.numAttributes(); ++i2) {
                    if (i2 == insts.classIndex() || insts.attribute(i2).isNumeric()) continue;
                    onlyNumeric = false;
                    break;
                }
            }
            if (!onlyNumeric) {
                this.m_NominalToBinary = new NominalToBinary();
                this.m_NominalToBinary.setInputFormat(insts);
                insts = Filter.useFilter((Instances)insts, (Filter)this.m_NominalToBinary);
            } else {
                this.m_NominalToBinary = null;
            }
        } else {
            this.m_NominalToBinary = null;
        }
        this.m_classIndex = insts.classIndex();
        if (this.m_filterType == 1) {
            this.m_Filter = new Standardize();
            ((Standardize)this.m_Filter).setIgnoreClass(true);
            this.m_Filter.setInputFormat(insts);
            insts = Filter.useFilter((Instances)insts, (Filter)this.m_Filter);
        } else if (this.m_filterType == 0) {
            this.m_Filter = new Normalize();
            ((Normalize)this.m_Filter).setIgnoreClass(true);
            this.m_Filter.setInputFormat(insts);
            insts = Filter.useFilter((Instances)insts, (Filter)this.m_Filter);
        } else {
            this.m_Filter = null;
        }
        this.m_NumTrain = insts.numInstances();
        if (this.m_Filter != null) {
            Instance witness = (Instance)insts.instance(0).copy();
            witness.setValue(this.m_classIndex, 0.0);
            this.m_Filter.input(witness);
            this.m_Filter.batchFinished();
            Instance res = this.m_Filter.output();
            this.m_Blin = res.value(this.m_classIndex);
            witness.setValue(this.m_classIndex, 1.0);
            this.m_Filter.input(witness);
            this.m_Filter.batchFinished();
            res = this.m_Filter.output();
            this.m_Alin = res.value(this.m_classIndex) - this.m_Blin;
        } else {
            this.m_Alin = 1.0;
            this.m_Blin = 0.0;
        }
        int n = insts.numInstances();
        int classIndex = this.m_classIndex;
        this.m_t = insts.attributeToDoubleArray(classIndex);
        this.m_data = new double[this.m_t.length][];
        for (int i3 = 0; i3 < n; ++i3) {
            this.m_data[i3] = insts.instance(i3).toDoubleArray();
            this.m_data[i3][classIndex] = 0.0;
        }
        double[][] a = new double[n][n];
        for (int i4 = 0; i4 < n; ++i4) {
            for (int j = 0; j < i4; ++j) {
                double kv;
                a[i4][j] = kv = this.rbfKernel(this.m_data[i4], this.m_data[j], this.m_gamma);
                a[j][i4] = kv;
            }
        }
        double diagonalValue = 1.0 + this.m_delta * this.m_delta;
        for (i = 0; i < a.length; ++i) {
            a[i][i] = diagonalValue;
        }
        this.m_avg_target = Utils.sum((double[])this.m_t) / (double)this.m_t.length;
        i = 0;
        while (i < this.m_t.length) {
            int n2 = i++;
            this.m_t[n2] = this.m_t[n2] - this.m_avg_target;
        }
        double[][] m_chol = this.choleskyDecomposition(a);
        this.m_t = this.solveChol(m_chol, this.m_t);
        this.m_FallBack = null;
        boolean failed = false;
        for (int i5 = 0; i5 < this.m_t.length; ++i5) {
            if (!Double.isNaN(this.m_t[i5])) continue;
            failed = true;
            break;
        }
        if (failed) {
            System.err.println("Choleskey decomposition failed, falling back on default Gaussian Processes algorithm...");
            RBFKernel kernel = new RBFKernel();
            kernel.setGamma(this.getGamma());
            kernel.setChecksTurnedOff(this.m_checksTurnedOff);
            this.m_FallBack = new GaussianProcesses();
            this.m_FallBack.setDoNotCheckCapabilities(this.getDoNotCheckCapabilities());
            this.m_FallBack.setNoise(this.getNoise());
            this.m_FallBack.setKernel((Kernel)kernel);
            this.m_FallBack.setFilterType(new SelectedTag(this.m_filterType, GaussianProcesses.TAGS_FILTER));
            this.m_FallBack.buildClassifier(fallbackData);
        }
    }

    public double classifyInstance(Instance inst) throws Exception {
        if (this.m_FallBack != null) {
            return this.m_FallBack.classifyInstance(inst);
        }
        if (!this.m_checksTurnedOff) {
            this.m_Missing.input(inst);
            this.m_Missing.batchFinished();
            inst = this.m_Missing.output();
        }
        if (this.m_NominalToBinary != null) {
            this.m_NominalToBinary.input(inst);
            this.m_NominalToBinary.batchFinished();
            inst = this.m_NominalToBinary.output();
        }
        if (this.m_Filter != null) {
            this.m_Filter.input(inst);
            this.m_Filter.batchFinished();
            inst = this.m_Filter.output();
        }
        double[] x = inst.toDoubleArray();
        x[this.m_classIndex] = 0.0;
        double result = this.m_avg_target;
        for (int i = 0; i < this.m_NumTrain; ++i) {
            result += this.m_t[i] * this.rbfKernel(x, this.m_data[i], this.m_gamma);
        }
        result = (result - this.m_Blin) / this.m_Alin;
        return result;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        if (this.m_FallBack != null) {
            text.append("Fallback model\n\n");
            text.append(this.m_FallBack.toString());
            return text.toString();
        }
        if (this.m_t == null) {
            return "Gaussian Processes: No model built yet.";
        }
        try {
            text.append("Gaussian Processes\n\n");
            text.append("RBFKernel with gamma = " + this.m_gamma + "\n\n");
            text.append("Average Target Value : " + this.m_avg_target + "\n");
            text.append("Inverted Covariance Matrix * Target-value Vector:\n");
            double min = this.m_t[0];
            double max = this.m_t[0];
            for (int i = 0; i < this.m_NumTrain; ++i) {
                if (this.m_t[i] < min) {
                    min = this.m_t[i];
                    continue;
                }
                if (!(this.m_t[i] > max)) continue;
                max = this.m_t[i];
            }
            text.append("    Lowest Value = " + min + "\n");
            text.append("    Highest Value = " + max + "\n \n");
        }
        catch (Exception e) {
            return "Can't print the classifier.";
        }
        return text.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 11034 $");
    }

    public static void main(String[] args) {
        GPD.runClassifier((Classifier)new GPD(), (String[])args);
    }
}

