/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import adams.data.utils.SAXUtils;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.NormalizableDistance;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.neighboursearch.PerformanceStats;
import weka.filters.unsupervised.attribute.Normalize;

public class SAXDistance
extends NormalizableDistance
implements Cloneable,
TechnicalInformationHandler {
    private static final long serialVersionUID = 2677863364387767459L;
    protected Normalize m_norm = null;
    protected int m_bins = 5;
    protected int m_n = 80;
    protected double[][] m_distMatrix = null;

    public SAXDistance() {
    }

    public SAXDistance(Instances data) {
        super(data);
    }

    protected void initialize() {
        super.initialize();
        double[] get = SAXUtils.calcBreakPoints((int)this.m_bins);
        this.m_distMatrix = SAXUtils.calcDistMatrix((double[])get);
    }

    public String globalInfo() {
        return "Implementing Euclidean distance (or similarity) function.\n\nOne object defines not one distance but the data model in which the distances between objects of that data model can be computed.\n\nAttention: For efficiency reasons the use of consistency checks (like are the data models of the two instances exactly the same), is low.\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tNumber of gaussian bins (>1).\n\t(default: 5)", "bins", 5, "-bins <int>"));
        result.addElement(new Option("\tNumber of Original attributes before SAX (>1).\n\t(default: 80)", "n", 80, "-n <int>"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"bins", (String[])options);
        if (tmpStr.length() > 0) {
            this.setBins(Integer.parseInt(tmpStr));
        } else {
            this.setBins(5);
        }
        tmpStr = Utils.getOption((String)"n", (String[])options);
        if (tmpStr.length() > 0) {
            this.setN(Integer.parseInt(tmpStr));
        } else {
            this.setN(80);
        }
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-bins");
        result.add("" + this.getBins());
        result.add("-n");
        result.add("" + this.getN());
        return result.toArray(new String[result.size()]);
    }

    public void setBins(int value) {
        if (value > 0) {
            this.m_bins = value;
            double[] get = SAXUtils.calcBreakPoints((int)this.m_bins);
            this.m_distMatrix = SAXUtils.calcDistMatrix((double[])get);
        } else {
            System.err.println("'n' must be larger than 0 (provided: " + value + ")!");
        }
    }

    public void setN(int value) {
        if (value > 0) {
            this.m_n = value;
        } else {
            System.err.println("'n' must be larger than 0 (provided: " + value + ")!");
        }
    }

    public int getBins() {
        return this.m_bins;
    }

    public int getN() {
        return this.m_n;
    }

    public String binsPointTipText() {
        return "number of gaussian bins (>0).";
    }

    public String nPointTipText() {
        return "number of pre-sax attribues (>0).";
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Wikipedia");
        result.setValue(TechnicalInformation.Field.TITLE, "Euclidean distance");
        result.setValue(TechnicalInformation.Field.URL, "http://en.wikipedia.org/wiki/Euclidean_distance");
        return result;
    }

    public double distance(Instance first, Instance second) {
        return Math.sqrt((double)this.m_n / (double)first.numAttributes() - 1.0) * Math.sqrt(this.distance(this.transform(first), this.transform(second), Double.POSITIVE_INFINITY));
    }

    public double distance(Instance first, Instance second, PerformanceStats stats) {
        return Math.sqrt((double)this.m_n / (double)first.numAttributes() - 1.0) * Math.sqrt(this.distance(this.transform(first), this.transform(second), Double.POSITIVE_INFINITY, stats));
    }

    protected double updateDistance(double currDist, double diff) {
        double result = currDist;
        return result += diff * diff;
    }

    protected double difference(int index, double val1, double val2) {
        if (val1 < 0.0 || val2 < 0.0 || val1 >= (double)this.m_bins || val2 >= (double)this.m_bins) {
            System.err.println("val out of range! " + val1 + "," + val2);
            return 0.0;
        }
        return this.m_distMatrix[(int)val1][(int)val2];
    }

    public void postProcessDistances(double[] distances) {
        for (int i = 0; i < distances.length; ++i) {
            distances[i] = Math.sqrt((double)this.m_n / ((double)this.m_Data.numAttributes() - 1.0)) * Math.sqrt(distances[i]);
        }
    }

    public double sqDifference(int index, double val1, double val2) {
        double val = this.difference(index, val1, val2);
        return val * val;
    }

    public double getMiddle(double[] ranges) {
        double middle = ranges[0] + ranges[2] * 0.5;
        return middle;
    }

    protected Instance transform(Instance i) {
        return i;
    }

    public boolean valueIsSmallerEqual(Instance instance, int dim, double value) {
        return instance.value(dim) <= value;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 10824 $");
    }
}

