/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import adams.data.weka.rowfinder.AbstractRowFinder;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Add;
import weka.filters.unsupervised.instance.AbstractRowFinderApplier;

public class DatasetLabeler
extends AbstractRowFinderApplier {
    private static final long serialVersionUID = -3519667295906912802L;
    public static final String LABEL_MATCH = "yes";
    public static final String LABEL_NONMATCH = "no";
    public static final String DEFAULT_NAME = "Label";
    protected String m_AttributeName = "Label";
    protected String m_LabelMatch = "yes";
    protected String m_LabelNonMatch = "no";
    protected Add m_AddFilter = null;

    public String globalInfo() {
        return "Adds an additional attribute to the dataset containing a label whether it was a match or not, i.e., whether the row finder selected a particular row or not.";
    }

    @Override
    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement(en.nextElement());
        }
        result.addElement(new Option("\tName of the label attribute.\n\t(default: 'Label')", "name", 1, "-name <name>"));
        result.addElement(new Option("\tThe label for matching rows.\n\t(default: 'yes')", "match", 1, "-match <label>"));
        result.addElement(new Option("\tThe label for non-matching rows.\n\t(default: 'no')", "non-match", 1, "-non-match <label>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"name", (String[])options);
        if (tmpStr.length() == 0) {
            this.setAttributeName(DEFAULT_NAME);
        } else {
            this.setAttributeName(tmpStr);
        }
        tmpStr = Utils.getOption((String)"match", (String[])options);
        if (tmpStr.length() == 0) {
            this.setLabelMatch(LABEL_MATCH);
        } else {
            this.setLabelMatch(tmpStr);
        }
        tmpStr = Utils.getOption((String)"non-match", (String[])options);
        if (tmpStr.length() == 0) {
            this.setLabelMatch(LABEL_NONMATCH);
        } else {
            this.setLabelMatch(tmpStr);
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>(Arrays.asList(super.getOptions()));
        result.add("-name");
        result.add(this.getAttributeName());
        result.add("-match");
        result.add(this.getLabelMatch());
        result.add("-non-match");
        result.add(this.getLabelNonMatch());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String rowFinderTipText() {
        return "The algorithm for locating rows to be labeled as a match (or non-match if inverted).";
    }

    public void setAttributeName(String name) {
        this.m_AttributeName = name;
    }

    public String getAttributeName() {
        return this.m_AttributeName;
    }

    public String attributeNameTipText() {
        return "Set the label attribute's name.";
    }

    public void setLabelMatch(String value) {
        this.m_LabelMatch = value;
    }

    public String getLabelMatch() {
        return this.m_LabelMatch;
    }

    public String labelMatchTipText() {
        return "The label for rows that were a match, ie located by the row finder.";
    }

    public void setLabelNonMatch(String value) {
        this.m_LabelNonMatch = value;
    }

    public String getLabelNonMatch() {
        return this.m_LabelNonMatch;
    }

    public String labelNonMatchTipText() {
        return "The label for rows that were not a match, ie not located by the row finder.";
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        this.m_AddFilter = new Add();
        this.m_AddFilter.setAttributeName(this.m_AttributeName);
        this.m_AddFilter.setAttributeIndex("last");
        this.m_AddFilter.setNominalLabels(this.m_LabelMatch + "," + this.m_LabelNonMatch);
        this.m_AddFilter.setAttributeType(new SelectedTag(1, Add.TAGS_TYPE));
        this.m_AddFilter.setInputFormat(inputFormat);
        return this.m_AddFilter.getOutputFormat();
    }

    @Override
    protected boolean mayRemoveInstances() {
        return true;
    }

    @Override
    protected Instances apply(Instances data, int[] indices) {
        Instances result;
        try {
            result = Filter.useFilter((Instances)data, (Filter)this.m_AddFilter);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to filter data, adding the label attribute!", e);
        }
        int index = result.attribute(this.m_AttributeName).index();
        HashSet<Integer> set = AbstractRowFinder.arrayToHashSet(indices);
        for (int i = 0; i < result.numInstances(); ++i) {
            Instance inst = result.instance(i);
            if (set.contains(i)) {
                inst.setValue(index, this.m_LabelMatch);
                continue;
            }
            inst.setValue(index, this.m_LabelNonMatch);
        }
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 10824 $");
    }
}

