/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment.ext;

import adams.core.Utils;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import weka.core.Instances;
import weka.gui.experiment.ext.AbstractAnalysisPanel;
import weka.gui.experiment.ext.AbstractExperimenterPanel;
import weka.gui.experiment.ext.DefaultAnalysisPanel;
import weka.gui.experiment.ext.ExperimenterPanel;

public class AnalysisPanel
extends AbstractExperimenterPanel {
    private static final long serialVersionUID = -7809897225003422111L;
    protected AbstractAnalysisPanel m_PanelAnalysis;
    protected JComboBox m_ComboBoxPanels;

    protected void initGUI() {
        super.initGUI();
        String[] classes = AbstractAnalysisPanel.getPanels();
        ArrayList<AbstractAnalysisPanel> panels = new ArrayList<AbstractAnalysisPanel>();
        for (int i = 0; i < classes.length; ++i) {
            try {
                if (classes[i].equals(DefaultAnalysisPanel.class.getName())) continue;
                panels.add((AbstractAnalysisPanel)((Object)Class.forName(classes[i]).newInstance()));
                continue;
            }
            catch (Exception e) {
                this.logError("Failed to instantiate analysis panel: " + classes[i], "Analysis panels");
            }
        }
        panels.add(0, new DefaultAnalysisPanel());
        this.m_ComboBoxPanels = new JComboBox<AbstractAnalysisPanel>(panels.toArray(new AbstractAnalysisPanel[panels.size()]));
        this.m_ComboBoxPanels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnalysisPanel.this.updatePanel((AbstractAnalysisPanel)((Object)AnalysisPanel.this.m_ComboBoxPanels.getSelectedItem()));
            }
        });
        JPanel panel = new JPanel(new FlowLayout(0));
        this.add(panel, "North");
        JLabel label = new JLabel("Type");
        label.setLabelFor(this.m_ComboBoxPanels);
        panel.add(label);
        panel.add(this.m_ComboBoxPanels);
    }

    protected void finishInit() {
        super.finishInit();
        this.m_ComboBoxPanels.setSelectedIndex(0);
    }

    @Override
    protected void ownerChanged() {
        super.ownerChanged();
        if (this.getOwner() != null) {
            String preferred = ExperimenterPanel.getProperties().getProperty("ResultsInitialPanel", DefaultAnalysisPanel.class.getName());
            for (int i = 0; i < this.m_ComboBoxPanels.getItemCount(); ++i) {
                if (!this.m_ComboBoxPanels.getItemAt(i).getClass().getName().equals(preferred)) continue;
                this.updatePanel((AbstractAnalysisPanel)((Object)this.m_ComboBoxPanels.getItemAt(i)));
                break;
            }
        }
    }

    protected void updatePanel(AbstractAnalysisPanel panel) {
        Instances results = null;
        if (this.m_PanelAnalysis != null) {
            results = this.m_PanelAnalysis.getResults();
            this.remove((Component)((Object)this.m_PanelAnalysis));
        }
        this.m_PanelAnalysis = (AbstractAnalysisPanel)((Object)Utils.deepCopy((Object)((Object)panel)));
        this.add((Component)((Object)this.m_PanelAnalysis), "Center");
        this.m_PanelAnalysis.setResults(results);
    }

    public String handlesResults(Instances results) {
        if (this.m_PanelAnalysis != null) {
            return this.m_PanelAnalysis.handlesResults(results);
        }
        return "No analysis panel available!";
    }

    public boolean hasResults() {
        return this.getResults() != null;
    }

    public void setResults(Instances value) {
        if (this.m_PanelAnalysis != null) {
            this.m_PanelAnalysis.setResults(value);
        }
    }

    public Instances getResults() {
        if (this.m_PanelAnalysis != null) {
            return this.m_PanelAnalysis.getResults();
        }
        return null;
    }
}

