/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment.ext;

import adams.core.io.PlaceholderFile;
import adams.gui.core.BaseListWithButtons;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import weka.gui.AdamsHelper;
import weka.gui.ConverterFileChooser;
import weka.gui.experiment.ext.AbstractSetupOptionPanel;
import weka.gui.experiment.ext.ExperimenterPanel;

public class DatasetPanel
extends AbstractSetupOptionPanel {
    private static final long serialVersionUID = -832431512063524253L;
    protected ConverterFileChooser m_FileChooser;
    protected JButton m_ButtonAdd;
    protected JButton m_ButtonRemove;
    protected JButton m_ButtonRemoveAll;
    protected JButton m_ButtonUp;
    protected JButton m_ButtonDown;
    protected BaseListWithButtons m_List;
    protected DefaultListModel<File> m_Model;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_FileChooser = new ConverterFileChooser();
        AdamsHelper.updateFileChooserAccessory((JFileChooser)this.m_FileChooser);
        this.m_FileChooser.setMultiSelectionEnabled(true);
        this.m_Model = new DefaultListModel();
    }

    protected void initGUI() {
        super.initGUI();
        this.m_List = new BaseListWithButtons(this.m_Model);
        this.add((Component)this.m_List, "Center");
        this.m_ButtonAdd = new JButton("Add...");
        this.m_ButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int retVal = DatasetPanel.this.m_FileChooser.showOpenDialog((Component)((Object)DatasetPanel.this));
                if (retVal != 0) {
                    return;
                }
                if (DatasetPanel.this.m_FileChooser.getSelectedFiles().length == 0) {
                    return;
                }
                for (File file : DatasetPanel.this.m_FileChooser.getSelectedFiles()) {
                    DatasetPanel.this.m_Model.addElement(file);
                }
                DatasetPanel.this.modified();
            }
        });
        this.m_ButtonRemove = new JButton("Remove");
        this.m_ButtonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indices = DatasetPanel.this.m_List.getSelectedIndices();
                if (indices.length == 0) {
                    return;
                }
                Arrays.sort(indices);
                for (int i = indices.length; i >= 0; --i) {
                    DatasetPanel.this.m_Model.remove(indices[i]);
                }
                DatasetPanel.this.modified();
            }
        });
        this.m_ButtonRemoveAll = new JButton("Remove all");
        this.m_ButtonRemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetPanel.this.m_Model.clear();
                DatasetPanel.this.modified();
            }
        });
        this.m_ButtonUp = new JButton("Up");
        this.m_ButtonUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetPanel.this.m_List.moveUp();
                DatasetPanel.this.modified();
            }
        });
        this.m_ButtonDown = new JButton("Down");
        this.m_ButtonDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetPanel.this.m_List.moveDown();
                DatasetPanel.this.modified();
            }
        });
        this.m_List.addToButtonsPanel((Component)this.m_ButtonAdd);
        this.m_List.addToButtonsPanel((Component)this.m_ButtonRemove);
        this.m_List.addToButtonsPanel((Component)this.m_ButtonRemoveAll);
        this.m_List.addToButtonsPanel((Component)new JLabel(""));
        this.m_List.addToButtonsPanel((Component)this.m_ButtonUp);
        this.m_List.addToButtonsPanel((Component)this.m_ButtonDown);
        this.m_List.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DatasetPanel.this.m_ButtonRemove.setEnabled(DatasetPanel.this.m_List.getSelectedIndices().length > 0);
                DatasetPanel.this.m_ButtonRemoveAll.setEnabled(DatasetPanel.this.m_Model.getSize() > 0);
                DatasetPanel.this.m_ButtonUp.setEnabled(DatasetPanel.this.m_List.canMoveUp());
                DatasetPanel.this.m_ButtonDown.setEnabled(DatasetPanel.this.m_List.canMoveDown());
            }
        });
    }

    @Override
    protected void ownerChanged() {
        super.ownerChanged();
        if (this.getOwner() != null) {
            this.m_FileChooser.setCurrentDirectory(new PlaceholderFile(ExperimenterPanel.getProperties().getPath("DatasetsInitialDir", "%h")).getAbsoluteFile());
        }
    }

    public void setFiles(File[] value) {
        this.m_IgnoreChanges = true;
        this.m_Model.clear();
        for (File file : value) {
            this.m_Model.addElement(file);
        }
        this.m_IgnoreChanges = false;
    }

    public File[] getFiles() {
        File[] result = new File[this.m_Model.getSize()];
        for (int i = 0; i < this.m_Model.getSize(); ++i) {
            result[i] = this.m_Model.getElementAt(i);
        }
        return result;
    }

    @Override
    protected void update() {
        super.update();
        this.m_ButtonRemove.setEnabled(this.m_List.getSelectedIndices().length > 0);
        this.m_ButtonRemoveAll.setEnabled(this.m_Model.getSize() > 0);
        this.m_ButtonUp.setEnabled(this.m_List.canMoveUp());
        this.m_ButtonDown.setEnabled(this.m_List.canMoveDown());
    }
}

